/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.refactoring.organize;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.swt.widgets.Display;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.AST.ASTNode;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.IVisitableNode;
import org.eclipse.titan.designer.AST.Identifier;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.Module;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Definitions;
import org.eclipse.titan.designer.AST.TTCN3.definitions.ImportModule;
import org.eclipse.titan.designer.AST.TTCN3.definitions.TTCN3Module;
import org.eclipse.titan.designer.consoles.TITANDebugConsole;
import org.eclipse.titan.designer.editors.actions.DeclarationCollectionHelper;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.GlobalParser;
import org.eclipse.titan.designer.parsers.ProjectSourceParser;
import org.eclipse.titanium.refactoring.organize.ImportSelectionDialog;
import org.eclipse.titanium.refactoring.organize.ImportText;

public class ChangeCreator {
    private static final String NEWLINE = System.getProperty("line.separator");
    private static boolean sortImports = true;
    private static boolean addImports = true;
    private static boolean removeImports = true;
    private static boolean reportDebug;
    private final IFile selectedFile;
    private Change change;

    ChangeCreator(IFile selectedFile) {
        this.selectedFile = selectedFile;
    }

    public Change getChange() {
        return this.change;
    }

    public void perform() {
        if (this.selectedFile == null) {
            return;
        }
        this.change = this.createFileChange(this.selectedFile);
    }

    private Change createFileChange(IFile toVisit) {
        if (toVisit == null) {
            return null;
        }
        String designerId = "org.eclipse.titan.designer";
        String displayDebugInfo = "org.eclipse.titan.designer.displayDebugInformation";
        reportDebug = Platform.getPreferencesService().getBoolean("org.eclipse.titan.designer", "org.eclipse.titan.designer.displayDebugInformation", false, null);
        ProjectSourceParser sourceParser = GlobalParser.getProjectSourceParser((IProject)toVisit.getProject());
        Module module = sourceParser.containedModule(toVisit);
        if (module == null || !(module instanceof TTCN3Module)) {
            return null;
        }
        TextFileChange tfc = new TextFileChange(toVisit.getName(), toVisit);
        TTCN3Module tModule = (TTCN3Module)module;
        try {
            IDocument doc = tfc.getCurrentDocument(null);
            MultiTextEdit resultEdit = ChangeCreator.organizeImportsEdit(tModule, doc);
            if (!resultEdit.hasChildren()) {
                return null;
            }
            tfc.setEdit((TextEdit)resultEdit);
        }
        catch (BadLocationException e) {
            ErrorReporter.logExceptionStackTrace((String)"Error while organizing imports", (Throwable)e);
        }
        catch (CoreException e1) {
            ErrorReporter.logExceptionStackTrace((String)"Error while organizing imports", (Throwable)e1);
        }
        return tfc;
    }

    public static Location findReferenceInProject(Reference reference, IProject project) {
        ProjectSourceParser projectSourceParser = GlobalParser.getProjectSourceParser((IProject)project);
        ArrayList<DeclarationCollectionHelper> collected = new ArrayList<DeclarationCollectionHelper>();
        Identifier identifier = reference.getId();
        for (String moduleName : projectSourceParser.getKnownModuleNames()) {
            Assignment assignment;
            Module m = projectSourceParser.getModuleByName(moduleName);
            if (m == null || !m.getAssignments().hasLocalAssignmentWithID(CompilationTimeStamp.getBaseTimestamp(), identifier) || (assignment = m.getAssignments().getLocalAssignmentByID(CompilationTimeStamp.getBaseTimestamp(), identifier)) == null) continue;
            collected.add(new DeclarationCollectionHelper(assignment.getProposalDescription(), assignment.getIdentifier().getLocation(), (ASTNode)assignment));
        }
        Location loc = null;
        if (collected.size() > 1) {
            ArrayList<String> files = new ArrayList<String>();
            for (DeclarationCollectionHelper c : collected) {
                files.add(c.location.getFile().getName());
            }
            TITANDebugConsole.println((String[])new String[]{"Multiple possible imports for " + reference.getDisplayName() + ": " + ((Object)files).toString()});
            ImportSelectionDialog dialog = new ImportSelectionDialog(reference, collected, reference.getLocation().getFile());
            Display.getDefault().syncExec((Runnable)dialog);
            loc = dialog.getSelected();
        } else if (collected.size() == 1) {
            DeclarationCollectionHelper declaration = (DeclarationCollectionHelper)collected.get(0);
            loc = declaration.location;
            TITANDebugConsole.println((String[])new String[]{"Exactly one module for " + reference.getDisplayName() + " is found: " + loc.getFile().getName()});
        } else {
            TITANDebugConsole.println((String[])new String[]{"No imports for " + reference.getDisplayName() + " is found"});
        }
        return loc;
    }

    private static MultiTextEdit organizeImportsEdit(TTCN3Module module, IDocument document) throws BadLocationException {
        IProject prj = module.getProject();
        String doc = document.get();
        MultiTextEdit insertEdit = new MultiTextEdit();
        MultiTextEdit removeEdit = new MultiTextEdit();
        ArrayList<ImportText> newImports = new ArrayList<ImportText>();
        ArrayList<ImportText> importsKept = new ArrayList<ImportText>();
        boolean needSorting = false;
        if (addImports) {
            HashSet<String> importNamesAdded = new HashSet<String>();
            for (Reference ref : module.getMissingReferences()) {
                IFile file;
                ProjectSourceParser parser;
                Object addMod;
                String importName;
                Location missLoc = ChangeCreator.findReferenceInProject(ref, prj);
                if (missLoc == null || importNamesAdded.contains(importName = (addMod = (parser = GlobalParser.getProjectSourceParser((IProject)(file = (IFile)missLoc.getFile()).getProject())).containedModule(file)).getIdentifier().getTtcnName())) continue;
                StringBuilder impText = new StringBuilder("import from ").append(importName).append(" all;");
                impText.append(" // Added automatically to resolve ").append(ref.getDisplayName());
                newImports.add(new ImportText(importName, impText.toString() + NEWLINE));
                importNamesAdded.add(importName);
                if (!reportDebug) continue;
                StringBuilder sb = new StringBuilder("For ").append(ref.getDisplayName()).append(": ");
                sb.append(impText.toString());
                TITANDebugConsole.println((String[])new String[]{sb.toString()});
            }
            if (sortImports && !newImports.isEmpty()) {
                needSorting = true;
            }
        }
        if (!needSorting && sortImports) {
            List oldImports = module.getImports();
            int size = oldImports.size();
            for (int i = 0; i < size - 1 && !needSorting; ++i) {
                if (((ImportModule)oldImports.get(i)).getName().compareTo(((ImportModule)oldImports.get(i + 1)).getName()) > 0) {
                    needSorting = true;
                }
                if (((ImportModule)oldImports.get(i)).getLocation().getOffset() <= ((ImportModule)oldImports.get(i + 1)).getLocation().getOffset()) continue;
                needSorting = true;
            }
            if (!needSorting && oldImports.size() > 1) {
                int lastImportOffset = ((ImportModule)oldImports.get(oldImports.size() - 1)).getLocation().getOffset();
                Definitions defs = module.getAssignmentsScope();
                if (defs.getNofAssignments() > 0 && !oldImports.isEmpty()) {
                    int size2 = defs.getNofAssignments();
                    for (int i = 0; i < size2; ++i) {
                        int temp = defs.getAssignmentByIndex(i).getLocation().getOffset();
                        if (temp >= lastImportOffset) continue;
                        needSorting = true;
                    }
                }
            }
        }
        if (needSorting || removeImports) {
            ImportsCheck check = new ImportsCheck();
            module.accept((ASTVisitor)check);
            Set<Module> usedModules = check.getModules();
            for (ImportModule m : module.getImports()) {
                int delLength;
                Identifier importedIdentifier = m.getIdentifier();
                boolean isused = false;
                for (Module m2 : usedModules) {
                    if (!m2.getIdentifier().equals((Object)importedIdentifier)) continue;
                    isused = true;
                }
                Location delImp = m.getLocation();
                IRegion startLineRegion = document.getLineInformationOfOffset(delImp.getOffset());
                IRegion endLineRegion = document.getLineInformationOfOffset(delImp.getEndOffset());
                String delimeter = document.getLineDelimiter(document.getLineOfOffset(delImp.getEndOffset()));
                int n = delLength = delimeter == null ? 0 : delimeter.length();
                if (needSorting || removeImports && !isused) {
                    if (reportDebug) {
                        TITANDebugConsole.println((String[])new String[]{"Removing '" + doc.substring(startLineRegion.getOffset(), endLineRegion.getOffset() + endLineRegion.getLength() + delLength) + "'"});
                        TITANDebugConsole.println((String[])new String[]{"From " + startLineRegion.getOffset() + " till " + (endLineRegion.getOffset() - startLineRegion.getOffset() + endLineRegion.getLength() + delLength)});
                    }
                    removeEdit.addChild((TextEdit)new DeleteEdit(startLineRegion.getOffset(), endLineRegion.getOffset() - startLineRegion.getOffset() + endLineRegion.getLength() + delLength));
                }
                if (!needSorting || removeImports && !isused) continue;
                importsKept.add(new ImportText(m.getName(), doc.substring(startLineRegion.getOffset(), endLineRegion.getOffset() + endLineRegion.getLength() + delLength)));
            }
        }
        if (!newImports.isEmpty() || sortImports && needSorting) {
            int line = document.getLineOfOffset(module.getAssignmentsScope().getLocation().getOffset());
            IRegion lineRegion = document.getLineInformation(line);
            String delimeter = document.getLineDelimiter(line);
            int delimeterLength = delimeter == null ? 0 : delimeter.length();
            int startPos = lineRegion.getOffset() + lineRegion.getLength() + delimeterLength;
            if (sortImports) {
                if (needSorting || !newImports.isEmpty()) {
                    ArrayList<ImportText> results = new ArrayList<ImportText>();
                    results.addAll(importsKept);
                    results.addAll(newImports);
                    Collections.sort(results);
                    for (ImportText i : results) {
                        insertEdit.addChild((TextEdit)new InsertEdit(startPos, i.getText()));
                    }
                }
            } else {
                Collections.sort(newImports);
                for (ImportText i : newImports) {
                    insertEdit.addChild((TextEdit)new InsertEdit(startPos, i.getText()));
                }
            }
        }
        MultiTextEdit resultEdit = new MultiTextEdit();
        if (insertEdit.hasChildren()) {
            resultEdit.addChild((TextEdit)insertEdit);
        }
        if (removeEdit.hasChildren()) {
            resultEdit.addChild((TextEdit)removeEdit);
        }
        return resultEdit;
    }

    static class ImportsCheck
    extends ASTVisitor {
        private final Set<Module> setOfModules = new HashSet<Module>();

        public ImportsCheck() {
            this.setOfModules.clear();
        }

        public Set<Module> getModules() {
            return this.setOfModules;
        }

        public int visit(IVisitableNode node) {
            if (node instanceof Reference) {
                if (((Reference)node).getIsErroneous(CompilationTimeStamp.getBaseTimestamp())) {
                    return 3;
                }
                Assignment assignment = ((Reference)node).getRefdAssignment(CompilationTimeStamp.getBaseTimestamp(), false, null);
                if (assignment != null) {
                    Scope scope = assignment.getMyScope();
                    if (scope != null) {
                        this.setOfModules.add(scope.getModuleScope());
                    }
                    return 3;
                }
            }
            return 3;
        }
    }
}

