/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.manipulation;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jdt.core.manipulation.JavaManipulation;
import org.eclipse.jdt.internal.core.manipulation.JavaManipulationPlugin;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.text.templates.TemplatePersistenceData;
import org.eclipse.text.templates.TemplateReaderWriter;
import org.eclipse.text.templates.TemplateStoreCore;
import org.osgi.service.prefs.BackingStoreException;

public final class ProjectTemplateStore {
    private static final String KEY = "org.eclipse.jdt.ui.text.custom_code_templates";
    private final TemplateStoreCore fInstanceStore = JavaManipulation.getCodeTemplateStore();
    private final TemplateStoreCore fProjectStore;

    public ProjectTemplateStore(IProject project) {
        if (project == null) {
            this.fProjectStore = null;
        } else {
            final IEclipsePreferences projectSettings = new ProjectScope(project).getNode(JavaManipulation.getPreferenceNodeId());
            this.fProjectStore = new TemplateStoreCore(projectSettings, KEY){

                public void add(TemplatePersistenceData data) {
                    this.internalAdd(data);
                }

                public void save() throws IOException {
                    TemplatePersistenceData[] templatePersistenceDataArray = ProjectTemplateStore.this.getTemplateData();
                    int n = templatePersistenceDataArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TemplatePersistenceData templateData = templatePersistenceDataArray[n2];
                        if (ProjectTemplateStore.this.isProjectSpecific(templateData.getId())) {
                            StringWriter output = new StringWriter();
                            TemplateReaderWriter writer = new TemplateReaderWriter();
                            writer.save(this.getTemplateData(false), (Writer)output);
                            projectSettings.put(ProjectTemplateStore.KEY, output.toString());
                            try {
                                projectSettings.flush();
                            }
                            catch (BackingStoreException backingStoreException) {
                                // empty catch block
                            }
                            return;
                        }
                        ++n2;
                    }
                    projectSettings.put(ProjectTemplateStore.KEY, "");
                    try {
                        projectSettings.flush();
                    }
                    catch (BackingStoreException backingStoreException) {
                        // empty catch block
                    }
                }
            };
        }
    }

    public static boolean hasProjectSpecificTempates(IProject project) {
        String pref = new ProjectScope(project).getNode(JavaManipulation.getPreferenceNodeId()).get(KEY, null);
        if (pref != null && pref.trim().length() > 0) {
            StringReader input = new StringReader(pref);
            TemplateReaderWriter reader = new TemplateReaderWriter();
            try {
                TemplatePersistenceData[] datas = reader.read((Reader)input);
                return datas.length > 0;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return false;
    }

    public TemplatePersistenceData[] getTemplateData() {
        if (this.fProjectStore != null) {
            return this.fProjectStore.getTemplateData(true);
        }
        return this.fInstanceStore.getTemplateData(true);
    }

    public Template findTemplateById(String id) {
        Template template = null;
        if (this.fProjectStore != null) {
            template = this.fProjectStore.findTemplateById(id);
        }
        if (template == null) {
            template = this.fInstanceStore.findTemplateById(id);
        }
        return template;
    }

    public void load() throws IOException {
        if (this.fProjectStore != null) {
            this.fProjectStore.load();
            HashSet<String> datas = new HashSet<String>();
            TemplatePersistenceData[] templatePersistenceDataArray = this.fProjectStore.getTemplateData(false);
            int n = templatePersistenceDataArray.length;
            int n2 = 0;
            while (n2 < n) {
                TemplatePersistenceData d = templatePersistenceDataArray[n2];
                datas.add(d.getId());
                ++n2;
            }
            templatePersistenceDataArray = this.fInstanceStore.getTemplateData(false);
            n = templatePersistenceDataArray.length;
            n2 = 0;
            while (n2 < n) {
                TemplatePersistenceData orig = templatePersistenceDataArray[n2];
                if (!datas.contains(orig.getId())) {
                    TemplatePersistenceData copy = new TemplatePersistenceData(new Template(orig.getTemplate()), orig.isEnabled(), orig.getId());
                    this.fProjectStore.add(copy);
                    copy.setDeleted(true);
                }
                ++n2;
            }
        }
    }

    public boolean isProjectSpecific(String id) {
        if (id == null) {
            return false;
        }
        if (this.fProjectStore == null) {
            return false;
        }
        return this.fProjectStore.findTemplateById(id) != null;
    }

    public void setProjectSpecific(String id, boolean projectSpecific) {
        Assert.isNotNull((Object)this.fProjectStore);
        TemplatePersistenceData data = this.fProjectStore.getTemplateData(id);
        if (data == null) {
            return;
        }
        data.setDeleted(!projectSpecific);
    }

    public void restoreDefaults() {
        if (this.fProjectStore == null) {
            this.fInstanceStore.restoreDefaults(false);
        } else {
            try {
                this.load();
            }
            catch (IOException e) {
                JavaManipulationPlugin.log(e);
            }
        }
    }

    public void save() throws IOException {
        if (this.fProjectStore == null) {
            this.fInstanceStore.save();
        } else {
            this.fProjectStore.save();
        }
    }

    public void revertChanges() throws IOException {
        if (this.fProjectStore == null) {
            this.fInstanceStore.load();
        }
    }
}

