/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.bs.gradle.plugin.utils;

import com.microsoft.java.bs.gradle.model.SupportedLanguages;
import com.microsoft.java.bs.gradle.plugin.JavaLanguageModelBuilder;
import com.microsoft.java.bs.gradle.plugin.LanguageModelBuilder;
import com.microsoft.java.bs.gradle.plugin.ScalaLanguageModelBuilder;
import java.util.LinkedList;
import java.util.List;

public class SourceSetUtils {
    private SourceSetUtils() {
    }

    public static String stripPathPrefix(String projectPath) {
        if (projectPath.startsWith(":")) {
            return projectPath.substring(1);
        }
        return projectPath;
    }

    public static String getFullTaskName(String modulePath, String taskName) {
        if (taskName == null) {
            return null;
        }
        if (taskName.isEmpty()) {
            return taskName;
        }
        if (modulePath == null || modulePath.equals(":")) {
            return ":" + taskName;
        }
        return modulePath + ":" + taskName;
    }

    public static List<LanguageModelBuilder> getSupportedLanguageModelBuilders() {
        LinkedList<LanguageModelBuilder> results = new LinkedList<LanguageModelBuilder>();
        for (String language : SourceSetUtils.getSupportedLanguages()) {
            if (language.equalsIgnoreCase(SupportedLanguages.JAVA.getBspName())) {
                results.add(new JavaLanguageModelBuilder());
                continue;
            }
            if (!language.equalsIgnoreCase(SupportedLanguages.SCALA.getBspName())) continue;
            results.add(new ScalaLanguageModelBuilder());
        }
        return results;
    }

    public static String[] getSupportedLanguages() {
        String supportedLanguagesProps = System.getProperty("bsp.gradle.supportedLanguages");
        if (supportedLanguagesProps != null) {
            return supportedLanguagesProps.split(",");
        }
        return new String[0];
    }
}

