/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.javac.dom;

import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.Symbol;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.ILog;
import org.eclipse.jdt.core.IAnnotatable;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.dom.IAnnotationBinding;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMemberValuePairBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.JavacBindingResolver;

public abstract class JavacAnnotationBinding
implements IAnnotationBinding {
    private final JavacBindingResolver resolver;
    private final Attribute.Compound annotation;
    private final IBinding recipient;

    public JavacAnnotationBinding(Attribute.Compound ann, JavacBindingResolver resolver, IBinding recipient) {
        this.resolver = resolver;
        this.annotation = ann;
        this.recipient = recipient;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (!(obj instanceof JavacAnnotationBinding)) return false;
        JavacAnnotationBinding other = (JavacAnnotationBinding)obj;
        if (!Objects.equals((Object)this.resolver, (Object)other.resolver)) return false;
        if (!Objects.equals(this.annotation, other.annotation)) return false;
        if (!Objects.equals(this.getRecipient(), other.getRecipient())) return false;
        return true;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.resolver, this.annotation, this.getRecipient()});
    }

    public IAnnotationBinding[] getAnnotations() {
        return new IAnnotationBinding[0];
    }

    public int getKind() {
        return 5;
    }

    public int getModifiers() {
        return this.getAnnotationTypeOptional().map(ITypeBinding::getModifiers).orElse(0);
    }

    public boolean isDeprecated() {
        return this.getAnnotationTypeOptional().map(IBinding::isDeprecated).orElse(false);
    }

    public boolean isRecovered() {
        return this.getAnnotationTypeOptional().map(IBinding::isRecovered).orElse(false);
    }

    public boolean isSynthetic() {
        return this.getAnnotationTypeOptional().map(IBinding::isSynthetic).orElse(false);
    }

    public IJavaElement getJavaElement() {
        IAnnotatable annot;
        IAnnotation found;
        IJavaElement recipientElement;
        IBinding recipient = this.getRecipient();
        IJavaElement iJavaElement = recipientElement = recipient == null ? null : recipient.getJavaElement();
        if (recipientElement != null && recipientElement instanceof IAnnotatable && (found = (annot = (IAnnotatable)recipientElement).getAnnotation(this.getName())) != null) {
            return found;
        }
        return this.getAnnotationTypeOptional().map(IBinding::getJavaElement).orElse(null);
    }

    public String getKey() {
        StringBuilder builder = new StringBuilder();
        if (this.getRecipient() != null) {
            builder.append(this.getRecipient().getKey());
        }
        builder.append('@');
        ITypeBinding annotationType = this.getAnnotationType();
        if (annotationType != null) {
            builder.append(this.getAnnotationType().getKey());
        } else {
            ILog.get().error("missing annotation type");
        }
        return builder.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isEqualTo(IBinding binding) {
        if (!(binding instanceof IAnnotationBinding)) return false;
        IAnnotationBinding other = (IAnnotationBinding)binding;
        if (!Objects.equals(this.getKey(), other.getKey())) return false;
        return true;
    }

    public IMemberValuePairBinding[] getAllMemberValuePairs() {
        IMemberValuePairBinding[] declared = this.getDeclaredMemberValuePairs();
        ArrayList<IMethodBinding> implicitDefaultMethods = new ArrayList<IMethodBinding>(Arrays.asList(this.getAnnotationType().getDeclaredMethods()));
        Collections.sort(implicitDefaultMethods, new Comparator<IMethodBinding>(this){
            {
                Objects.requireNonNull(this$0);
            }

            @Override
            public int compare(IMethodBinding o1, IMethodBinding o2) {
                String s1 = o1.getName();
                String s2 = o2.getName();
                return Comparator.nullsFirst(String::compareTo).compare(s1, s2);
            }
        });
        List<IMethodBinding> explicitedMethods = Arrays.stream(declared).map(IMemberValuePairBinding::getMethodBinding).toList();
        implicitDefaultMethods.removeAll(explicitedMethods);
        if (implicitDefaultMethods.isEmpty()) {
            return declared;
        }
        Object[] defaults = implicitDefaultMethods.stream().map(this.resolver.bindings::getDefaultMemberValuePairBinding).filter(Objects::nonNull).toArray();
        IMemberValuePairBinding[] res = Arrays.copyOf(declared, declared.length + defaults.length);
        System.arraycopy(defaults, 0, res, declared.length, defaults.length);
        return res;
    }

    public ITypeBinding getAnnotationType() {
        return this.resolver.bindings.getTypeBinding(this.annotation.type);
    }

    public IMemberValuePairBinding[] getDeclaredMemberValuePairs() {
        return (IMemberValuePairBinding[])this.annotation.getElementValues().entrySet().stream().map(entry -> this.resolver.bindings.getMemberValuePairBinding((Symbol.MethodSymbol)entry.getKey(), entry.getValue())).filter(Objects::nonNull).toArray(IMemberValuePairBinding[]::new);
    }

    public String getName() {
        return this.getAnnotationTypeOptional().map(ITypeBinding::getName).orElse(null);
    }

    public String toString() {
        return "@" + this.getName() + "(" + Arrays.stream(this.getAllMemberValuePairs()).map(IBinding::toString).collect(Collectors.joining(",")) + ")";
    }

    public IBinding getRecipient() {
        return this.recipient;
    }

    private Optional<ITypeBinding> getAnnotationTypeOptional() {
        return Optional.ofNullable(this.getAnnotationType());
    }
}

