/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.managers;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.internal.ui.preferences.formatter.ProfileVersionerCore;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class FormatterManager {
    public static final String ENCODING = "UTF-8";
    protected static final String VERSION_KEY_SUFFIX = ".version";
    public static final String CODE_FORMATTER_PROFILE_KIND = "CodeFormatterProfile";
    private static final String XML_NODE_ROOT = "profiles";
    private static final String XML_NODE_PROFILE = "profile";
    private static final String XML_NODE_SETTING = "setting";
    private static final String XML_ATTRIBUTE_ID = "id";
    private static final String XML_ATTRIBUTE_NAME = "name";
    private static final String XML_ATTRIBUTE_PROFILE_KIND = "kind";
    private static final String XML_ATTRIBUTE_VALUE = "value";
    private static final String XML_ATTRIBUTE_VERSION = "version";

    public Map<String, String> readSettingsFromFile(File file, String profileName) throws CoreException {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (FileInputStream reader = new FileInputStream(file);){
                return FormatterManager.readSettingsFromStream(new InputSource(reader), profileName);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(2, "org.eclipse.jdt.ls.core", e.getMessage(), (Throwable)e));
        }
    }

    public static Map<String, String> readSettingsFromStream(InputSource inputSource, String profileName) throws CoreException {
        ProfileDefaultHandler handler = new ProfileDefaultHandler(profileName);
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser parser = factory.newSAXParser();
            parser.parse(inputSource, (DefaultHandler)handler);
        }
        catch (Exception e) {
            throw new CoreException((IStatus)new Status(2, "org.eclipse.jdt.ls.core", e.getMessage(), (Throwable)e));
        }
        int version = handler.getVersion();
        if (handler.getSettings() == null) {
            if (!Objects.equals(profileName, handler.fName)) {
                JavaLanguageServerPlugin.logError("Invalid settings: java.format.settings.profile=" + profileName + ". The '" + profileName + "' profile doesn't exist.");
            } else {
                JavaLanguageServerPlugin.logError("Invalid Formatter settings. Check 'java.format.settings.url' and 'java.format.settings.profile'");
            }
            return Collections.emptyMap();
        }
        if (version == ProfileVersionerCore.getCurrentVersion()) {
            return handler.getSettings();
        }
        return ProfileVersionerCore.updateAndComplete(handler.getSettings(), (int)version);
    }

    private static final class ProfileDefaultHandler
    extends DefaultHandler {
        private String profileName;
        protected String fName;
        private Map<String, String> fSettings;
        private String fKind;
        private int fVersion;
        private boolean reading = false;

        private ProfileDefaultHandler(String profileName) {
            this.profileName = profileName;
            if (this.profileName != null && this.profileName.isBlank()) {
                this.profileName = null;
            }
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (qName.equals(FormatterManager.XML_NODE_SETTING)) {
                if (this.reading) {
                    String key = attributes.getValue(FormatterManager.XML_ATTRIBUTE_ID);
                    String value = attributes.getValue(FormatterManager.XML_ATTRIBUTE_VALUE);
                    this.fSettings.put(key, value);
                }
            } else if (qName.equals(FormatterManager.XML_NODE_PROFILE)) {
                this.fName = attributes.getValue(FormatterManager.XML_ATTRIBUTE_NAME);
                if (this.profileName == null || this.profileName.equals(this.fName)) {
                    this.reading = true;
                    this.fKind = attributes.getValue(FormatterManager.XML_ATTRIBUTE_PROFILE_KIND);
                    if (this.fKind == null) {
                        this.fKind = FormatterManager.CODE_FORMATTER_PROFILE_KIND;
                    }
                    this.fSettings = new HashMap<String, String>(200);
                    try {
                        this.fVersion = Integer.parseInt(attributes.getValue(FormatterManager.XML_ATTRIBUTE_VERSION));
                    }
                    catch (NumberFormatException e) {
                        this.fVersion = ProfileVersionerCore.getCurrentVersion();
                    }
                }
            } else {
                qName.equals(FormatterManager.XML_NODE_ROOT);
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) {
            if (qName.equals(FormatterManager.XML_NODE_PROFILE) && this.reading) {
                this.reading = false;
            }
        }

        private Map<String, String> getSettings() {
            return this.fSettings;
        }

        public int getVersion() {
            return this.fVersion;
        }
    }
}

