/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core;

import com.google.common.base.Preconditions;
import java.io.File;
import org.eclipse.buildship.core.GradleDistribution;
import org.eclipse.buildship.core.internal.i18n.CoreMessages;
import org.eclipse.osgi.util.NLS;
import org.gradle.tooling.GradleConnector;

public final class LocalGradleDistribution
extends GradleDistribution {
    private final File location;

    LocalGradleDistribution(File location) {
        this.location = (File)Preconditions.checkNotNull((Object)location);
    }

    public File getLocation() {
        return this.location;
    }

    @Override
    public void apply(GradleConnector connector) {
        connector.useInstallation(this.location);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.location == null ? 0 : this.location.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LocalGradleDistribution other = (LocalGradleDistribution)obj;
        return !(this.location == null ? other.location != null : !this.location.equals(other.location));
    }

    public String toString() {
        return String.format("GRADLE_DISTRIBUTION(LOCAL_INSTALLATION(%s))", this.location.getPath());
    }

    @Override
    public String getDisplayName() {
        return NLS.bind((String)CoreMessages.GradleDistribution_Value_UseLocalInstallation_0, (Object)this.location.getAbsolutePath());
    }
}

