/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.extension;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.function.Predicate;
import org.junit.jupiter.api.AutoClose;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.ExtensionConfigurationException;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestInstancePreDestroyCallback;
import org.junit.platform.commons.logging.Logger;
import org.junit.platform.commons.logging.LoggerFactory;
import org.junit.platform.commons.util.AnnotationUtils;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.commons.util.ReflectionUtils;
import org.junit.platform.commons.util.StringUtils;
import org.junit.platform.engine.support.hierarchical.ThrowableCollector;

class AutoCloseExtension
implements TestInstancePreDestroyCallback,
AfterAllCallback {
    private static final Logger logger = LoggerFactory.getLogger(AutoCloseExtension.class);

    AutoCloseExtension() {
    }

    public void preDestroyTestInstance(ExtensionContext context) {
        ThrowableCollector throwableCollector = new ThrowableCollector(__ -> false);
        TestInstancePreDestroyCallback.preDestroyTestInstances((ExtensionContext)context, testInstance -> AutoCloseExtension.closeFields(testInstance.getClass(), testInstance, throwableCollector));
        throwableCollector.assertEmpty();
    }

    public void afterAll(ExtensionContext context) {
        ThrowableCollector throwableCollector = new ThrowableCollector(__ -> false);
        AutoCloseExtension.closeFields(context.getRequiredTestClass(), null, throwableCollector);
        throwableCollector.assertEmpty();
    }

    private static void closeFields(Class<?> testClass, Object testInstance, ThrowableCollector throwableCollector) {
        Predicate<Field> predicate = testInstance == null ? ReflectionUtils::isStatic : ReflectionUtils::isNotStatic;
        AnnotationUtils.findAnnotatedFields(testClass, AutoClose.class, predicate, (ReflectionUtils.HierarchyTraversalMode)ReflectionUtils.HierarchyTraversalMode.BOTTOM_UP).forEach(field -> throwableCollector.execute(() -> AutoCloseExtension.closeField(field, testInstance)));
    }

    private static void closeField(Field field, Object testInstance) throws Exception {
        String methodName = ((AutoClose)AnnotationUtils.findAnnotation((AnnotatedElement)field, AutoClose.class).get()).value();
        Class<?> fieldType = field.getType();
        AutoCloseExtension.checkCondition(StringUtils.isNotBlank((String)methodName), "@AutoClose on field %s must specify a method name.", field);
        AutoCloseExtension.checkCondition(!fieldType.isPrimitive(), "@AutoClose is not supported on primitive field %s.", field);
        AutoCloseExtension.checkCondition(!fieldType.isArray(), "@AutoClose is not supported on array field %s.", field);
        Object fieldValue = ReflectionUtils.tryToReadFieldValue((Field)field, (Object)testInstance).get();
        if (fieldValue == null) {
            logger.warn(() -> String.format("Cannot @AutoClose field %s because it is null.", AutoCloseExtension.getQualifiedName(field)));
        } else {
            AutoCloseExtension.invokeCloseMethod(field, fieldValue, methodName.trim());
        }
    }

    private static void invokeCloseMethod(Field field, Object target, String methodName) throws Exception {
        if (target instanceof AutoCloseable && "close".equals(methodName)) {
            ((AutoCloseable)target).close();
            return;
        }
        Class<?> targetType = target.getClass();
        Method closeMethod = (Method)ReflectionUtils.findMethod(targetType, (String)methodName, (Class[])new Class[0]).orElseThrow(() -> new ExtensionConfigurationException(String.format("Cannot @AutoClose field %s because %s does not define method %s().", AutoCloseExtension.getQualifiedName(field), targetType.getName(), methodName)));
        closeMethod = ReflectionUtils.getInterfaceMethodIfPossible((Method)closeMethod, targetType);
        ReflectionUtils.invokeMethod((Method)closeMethod, (Object)target, (Object[])new Object[0]);
    }

    private static void checkCondition(boolean condition, String messageFormat, Field field) {
        Preconditions.condition((boolean)condition, () -> String.format(messageFormat, AutoCloseExtension.getQualifiedName(field)));
    }

    private static String getQualifiedName(Field field) {
        String typeName = field.getDeclaringClass().getCanonicalName();
        if (typeName == null) {
            typeName = field.getDeclaringClass().getTypeName();
        }
        return typeName + "." + field.getName();
    }
}

