/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.internal.marker;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.buildship.core.internal.CorePlugin;
import org.eclipse.buildship.core.internal.marker.ErrorMarkerLocation;
import org.eclipse.buildship.core.internal.marker.GradleErrorMarker;
import org.eclipse.buildship.core.internal.operation.ToolingApiStatus;
import org.eclipse.buildship.core.internal.util.string.StringUtils;
import org.eclipse.buildship.core.internal.workspace.InternalGradleBuild;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;

public class GradleMarkerManager {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");

    private GradleMarkerManager() {
    }

    public static void clear(InternalGradleBuild gradleBuild) {
        try {
            for (IMarker marker : ResourcesPlugin.getWorkspace().getRoot().findMarkers("org.eclipse.buildship.core.errormarker", false, 2)) {
                if (!GradleErrorMarker.belongsToBuild(marker, gradleBuild)) continue;
                marker.delete();
            }
        }
        catch (CoreException e) {
            CorePlugin.getInstance().getLog().log(e.getStatus());
        }
    }

    public static void addError(InternalGradleBuild gradleBuild, ToolingApiStatus status) {
        ErrorMarkerLocation errorLocation = ErrorMarkerLocation.findErrorLocation(gradleBuild, status.getException());
        GradleErrorMarker.createError(errorLocation.getResource(), gradleBuild, GradleMarkerManager.collectErrorMessages(status.getException()), status.getException(), errorLocation.getLineNumber());
    }

    private static String collectErrorMessages(Throwable t) {
        ArrayList messages = Lists.newArrayList();
        Throwable cause = t.getCause();
        if (cause != null) {
            GradleMarkerManager.collectCausesRecursively(cause, messages);
        }
        String messageStack = Joiner.on((String)LINE_SEPARATOR).join(StringUtils.removeAdjacentDuplicates(messages));
        return t.getMessage() + (String)(messageStack.isEmpty() ? "" : LINE_SEPARATOR + messageStack);
    }

    private static void collectCausesRecursively(Throwable t, List<String> messages) {
        List singleLineMessages = Splitter.on((String)LINE_SEPARATOR).omitEmptyStrings().splitToList((CharSequence)Strings.nullToEmpty((String)t.getMessage()));
        messages.addAll(singleLineMessages);
        Throwable cause = t.getCause();
        if (cause != null) {
            GradleMarkerManager.collectCausesRecursively(cause, messages);
        }
    }
}

