/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.reorg;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.internal.core.manipulation.JavaElementLabelsCore;
import org.eclipse.jdt.internal.corext.refactoring.Checks;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.reorg.ICreateTargetQueries;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.resource.ResourceChange;

public final class LoggedCreateTargetChange
extends ResourceChange {
    private final ICreateTargetQueries fQueries;
    private Object fSelection;

    public LoggedCreateTargetChange(Object selection, ICreateTargetQueries queries) {
        this.fSelection = selection;
        this.fQueries = queries;
    }

    protected IResource getModifiedResource() {
        return null;
    }

    public String getName() {
        return RefactoringCoreMessages.LoggedCreateTargetChange_change_name;
    }

    public RefactoringStatus isValid(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        IResource resource;
        if (this.fSelection instanceof IJavaElement) {
            IJavaElement element = (IJavaElement)this.fSelection;
            if (!Checks.isAvailable(element)) {
                RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.RenameResourceChange_does_not_exist, JavaElementLabelsCore.getTextLabel(this.fSelection, 0x200009L)));
            }
        } else if (this.fSelection instanceof IResource && !(resource = (IResource)this.fSelection).exists()) {
            RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.RenameResourceChange_does_not_exist, JavaElementLabelsCore.getTextLabel(this.fSelection, 0x200009L)));
        }
        return new RefactoringStatus();
    }

    public Change perform(IProgressMonitor monitor) throws CoreException {
        this.fQueries.createNewPackageQuery().getCreatedTarget(this.fSelection);
        return null;
    }
}

