/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.javac;

import com.sun.source.doctree.DocCommentTree;
import com.sun.source.doctree.DocTree;
import com.sun.source.doctree.LinkTree;
import com.sun.source.doctree.SeeTree;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.ImportTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.DocTreeScanner;
import com.sun.source.util.TreeScanner;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.parser.Tokens;
import com.sun.tools.javac.tree.DCTree;
import com.sun.tools.javac.tree.JCTree;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;
import org.eclipse.jdt.core.compiler.CategorizedProblem;
import org.eclipse.jdt.internal.compiler.IProblemFactory;
import org.eclipse.jdt.internal.compiler.env.AccessRestriction;
import org.eclipse.jdt.internal.compiler.env.INameEnvironment;
import org.eclipse.jdt.internal.compiler.env.NameEnvironmentAnswer;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.problem.AbortCompilation;
import org.eclipse.jdt.internal.compiler.problem.ProblemReporter;

public class AccessRestrictionTreeScanner
extends TreeScanner<Void, Void> {
    private static final byte TYPE_ACCESS = 0;
    private static final byte FIELD_ACCESS = 4;
    private static final byte CONSTRUCTOR_ACCESS = 8;
    private static final byte METHOD_ACCESS = 12;
    private static final Set<String> UNINTERESTING_FIELDS = new HashSet<String>();
    private INameEnvironment nameEnvironment;
    private IProblemFactory problemFactory;
    private CompilerOptions compilerOptions;
    private List<CategorizedProblem> accessRestrictionProblems = new ArrayList<CategorizedProblem>();
    private JCTree.JCCompilationUnit unit = null;
    private boolean isWarningSuppressed = false;
    private int suppressedWarningsCount = 0;
    static final String SUPPRESS_WARNINGS = "java.lang.SuppressWarnings";
    static final String RESTRICTION = "\"restriction\"";
    static final String[] UNNECESSARY_SUPPRESS_ARGS;

    public AccessRestrictionTreeScanner(INameEnvironment nameEnvironment, IProblemFactory problemFactory, CompilerOptions compilerOptions) {
        this.nameEnvironment = nameEnvironment;
        this.problemFactory = problemFactory;
        this.compilerOptions = compilerOptions;
    }

    @Override
    public Void scan(Tree tree, Void p) {
        JCTree jcTree;
        Tokens.Comment c;
        if (tree == null) {
            return (Void)super.scan(tree, p);
        }
        if (this.unit != null && tree instanceof JCTree && (c = this.unit.docComments.getComment(jcTree = (JCTree)tree)) != null && (c.getStyle() == Tokens.Comment.CommentStyle.JAVADOC_BLOCK || c.getStyle() == Tokens.Comment.CommentStyle.JAVADOC_LINE)) {
            AccessRestrictionDocTreeScanner docTreeScanner = new AccessRestrictionDocTreeScanner(this, c::getSourcePos);
            DocCommentTree docCommentTree = this.unit.docComments.getCommentTree(jcTree);
            docTreeScanner.scan(docCommentTree, p);
        }
        return (Void)super.scan(tree, p);
    }

    @Override
    public Void visitCompilationUnit(CompilationUnitTree node, Void p) {
        this.unit = (JCTree.JCCompilationUnit)node;
        return (Void)super.visitCompilationUnit(node, p);
    }

    @Override
    public Void visitImport(ImportTree node, Void p) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void visitClass(ClassTree node, Void p) {
        boolean oldWarningSuppressed = this.isWarningSuppressed;
        int oldNumSuppressedWarnings = this.suppressedWarningsCount;
        JCTree restrictionStrNode = AccessRestrictionTreeScanner.getSuppressWarningsRestriction(node.getModifiers());
        try {
            boolean bl = this.isWarningSuppressed = oldWarningSuppressed || restrictionStrNode != null;
            if (oldWarningSuppressed && restrictionStrNode != null) {
                this.addUnnecessarySuppressWarnings(restrictionStrNode);
            }
            Void void_ = (Void)super.visitClass(node, p);
            return void_;
        }
        finally {
            this.isWarningSuppressed = oldWarningSuppressed;
            if (oldNumSuppressedWarnings == this.suppressedWarningsCount && restrictionStrNode != null) {
                this.addUnnecessarySuppressWarnings(restrictionStrNode);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void visitMethod(MethodTree node, Void p) {
        boolean oldWarningSuppressed = this.isWarningSuppressed;
        int oldNumSuppressedWarnings = this.suppressedWarningsCount;
        JCTree restrictionStrNode = AccessRestrictionTreeScanner.getSuppressWarningsRestriction(node.getModifiers());
        try {
            boolean bl = this.isWarningSuppressed = oldWarningSuppressed || restrictionStrNode != null;
            if (oldWarningSuppressed && restrictionStrNode != null) {
                this.addUnnecessarySuppressWarnings(restrictionStrNode);
            }
            Void void_ = (Void)super.visitMethod(node, p);
            return void_;
        }
        finally {
            this.isWarningSuppressed = oldWarningSuppressed;
            if (oldNumSuppressedWarnings == this.suppressedWarningsCount && restrictionStrNode != null) {
                this.addUnnecessarySuppressWarnings(restrictionStrNode);
            }
        }
    }

    @Override
    public Void visitMemberSelect(MemberSelectTree node, Void p) {
        Symbol.TypeSymbol typeSym;
        JCTree.JCFieldAccess fieldAccess = (JCTree.JCFieldAccess)node;
        if (fieldAccess.selected.type == null || fieldAccess.selected.type.isErroneous()) {
            return (Void)super.visitMemberSelect(node, p);
        }
        Symbol.TypeSymbol sym = fieldAccess.selected.type.tsym;
        String fqn = AccessRestrictionTreeScanner.getQualifiedName(sym);
        String fieldName = fieldAccess.name.toString();
        if (!(sym instanceof Symbol.TypeSymbol) || (typeSym = sym).members() == null) {
            return (Void)super.visitMemberSelect(node, p);
        }
        if (sym instanceof Symbol.PackageSymbol) {
            Symbol.PackageSymbol packageSym = (Symbol.PackageSymbol)sym;
            int startPos = fieldAccess.getStartPosition();
            int endPos = fieldAccess.getEndPosition(this.unit.endPositions) - 1;
            if (endPos == -1) {
                endPos = fieldAccess.toString().length();
            }
            for (Symbol elt : packageSym.getEnclosedElements()) {
                if (!fieldName.equals(elt.getSimpleName().toString())) continue;
                this.collectProblemForFQN(fqn + "." + fieldName, startPos, endPos, (byte)0, null);
                break;
            }
            return (Void)super.visitMemberSelect(node, p);
        }
        boolean isField = false;
        int startPos = fieldAccess.selected.getEndPosition(this.unit.endPositions) + 1;
        int endPos = startPos + fieldAccess.name.length() - 1;
        for (Symbol elt : typeSym.getEnclosedElements()) {
            if (!fieldName.equals(elt.getSimpleName().toString()) || !(elt instanceof Symbol.VarSymbol)) continue;
            isField = true;
        }
        if (!UNINTERESTING_FIELDS.contains(fieldName)) {
            Type type = fieldAccess.type;
            if (type instanceof Type.MethodType) {
                Type.MethodType methodType = (Type.MethodType)type;
                this.collectProblemForFQN(fqn, startPos, endPos, (byte)12, AccessRestrictionTreeScanner.toDisplayString(fieldAccess.name.toString(), methodType));
            } else if (isField) {
                this.collectProblemForFQN(fqn, startPos, endPos, (byte)4, fieldAccess.name.toString());
            } else {
                this.collectProblemForFQN(fqn + "$" + fieldName, startPos, endPos, (byte)0, null);
            }
        }
        return (Void)super.visitMemberSelect(node, p);
    }

    @Override
    public Void visitIdentifier(IdentifierTree node, Void p) {
        if (this.unit == null) {
            return (Void)super.visitIdentifier(node, p);
        }
        JCTree.JCIdent ident = (JCTree.JCIdent)node;
        String fqn = null;
        int accessKind = 0;
        String memberName = null;
        Symbol symbol = ident.sym;
        if (symbol instanceof Symbol.ClassSymbol) {
            Symbol.ClassSymbol classSymbol = (Symbol.ClassSymbol)symbol;
            fqn = AccessRestrictionTreeScanner.getQualifiedName(classSymbol);
        } else {
            symbol = ident.sym;
            if (symbol instanceof Symbol.MethodSymbol) {
                Symbol.MethodSymbol methodSymbol = (Symbol.MethodSymbol)symbol;
                if (methodSymbol.isConstructor()) {
                    Type type = methodSymbol.type;
                    if (type instanceof Type.MethodType) {
                        Type.MethodType methodType = (Type.MethodType)type;
                        memberName = AccessRestrictionTreeScanner.toDisplayString(methodSymbol.owner.getSimpleName().toString(), methodType);
                    } else {
                        type = methodSymbol.type;
                        if (type instanceof Type.ForAll) {
                            Type.ForAll forAllType = (Type.ForAll)type;
                            memberName = AccessRestrictionTreeScanner.toDisplayString(methodSymbol.owner.getSimpleName().toString(), forAllType.asMethodType());
                        } else {
                            throw new IllegalStateException("Excepted a method; this isn't one????");
                        }
                    }
                    accessKind = 8;
                } else {
                    memberName = AccessRestrictionTreeScanner.toDisplayString(methodSymbol);
                    accessKind = 12;
                }
                cursor = methodSymbol;
                while (cursor != null && !(cursor instanceof Symbol.ClassSymbol)) {
                    cursor = cursor.owner;
                }
                if (cursor != null) {
                    fqn = AccessRestrictionTreeScanner.getQualifiedName(cursor);
                }
            } else {
                cursor = ident.sym;
                if (cursor instanceof Symbol.VarSymbol) {
                    Symbol.VarSymbol varSymbol = (Symbol.VarSymbol)cursor;
                    memberName = varSymbol.toString();
                    cursor = varSymbol;
                    while (cursor != null && !(cursor instanceof Symbol.ClassSymbol)) {
                        cursor = cursor.owner;
                    }
                    if (cursor != null) {
                        fqn = AccessRestrictionTreeScanner.getQualifiedName(cursor);
                    }
                    accessKind = 4;
                }
            }
        }
        this.collectProblemForFQN(fqn, ident, (byte)accessKind, memberName);
        return (Void)super.visitIdentifier(node, p);
    }

    @Override
    public Void visitNewClass(NewClassTree node, Void p) {
        Type.MethodType constructorMethodType;
        Type type;
        JCTree.JCNewClass newClassNode = (JCTree.JCNewClass)node;
        if (newClassNode.constructor == null || !((type = newClassNode.constructorType) instanceof Type.MethodType) || (constructorMethodType = (Type.MethodType)type).isErroneous()) {
            return (Void)super.visitNewClass(newClassNode, p);
        }
        String fqn = AccessRestrictionTreeScanner.getQualifiedName(newClassNode.constructor.owner);
        String simpleName = AccessRestrictionTreeScanner.getSimpleNameFromFQN(fqn);
        this.collectProblemForFQN(fqn, newClassNode.getIdentifier(), (byte)8, AccessRestrictionTreeScanner.toDisplayString(simpleName, constructorMethodType));
        return (Void)super.visitNewClass(node, p);
    }

    private static JCTree getSuppressWarningsRestriction(ModifiersTree modifiers) {
        for (AnnotationTree annotationTree : modifiers.getAnnotations()) {
            JCTree.JCAnnotation jcAnnotation = (JCTree.JCAnnotation)annotationTree;
            if (jcAnnotation == null || jcAnnotation.annotationType == null || jcAnnotation.annotationType.type == null || jcAnnotation.annotationType.type.tsym == null || !SUPPRESS_WARNINGS.equals(jcAnnotation.annotationType.type.tsym.getQualifiedName().toString())) continue;
            for (JCTree.JCExpression expr : jcAnnotation.args) {
                if (expr instanceof JCTree.JCAssign) {
                    JCTree.JCAssign jcAssign = (JCTree.JCAssign)expr;
                    if (!RESTRICTION.equals(jcAssign.rhs.toString())) continue;
                    return jcAssign.rhs;
                }
                if (!(expr instanceof JCTree.JCLiteral) || !RESTRICTION.equals(expr.toString())) continue;
                return expr;
            }
        }
        return null;
    }

    private void addUnnecessarySuppressWarnings(JCTree nodeForRange) {
        int startPos = nodeForRange.getStartPosition();
        int endPos = nodeForRange.getEndPosition(this.unit.endPositions) - 1;
        int line = this.unit.getLineMap().getLineNumber(startPos);
        int column = this.unit.getLineMap().getColumnNumber(startPos);
        this.accessRestrictionProblems.add(this.problemFactory.createProblem(this.unit.getSourceFile().getName().toCharArray(), 536871547, UNNECESSARY_SUPPRESS_ARGS, 0, UNNECESSARY_SUPPRESS_ARGS, this.toSeverity(536871547), startPos, endPos, line, column));
    }

    private void collectProblemForFQN(String fqn, JCTree node, byte accessType, String memberName) {
        int startPos = node.getStartPosition();
        int endPos = node.getEndPosition(this.unit.endPositions) - 1;
        this.collectProblemForFQN(fqn, startPos, endPos, accessType, memberName);
    }

    private void collectProblemForFQN(String fqn, int startPos, int endPos, byte accessType, String memberName) {
        if (fqn == null || fqn.isEmpty() || fqn.equals(this.getCurrentUnitFQN())) {
            return;
        }
        if (startPos == -1) {
            return;
        }
        char[][] fqnChar = (char[][])Stream.of(fqn.split("\\.")).map(String::toCharArray).toArray(x$0 -> new char[x$0][]);
        NameEnvironmentAnswer ans = null;
        try {
            ans = this.nameEnvironment.findType(fqnChar);
        }
        catch (AbortCompilation abortCompilation) {
            // empty catch block
        }
        if (ans != null && ans.getAccessRestriction() != null) {
            AccessRestriction accessRestriction = ans.getAccessRestriction();
            if (accessRestriction.getProblemId() == 0x1000133 || !this.isWarningSuppressed) {
                this.accessRestrictionProblems.add(this.toCategorizedProblem(startPos, endPos, fqn, accessRestriction, accessType, memberName));
            } else if (this.isWarningSuppressed) {
                ++this.suppressedWarningsCount;
            }
        }
    }

    private CategorizedProblem toCategorizedProblem(int startPos, int endPos, String fqn, AccessRestriction accessRestriction, byte accessType, String memberName) {
        int problemId = accessRestriction.getProblemId();
        int realProblemId = problemId & 0xFFFF;
        String simpleName = AccessRestrictionTreeScanner.getSimpleNameFromFQN(fqn);
        int severity = this.toSeverity(problemId);
        int line = this.unit.getLineMap().getLineNumber(startPos);
        int column = this.unit.getLineMap().getColumnNumber(startPos);
        String[] messageArguments = memberName != null ? new String[]{accessRestriction.classpathEntryName, memberName, simpleName} : new String[]{accessRestriction.classpathEntryName, simpleName};
        int elaborationId = 0x13300 | (accessType | accessRestriction.classpathEntryType);
        return this.problemFactory.createProblem(this.unit.getSourceFile().getName().toCharArray(), realProblemId, new String[]{simpleName}, elaborationId, messageArguments, severity, startPos, endPos, line, column);
    }

    public List<CategorizedProblem> getAccessRestrictionProblems() {
        return this.accessRestrictionProblems;
    }

    private String getCurrentUnitFQN() {
        String simpleFileName = this.unit.getSourceFile().getName();
        simpleFileName = simpleFileName.substring(simpleFileName.lastIndexOf(47) + 1, simpleFileName.lastIndexOf(46));
        Object currentUnitName = simpleFileName;
        if (this.unit.packge != null && !this.unit.packge.getQualifiedName().toString().isEmpty()) {
            currentUnitName = this.unit.packge.getQualifiedName().toString() + "." + (String)currentUnitName;
        }
        return currentUnitName;
    }

    private int toSeverity(int jdtProblemId) {
        int irritant = ProblemReporter.getIrritant((int)jdtProblemId);
        if (irritant != 0) {
            int res = this.compilerOptions.getSeverity(irritant);
            return res &= 0xFFFFFFDF;
        }
        return 0;
    }

    private static String toDisplayString(Symbol.MethodSymbol sym) {
        StringBuilder builder = new StringBuilder();
        builder.append(sym.name);
        builder.append('(');
        for (int i = 0; i < sym.params().length(); ++i) {
            Symbol.VarSymbol param = sym.params().get(i);
            builder.append(param.type.tsym.getSimpleName());
            if (i + 1 >= sym.params().length()) continue;
            builder.append(", ");
        }
        builder.append(')');
        return builder.toString();
    }

    private static String toDisplayString(String name, Type.MethodType type) {
        StringBuilder builder = new StringBuilder();
        builder.append(name);
        builder.append('(');
        for (int i = 0; i < type.argtypes.length(); ++i) {
            Type paramType = type.argtypes.get(i);
            builder.append(paramType.tsym.getSimpleName());
            if (i + 1 >= type.argtypes.length()) continue;
            builder.append(", ");
        }
        builder.append(')');
        return builder.toString();
    }

    private static String getQualifiedName(Symbol sym) {
        if (sym.owner instanceof Symbol.ClassSymbol) {
            StringBuilder builder = new StringBuilder();
            builder.append(AccessRestrictionTreeScanner.getQualifiedName(sym.owner));
            builder.append("$");
            builder.append(sym.getSimpleName().toString());
            return builder.toString();
        }
        return sym.getQualifiedName().toString();
    }

    private static String getSimpleNameFromFQN(String fqn) {
        String simpleName = fqn.substring(fqn.lastIndexOf(46) + 1);
        simpleName = simpleName.replace('$', '.');
        return simpleName;
    }

    static {
        UNINTERESTING_FIELDS.add("this");
        UNINTERESTING_FIELDS.add("class");
        UNINTERESTING_FIELDS.add("super");
        UNNECESSARY_SUPPRESS_ARGS = new String[]{"restriction"};
    }

    private class AccessRestrictionDocTreeScanner
    extends DocTreeScanner<Void, Void> {
        private Function<Integer, Integer> translateOffset;
        final /* synthetic */ AccessRestrictionTreeScanner this$0;

        public AccessRestrictionDocTreeScanner(AccessRestrictionTreeScanner accessRestrictionTreeScanner, Function<Integer, Integer> translateOffset) {
            AccessRestrictionTreeScanner accessRestrictionTreeScanner2 = accessRestrictionTreeScanner;
            Objects.requireNonNull(accessRestrictionTreeScanner2);
            this.this$0 = accessRestrictionTreeScanner2;
            this.translateOffset = translateOffset;
        }

        @Override
        public Void visitLink(LinkTree node, Void p) {
            if (node.getReference() != null) {
                this.visitRef(node.getReference());
            }
            return (Void)super.visitLink(node, p);
        }

        @Override
        public Void visitSee(SeeTree node, Void p) {
            if (node.getReference() != null) {
                for (DocTree docTree : node.getReference()) {
                    this.visitRef(docTree);
                }
            }
            return (Void)super.visitSee(node, p);
        }

        private void visitRef(DocTree ref) {
            if (ref instanceof DCTree.DCReference) {
                DCTree.DCReference dcRef = (DCTree.DCReference)ref;
                if (dcRef.qualifierExpression != null && dcRef.qualifierExpression.type != null) {
                    Symbol.TypeSymbol sym = dcRef.qualifierExpression.type.tsym;
                    String fqn = AccessRestrictionTreeScanner.getQualifiedName(dcRef.qualifierExpression.type.tsym);
                    int startPos = this.translateOffset.apply(dcRef.getStartPosition());
                    int endPos = startPos + dcRef.qualifierExpression.toString().length() - 1;
                    this.this$0.collectProblemForFQN(fqn, startPos, endPos, (byte)0, null);
                    if (dcRef.memberName != null) {
                        String memberName = dcRef.memberName.toString();
                        int numParams = dcRef.paramTypes == null ? 0 : dcRef.paramTypes.size();
                        Symbol.MethodSymbol methodSymbol = null;
                        Symbol.VarSymbol varSymbol = null;
                        for (Symbol elt : sym.getEnclosedElements()) {
                            Symbol.VarSymbol eltVarSymbol;
                            Symbol.MethodSymbol eltMethodSymbol;
                            if (!memberName.equals(elt.getSimpleName().toString())) continue;
                            if (elt instanceof Symbol.MethodSymbol && (eltMethodSymbol = (Symbol.MethodSymbol)elt).params().length() == numParams) {
                                methodSymbol = eltMethodSymbol;
                                break;
                            }
                            if (numParams != 0 || !(elt instanceof Symbol.VarSymbol)) continue;
                            varSymbol = eltVarSymbol = (Symbol.VarSymbol)elt;
                        }
                        int memberStartPos = endPos + 2;
                        int memberEndPos = memberStartPos + dcRef.memberName.length() - 1;
                        if (methodSymbol != null) {
                            this.this$0.collectProblemForFQN(fqn, memberStartPos, memberEndPos, (byte)12, AccessRestrictionTreeScanner.toDisplayString(methodSymbol));
                        } else if (varSymbol != null) {
                            this.this$0.collectProblemForFQN(fqn, memberStartPos, memberEndPos, (byte)4, dcRef.memberName.toString());
                        }
                    }
                }
            }
        }
    }
}

