/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.internal.project.registry;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class DependencyResolutionContext {
    private final Set<IFile> pomFiles;
    private final Map<IFile, IStatus> statusMap = new HashMap<IFile, IStatus>();

    public DependencyResolutionContext(Collection<IFile> pomFiles) {
        this.pomFiles = new LinkedHashSet<IFile>(pomFiles);
    }

    public synchronized boolean isEmpty() {
        return this.pomFiles.isEmpty();
    }

    public synchronized void forcePomFiles(Collection<IFile> pomFiles) {
        this.pomFiles.addAll(pomFiles);
    }

    public synchronized IFile pop() {
        Iterator<IFile> i = this.pomFiles.iterator();
        IFile pom = i.next();
        i.remove();
        return pom;
    }

    synchronized Set<IFile> getCurrent() {
        return new LinkedHashSet<IFile>(this.pomFiles);
    }

    public void forcePomFile(IFile file) {
        this.pomFiles.add(file);
        this.statusMap.remove(file);
    }

    public IStatus getStatus(IFile file) {
        return this.statusMap.getOrDefault(file, Status.OK_STATUS);
    }

    void setStatus(IFile file, IStatus status) {
        this.statusMap.put(file, status);
    }

    void clearErrors(Collection<? extends IFile> pomFiles) {
        for (IFile iFile : pomFiles) {
            this.statusMap.remove(iFile);
        }
    }
}

