/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.builder;

import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Stream;
import org.eclipse.core.resources.IContainer;
import org.eclipse.jdt.internal.core.builder.CompressedReader;
import org.eclipse.jdt.internal.core.builder.CompressedWriter;

public class TypeLocators {
    private String[] knownPackageNames;
    private final Map<String, String> defaultMap;
    private Map<String, Map<Integer, String>> releaseMap;

    TypeLocators() {
        this.defaultMap = new LinkedHashMap<String, String>(7);
    }

    TypeLocators(TypeLocators copy) {
        this.defaultMap = new LinkedHashMap<String, String>(copy.defaultMap);
        if (copy.releaseMap != null) {
            this.releaseMap = new LinkedHashMap<String, Map<Integer, String>>(copy.releaseMap);
        }
    }

    void write(CompressedWriter out, Map<String, Integer> internedTypeLocators) throws IOException {
        String key;
        if (this.defaultMap.isEmpty()) {
            out.writeInt(0);
        } else {
            out.writeInt(this.defaultMap.size());
            for (Map.Entry<String, String> entry : this.defaultMap.entrySet()) {
                key = entry.getKey();
                String value = entry.getValue();
                out.writeStringUsingLast(key);
                Integer index = internedTypeLocators.get(value);
                out.writeIntInRange(index, internedTypeLocators.size());
            }
        }
        if (this.releaseMap == null || this.releaseMap.isEmpty()) {
            out.writeInt(0);
        } else {
            out.writeInt(this.releaseMap.size());
            for (Map.Entry<String, Object> entry : this.releaseMap.entrySet()) {
                key = entry.getKey();
                out.writeStringUsingLast(key);
                Map map = (Map)entry.getValue();
                out.writeInt(map.size());
                for (Map.Entry releaseEntry : map.entrySet()) {
                    out.writeInt((Integer)releaseEntry.getKey());
                    Integer index = internedTypeLocators.get(releaseEntry.getValue());
                    out.writeIntInRange(index, internedTypeLocators.size());
                }
            }
        }
    }

    void read(CompressedReader in, String[] internedTypeLocators) throws IOException {
        int i;
        int length = in.readInt();
        this.defaultMap.clear();
        if (length > 0) {
            i = 0;
            while (i < length) {
                this.recordLocatorForType(in.readStringUsingLast(), internedTypeLocators[in.readIntInRange(internedTypeLocators.length)], -1);
                ++i;
            }
        }
        if ((length = in.readInt()) == 0) {
            this.releaseMap = null;
        } else {
            this.releaseMap = new LinkedHashMap<String, Map<Integer, String>>((int)((double)length / 0.75 + 1.0));
            i = 0;
            while (i < length) {
                String key = in.readStringUsingLast();
                int mapSize = in.readInt();
                int j = 0;
                while (j < mapSize) {
                    int release = in.readInt();
                    String locator = internedTypeLocators[in.readIntInRange(internedTypeLocators.length)];
                    this.recordLocatorForType(key, locator, release);
                    ++j;
                }
                ++i;
            }
        }
    }

    void removeLocator(String qualifiedTypeNameToRemove) {
        this.knownPackageNames = null;
        this.defaultMap.remove(qualifiedTypeNameToRemove);
        if (this.releaseMap != null) {
            this.releaseMap.remove(qualifiedTypeNameToRemove);
        }
    }

    void removeLocator(String typeLocatorToRemove, int release) {
        this.knownPackageNames = null;
        if (release > -1) {
            if (this.releaseMap != null) {
                Iterator<Map.Entry<String, Map<Integer, String>>> iterator = this.releaseMap.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<String, Map<Integer, String>> entry = iterator.next();
                    Map<Integer, String> map = entry.getValue();
                    map.values().removeIf(v -> typeLocatorToRemove.equals(v));
                    if (!map.isEmpty()) continue;
                    iterator.remove();
                }
            }
        } else {
            this.defaultMap.values().removeIf(v -> typeLocatorToRemove.equals(v));
        }
    }

    void recordLocatorForType(String qualifiedTypeName, String typeLocator, int release) {
        this.knownPackageNames = null;
        int start = typeLocator.indexOf(qualifiedTypeName, 0);
        if (start > 0) {
            qualifiedTypeName = typeLocator.substring(start, start + qualifiedTypeName.length());
        }
        if (release > -1) {
            if (this.releaseMap == null) {
                this.releaseMap = new LinkedHashMap<String, Map<Integer, String>>(7);
            }
            this.releaseMap.computeIfAbsent(qualifiedTypeName, nil -> new TreeMap()).put(release, typeLocator);
        } else {
            this.defaultMap.put(qualifiedTypeName, typeLocator);
        }
    }

    boolean isKnownPackage(String qualifiedPackageName) {
        int result;
        if (this.knownPackageNames == null) {
            int total = this.defaultMap.size();
            if (this.releaseMap != null) {
                total += this.releaseMap.size();
            }
            if (total == 0) {
                this.knownPackageNames = new String[0];
                return false;
            }
            LinkedHashSet<String> names = new LinkedHashSet<String>(total);
            this.addPackages(names, this.defaultMap.keySet());
            if (this.releaseMap != null) {
                this.addPackages(names, this.releaseMap.keySet());
            }
            this.knownPackageNames = names.toArray(new String[names.size()]);
            Arrays.sort(this.knownPackageNames);
        }
        return (result = Arrays.binarySearch(this.knownPackageNames, qualifiedPackageName)) >= 0;
    }

    protected void addPackages(LinkedHashSet<String> names, Set<String> keySet) {
        for (String packageName : keySet) {
            int last = packageName.lastIndexOf(47);
            packageName = last == -1 ? null : packageName.substring(0, last);
            while (packageName != null && !names.contains(packageName)) {
                names.add(packageName);
                last = packageName.lastIndexOf(47);
                String string = packageName = last == -1 ? null : packageName.substring(0, last);
            }
        }
    }

    boolean isKnownType(String qualifiedTypeName) {
        if (this.defaultMap.containsKey(qualifiedTypeName)) {
            return true;
        }
        return this.releaseMap != null && this.releaseMap.containsKey(qualifiedTypeName);
    }

    boolean isSourceFolderEmpty(IContainer sourceFolder) {
        String sourceFolderName = sourceFolder.getProjectRelativePath().addTrailingSeparator().toString();
        for (String string : this.defaultMap.values()) {
            if (!string.startsWith(sourceFolderName)) continue;
            return false;
        }
        if (this.releaseMap != null) {
            for (Map map : this.releaseMap.values()) {
                for (String value : map.values()) {
                    if (!value.startsWith(sourceFolderName)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    boolean isDuplicateLocator(String qualifiedTypeName, String typeLocator, int release) {
        String string;
        if (release > -1) {
            if (this.releaseMap == null) {
                return false;
            }
            Map<Integer, String> existing = this.releaseMap.get(qualifiedTypeName);
            if (existing == null) {
                return false;
            }
            string = existing.get(release);
        } else {
            string = this.defaultMap.get(qualifiedTypeName);
        }
        return string != null && !string.equals(typeLocator);
    }

    public Stream<String> getPathForName(String typeName) {
        return Stream.concat(this.getDefaultPathForName(typeName).stream(), this.getReleasePathForNames(typeName)).distinct();
    }

    private Optional<String> getDefaultPathForName(String typeName) {
        return Optional.ofNullable(this.defaultMap.get(typeName));
    }

    private Stream<String> getReleasePathForNames(String typeName) {
        if (this.releaseMap == null) {
            return Stream.empty();
        }
        Map<Integer, String> map = this.releaseMap.get(typeName);
        if (map == null) {
            return Stream.empty();
        }
        return map.values().stream();
    }

    public boolean equals(Object obj) {
        if (obj instanceof TypeLocators) {
            TypeLocators other = (TypeLocators)obj;
            if (!this.defaultMap.equals(other.defaultMap)) {
                return false;
            }
            return Objects.requireNonNullElse(this.releaseMap, Map.of()).equals(Objects.requireNonNullElse(other.releaseMap, Map.of()));
        }
        return false;
    }

    public int hashCode() {
        return 0;
    }
}

