/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.builder.jdtbuilder;

import com.microsoft.java.builder.jdtbuilder.ClasspathJrt;
import com.microsoft.java.builder.jdtbuilder.ClasspathLocation;
import com.microsoft.java.builder.jdtbuilder.ModulePathEntry;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.internal.compiler.env.IModule;
import org.eclipse.jdt.internal.compiler.env.IModulePathEntry;
import org.eclipse.jdt.internal.core.ClasspathEntry;
import org.eclipse.jdt.internal.core.JavaProject;

class ModuleEntryProcessor {
    ModuleEntryProcessor() {
    }

    static String pushPatchToFront(IClasspathEntry[] classpathEntries, JavaProject javaProject) {
        int i = 0;
        while (i < classpathEntries.length) {
            IClasspathEntry entry = classpathEntries[i];
            List patchedModules = javaProject.getPatchedModules(entry);
            if (patchedModules.size() == 1) {
                if (i > 0) {
                    IClasspathEntry tmp = classpathEntries[0];
                    classpathEntries[0] = entry;
                    classpathEntries[i] = tmp;
                }
                return (String)patchedModules.get(0);
            }
            ++i;
        }
        return null;
    }

    static void combinePatchIntoModuleEntry(ClasspathLocation sourceLocation, IModule patchedModule, Map<String, IModulePathEntry> moduleEntries) {
        sourceLocation.setModule(patchedModule);
        String patchedModuleName = String.valueOf(patchedModule.name());
        IModulePathEntry mainEntry = moduleEntries.get(patchedModuleName);
        ClasspathLocation[] combinedLocations = null;
        if (mainEntry instanceof ModulePathEntry.Multi) {
            ((ModulePathEntry.Multi)mainEntry).addPatchLocation(sourceLocation);
            return;
        }
        if (mainEntry instanceof ClasspathJrt) {
            combinedLocations = new ClasspathLocation[]{(ClasspathLocation)mainEntry, sourceLocation};
            moduleEntries.put(patchedModuleName, new ModulePathEntry.Multi(null, patchedModule, combinedLocations));
            return;
        }
        if (mainEntry instanceof ModulePathEntry) {
            ClasspathLocation[] mainLocs = ((ModulePathEntry)mainEntry).locations;
            combinedLocations = Arrays.copyOf(mainLocs, mainLocs.length + 1);
            combinedLocations[combinedLocations.length - 1] = sourceLocation;
        } else if (mainEntry instanceof ClasspathLocation) {
            combinedLocations = new ClasspathLocation[]{(ClasspathLocation)mainEntry, sourceLocation};
        } else {
            throw new IllegalStateException("Cannot patch the module of classpath entry " + String.valueOf(mainEntry));
        }
        moduleEntries.put(patchedModuleName, new ModulePathEntry(null, patchedModule, combinedLocations));
    }

    static Set<String> computeLimitModules(ClasspathEntry entry) {
        String extraAttribute = ClasspathEntry.getExtraAttribute((IClasspathEntry)entry, (String)"limit-modules");
        if (extraAttribute == null) {
            return null;
        }
        return new LinkedHashSet<String>(Arrays.asList(extraAttribute.split(",")));
    }
}

