import * as mi from '../mi';
import { Handles, Logger, LoggingDebugSession } from '@vscode/debugadapter';
import { DebugProtocol } from '@vscode/debugprotocol';
import { VarObjType } from '../varManager';
import { FrameReference, VariableReference, LaunchRequestArguments, AttachRequestArguments, MemoryResponse, FrameVariableReference, RegisterVariableReference, ObjectVariableReference, CDTDisassembleArguments } from '../types/session';
import { IGDBBackend, IGDBBackendFactory } from '../types/gdb';
declare class ThreadWithStatus implements DebugProtocol.Thread {
    id: number;
    name: string;
    running: boolean;
    constructor(id: number, name: string, running: boolean);
}
export declare function hexToBase64(hex: string): string;
export declare function base64ToHex(base64: string): string;
export declare abstract class GDBDebugSessionBase extends LoggingDebugSession {
    protected readonly backendFactory: IGDBBackendFactory;
    /**
     * Initial (aka default) configuration for launch/attach request
     * typically supplied with the --config command line argument.
     */
    protected static defaultRequestArguments?: any;
    /**
     * Frozen configuration for launch/attach request
     * typically supplied with the --config-frozen command line argument.
     */
    protected static frozenRequestArguments?: {
        request?: string;
    };
    protected gdb: IGDBBackend;
    protected isAttach: boolean;
    protected isRunning: boolean;
    protected supportsRunInTerminalRequest: boolean;
    supportsGdbConsole: boolean;
    protected logger: Logger.Logger;
    protected frameHandles: Handles<FrameReference>;
    protected variableHandles: Handles<VariableReference>;
    protected functionBreakpoints: string[];
    protected logPointMessages: {
        [key: string]: string;
    };
    protected threads: ThreadWithStatus[];
    protected waitPaused?: (value?: void | PromiseLike<void>) => void;
    protected waitPausedThreadId: number;
    protected waitPausedNeeded: boolean;
    protected isInitialized: boolean;
    constructor(backendFactory: IGDBBackendFactory);
    /**
     * Apply the initial and frozen launch/attach request arguments.
     * @param request the default request type to return if request type is not frozen
     * @param args the arguments from the user to apply initial and frozen arguments to.
     * @returns resolved request type and the resolved arguments
     */
    protected applyRequestArguments(request: 'launch' | 'attach', args: LaunchRequestArguments | AttachRequestArguments): ['launch' | 'attach', LaunchRequestArguments | AttachRequestArguments];
    /**
     * Handle requests not defined in the debug adapter protocol.
     */
    protected customRequest(command: string, response: DebugProtocol.Response, args: any): void;
    protected getBreakpointModes(): DebugProtocol.BreakpointMode[] | undefined;
    protected initializeRequest(response: DebugProtocol.InitializeResponse, args: DebugProtocol.InitializeRequestArguments): void;
    protected setupCommonLoggerAndBackends(args: LaunchRequestArguments | AttachRequestArguments): Promise<void>;
    protected attachOrLaunchRequest(response: DebugProtocol.Response, request: 'launch' | 'attach', args: LaunchRequestArguments | AttachRequestArguments): Promise<void>;
    protected attachRequest(response: DebugProtocol.AttachResponse, args: AttachRequestArguments): Promise<void>;
    protected launchRequest(response: DebugProtocol.LaunchResponse, args: LaunchRequestArguments): Promise<void>;
    protected spawn(args: LaunchRequestArguments | AttachRequestArguments): Promise<void>;
    /**
     * Sends a pause command to GDBBackend, and resolves when the debugger is
     * actually paused. The paused thread ID is saved to `this.waitPausedThreadId`.
     * @param requireAsync - require gdb to be in async mode to pause
     */
    protected pauseIfNeeded(requireAsync?: false): Promise<void>;
    /**
     * Sends a pause command to GDBBackend, and resolves when the debugger is
     * actually paused. The paused thread ID is saved to `this.waitPausedThreadId`.
     *
     * @param requireAsync - require gdb to be in async mode to pause
     * @deprecated the `requireAsync` parameter should not be used and will be
     * removed in the future.
     * See {@link https://github.com/eclipse-cdt-cloud/cdt-gdb-adapter/pull/339#discussion_r1840549671}
     */
    protected pauseIfNeeded(requireAsync: true): Promise<void>;
    protected continueIfNeeded(): Promise<void>;
    protected setBreakPointsRequest(response: DebugProtocol.SetBreakpointsResponse, args: DebugProtocol.SetBreakpointsArguments): Promise<void>;
    protected setFunctionBreakPointsRequest(response: DebugProtocol.SetFunctionBreakpointsResponse, args: DebugProtocol.SetFunctionBreakpointsArguments): Promise<void>;
    /**
     * Resolved which VS breakpoints needs to be installed, which
     * GDB breakpoints need to be deleted and which VS breakpoints
     * are already installed with which matching GDB breakpoint.
     * @param vsbps VS DAP breakpoints
     * @param gdbbps GDB breakpoints
     * @param matchFn matcher to compare VS and GDB breakpoints
     * @returns resolved -> array maintaining order of vsbps that identifies whether
     * VS breakpoint has a cooresponding GDB breakpoint (gdbbp field set) or needs to be
     * inserted (gdbbp field empty)
     * deletes -> GDB bps ids that should be deleted because they don't match vsbps
     */
    protected resolveBreakpoints<T>(vsbps: T[], gdbbps: mi.MIBreakpointInfo[], matchFn: (vsbp: T, gdbbp: mi.MIBreakpointInfo) => boolean): {
        resolved: Array<{
            vsbp: T;
            gdbbp?: mi.MIBreakpointInfo;
        }>;
        deletes: string[];
    };
    protected configurationDoneRequest(response: DebugProtocol.ConfigurationDoneResponse, _args: DebugProtocol.ConfigurationDoneArguments): Promise<void>;
    protected convertThread(thread: mi.MIThreadInfo): ThreadWithStatus;
    protected threadsRequest(response: DebugProtocol.ThreadsResponse): Promise<void>;
    protected stackTraceRequest(response: DebugProtocol.StackTraceResponse, args: DebugProtocol.StackTraceArguments): Promise<void>;
    protected nextRequest(response: DebugProtocol.NextResponse, args: DebugProtocol.NextArguments): Promise<void>;
    protected stepInRequest(response: DebugProtocol.StepInResponse, args: DebugProtocol.StepInArguments): Promise<void>;
    protected stepOutRequest(response: DebugProtocol.StepOutResponse, args: DebugProtocol.StepOutArguments): Promise<void>;
    protected continueRequest(response: DebugProtocol.ContinueResponse, args: DebugProtocol.ContinueArguments): Promise<void>;
    protected pauseRequest(response: DebugProtocol.PauseResponse, args: DebugProtocol.PauseArguments): Promise<void>;
    protected scopesRequest(response: DebugProtocol.ScopesResponse, args: DebugProtocol.ScopesArguments): void;
    protected variablesRequest(response: DebugProtocol.VariablesResponse, args: DebugProtocol.VariablesArguments): Promise<void>;
    protected setVariableRequest(response: DebugProtocol.SetVariableResponse, args: DebugProtocol.SetVariableArguments): Promise<void>;
    protected evaluateRequest(response: DebugProtocol.EvaluateResponse, args: DebugProtocol.EvaluateArguments): Promise<void>;
    protected getChildElements(varobj: VarObjType, frameHandle: number): Promise<string>;
    protected convertValue(variable: DebugProtocol.Variable): string | number | boolean;
    /**
     * Implement the cdt-gdb-adapter/Memory request.
     */
    protected memoryRequest(response: MemoryResponse, args: any): Promise<void>;
    protected disassembleRequest(response: DebugProtocol.DisassembleResponse, args: CDTDisassembleArguments): Promise<void>;
    protected readMemoryRequest(response: DebugProtocol.ReadMemoryResponse, args: DebugProtocol.ReadMemoryArguments): Promise<void>;
    /**
     * Implement the memoryWrite request.
     */
    protected writeMemoryRequest(response: DebugProtocol.WriteMemoryResponse, args: DebugProtocol.WriteMemoryArguments): Promise<void>;
    protected disconnectRequest(response: DebugProtocol.DisconnectResponse, _args: DebugProtocol.DisconnectArguments): Promise<void>;
    protected sendStoppedEvent(reason: string, threadId: number, allThreadsStopped?: boolean): void;
    protected handleGDBStopped(result: any): void;
    protected sendContinuedEvent(threadId: number, allThreadsContinued?: boolean): void;
    protected handleGDBResume(result: any): void;
    protected handleGDBAsync(resultClass: string, resultData: any): void;
    protected handleGDBNotify(notifyClass: string, notifyData: any): void;
    protected handleVariableRequestFrame(ref: FrameVariableReference): Promise<DebugProtocol.Variable[]>;
    protected handleVariableRequestObject(ref: ObjectVariableReference): Promise<DebugProtocol.Variable[]>;
    /** Query GDB using varXX name to get complete variable name */
    protected getFullPathExpression(inputVarName: string): Promise<string>;
    private registerMap;
    private registerMapReverse;
    protected handleVariableRequestRegister(ref: RegisterVariableReference): Promise<DebugProtocol.Variable[]>;
    protected getAddr(varobj: VarObjType): Promise<string>;
    protected isChildOfClass(child: mi.MIVarChild): boolean;
}
export {};
