"use strict";
// *****************************************************************************
// Copyright (C) 2018 TypeFox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
// *****************************************************************************
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ConsoleNavigationForwardEnabled = exports.ConsoleNavigationBackEnabled = exports.ConsoleContentFocusContext = exports.ConsoleInputFocusContext = exports.ConsoleKeybindingContexts = void 0;
const inversify_1 = require("@theia/core/shared/inversify");
const console_manager_1 = require("./console-manager");
var ConsoleKeybindingContexts;
(function (ConsoleKeybindingContexts) {
    /**
     * ID of a keybinding context that is enabled when the console content has the focus.
     */
    ConsoleKeybindingContexts.consoleContentFocus = 'consoleContentFocus';
    /**
     * ID of a keybinding context that is enabled when the console input has the focus.
     */
    ConsoleKeybindingContexts.consoleInputFocus = 'consoleInputFocus';
    /**
     * ID of a keybinding context that is enabled when the console history navigation back is enabled.
     */
    ConsoleKeybindingContexts.consoleNavigationBackEnabled = 'consoleNavigationBackEnabled';
    /**
     * ID of a keybinding context that is enabled when the console history navigation forward is enabled.
     */
    ConsoleKeybindingContexts.consoleNavigationForwardEnabled = 'consoleNavigationForwardEnabled';
})(ConsoleKeybindingContexts = exports.ConsoleKeybindingContexts || (exports.ConsoleKeybindingContexts = {}));
let ConsoleInputFocusContext = class ConsoleInputFocusContext {
    constructor() {
        this.id = ConsoleKeybindingContexts.consoleInputFocus;
    }
    isEnabled() {
        const console = this.manager.activeConsole;
        return !!console && this.isConsoleEnabled(console);
    }
    isConsoleEnabled(console) {
        return console.hasInputFocus();
    }
};
__decorate([
    (0, inversify_1.inject)(console_manager_1.ConsoleManager),
    __metadata("design:type", console_manager_1.ConsoleManager)
], ConsoleInputFocusContext.prototype, "manager", void 0);
ConsoleInputFocusContext = __decorate([
    (0, inversify_1.injectable)()
], ConsoleInputFocusContext);
exports.ConsoleInputFocusContext = ConsoleInputFocusContext;
let ConsoleContentFocusContext = class ConsoleContentFocusContext extends ConsoleInputFocusContext {
    constructor() {
        super(...arguments);
        this.id = ConsoleKeybindingContexts.consoleContentFocus;
    }
    isConsoleEnabled(console) {
        return !console.input.isFocused();
    }
};
ConsoleContentFocusContext = __decorate([
    (0, inversify_1.injectable)()
], ConsoleContentFocusContext);
exports.ConsoleContentFocusContext = ConsoleContentFocusContext;
let ConsoleNavigationBackEnabled = class ConsoleNavigationBackEnabled extends ConsoleInputFocusContext {
    constructor() {
        super(...arguments);
        this.id = ConsoleKeybindingContexts.consoleNavigationBackEnabled;
    }
    isConsoleEnabled(console) {
        if (!super.isConsoleEnabled(console)) {
            return false;
        }
        const editor = console.input.getControl();
        return editor.getPosition().equals({ lineNumber: 1, column: 1 });
    }
};
ConsoleNavigationBackEnabled = __decorate([
    (0, inversify_1.injectable)()
], ConsoleNavigationBackEnabled);
exports.ConsoleNavigationBackEnabled = ConsoleNavigationBackEnabled;
let ConsoleNavigationForwardEnabled = class ConsoleNavigationForwardEnabled extends ConsoleInputFocusContext {
    constructor() {
        super(...arguments);
        this.id = ConsoleKeybindingContexts.consoleNavigationForwardEnabled;
    }
    isConsoleEnabled(console) {
        if (!super.isConsoleEnabled(console)) {
            return false;
        }
        const editor = console.input.getControl();
        const model = console.input.getControl().getModel();
        const lineNumber = model.getLineCount();
        const column = model.getLineMaxColumn(lineNumber);
        return editor.getPosition().equals({ lineNumber, column });
    }
};
ConsoleNavigationForwardEnabled = __decorate([
    (0, inversify_1.injectable)()
], ConsoleNavigationForwardEnabled);
exports.ConsoleNavigationForwardEnabled = ConsoleNavigationForwardEnabled;
//# sourceMappingURL=console-keybinding-contexts.js.map