/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.maven.apt.internal.processor;

import java.io.File;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecution;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.jboss.tools.maven.apt.internal.AbstractAptConfiguratorDelegate;
import org.jboss.tools.maven.apt.internal.AnnotationProcessorConfiguration;
import org.jboss.tools.maven.apt.internal.DefaultAnnotationProcessorConfiguration;
import org.jboss.tools.maven.apt.internal.utils.PluginDependencyResolver;

public class MavenProcessorJdtAptDelegate
extends AbstractAptConfiguratorDelegate {
    public static final String PROCESSOR_PLUGIN_GROUP_ID = "org.bsc.maven";
    public static final String PROCESSOR_PLUGIN_ARTIFACT_ID = "maven-processor-plugin";
    public static final String GOAL_PROCESS = "process";
    public static final String GOAL_PROCESS_TEST = "process-test";
    static final String SOURCE_DIRECTORY_PARAMETER = "sourceDirectory";
    static final String OUTPUT_DIRECTORY_PARAMETER = "outputDirectory";
    static final String DEFAULT_OUTPUT_DIRECTORY_PARAMETER = "defaultOutputDirectory";

    @Override
    protected AnnotationProcessorConfiguration getAnnotationProcessorConfiguration(IProgressMonitor monitor) throws CoreException {
        MojoExecution mojoExecution = this.getProcessorPluginMojoExecution(this.mavenFacade, GOAL_PROCESS, monitor);
        if (mojoExecution == null) {
            return null;
        }
        File generatedOutputDirectory = this.getParameterValue(OUTPUT_DIRECTORY_PARAMETER, File.class, this.mavenSession, mojoExecution);
        PluginDependencyResolver dependencyResolver = new PluginDependencyResolver();
        List<File> dependencies = dependencyResolver.getResolvedPluginDependencies(this.mavenSession, this.mavenFacade.getMavenProject(), mojoExecution.getPlugin(), monitor);
        Map options = this.getParameterValue("optionMap", Map.class, this.mavenSession, mojoExecution);
        DefaultAnnotationProcessorConfiguration configuration = new DefaultAnnotationProcessorConfiguration();
        configuration.setOutputDirectory(generatedOutputDirectory);
        configuration.setAnnotationProcessingEnabled(true);
        configuration.setDependencies(dependencies);
        configuration.setAnnotationProcessorOptions(options);
        MojoExecution testMojoExecution = this.getProcessorPluginMojoExecution(this.mavenFacade, GOAL_PROCESS_TEST, monitor);
        if (testMojoExecution != null) {
            File generatedTestOutputDirectory = this.getParameterValue(OUTPUT_DIRECTORY_PARAMETER, File.class, this.mavenSession, testMojoExecution);
            configuration.setTestOutputDirectory(generatedTestOutputDirectory);
        }
        return configuration;
    }

    protected MojoExecution getProcessorPluginMojoExecution(IMavenProjectFacade mavenProjectFacade, String goal, IProgressMonitor monitor) throws CoreException {
        Iterator iterator = mavenProjectFacade.getMojoExecutions(PROCESSOR_PLUGIN_GROUP_ID, PROCESSOR_PLUGIN_ARTIFACT_ID, monitor, new String[]{goal}).iterator();
        if (iterator.hasNext()) {
            MojoExecution mojoExecution = (MojoExecution)iterator.next();
            return mojoExecution;
        }
        return null;
    }

    @Override
    protected <T> T getParameterValue(String parameter, Class<T> asType, MavenSession session, MojoExecution mojoExecution) throws CoreException {
        T result = super.getParameterValue(parameter, asType, session, mojoExecution);
        if (OUTPUT_DIRECTORY_PARAMETER.equals(parameter) && result == null) {
            return super.getParameterValue(DEFAULT_OUTPUT_DIRECTORY_PARAMETER, asType, session, mojoExecution);
        }
        return result;
    }
}

