/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.internal.marker;

import com.google.common.base.Throwables;
import org.eclipse.buildship.core.internal.CorePlugin;
import org.eclipse.buildship.core.internal.workspace.InternalGradleBuild;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;

public class GradleErrorMarker {
    public static String ID = "org.eclipse.buildship.core.errormarker";
    public static String ATTRIBUTE_STACKTRACE = "stacktrace";
    public static String ATTRIBUTE_ROOT_DIR = "rootdir";

    private GradleErrorMarker() {
    }

    public static boolean belongsToBuild(IMarker marker, InternalGradleBuild build) {
        String rootDir = marker.getAttribute(ATTRIBUTE_ROOT_DIR, null);
        return build.getBuildConfig().getRootProjectDirectory().getAbsolutePath().equals(rootDir);
    }

    public static void createError(IResource resource, InternalGradleBuild gradleBuild, String message, Throwable exception, int lineNumber) {
        GradleErrorMarker.createMarker(2, resource, gradleBuild, message, exception, lineNumber);
    }

    public static void createWarning(IResource resource, InternalGradleBuild gradleBuild, String message, Throwable exception, int lineNumber) {
        GradleErrorMarker.createMarker(1, resource, gradleBuild, message, exception, lineNumber);
    }

    private static void createMarker(int severity, IResource resource, InternalGradleBuild gradleBuild, String message, Throwable exception, int lineNumber) {
        try {
            IMarker marker = resource.createMarker(ID);
            if (lineNumber >= 0) {
                marker.setAttribute("lineNumber", lineNumber);
            }
            marker.setAttribute("message", (Object)message);
            marker.setAttribute("priority", 2);
            marker.setAttribute("severity", severity);
            marker.setAttribute(ATTRIBUTE_ROOT_DIR, (Object)gradleBuild.getBuildConfig().getRootProjectDirectory().getAbsolutePath());
            if (exception != null) {
                String stackTrace = Throwables.getStackTraceAsString((Throwable)exception);
                marker.setAttribute(ATTRIBUTE_STACKTRACE, (Object)stackTrace);
            }
        }
        catch (CoreException e) {
            CorePlugin.logger().warn("Cannot create Gradle error marker", e);
        }
    }
}

