/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.test.plugin.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ls.core.internal.ProjectUtils;
import org.eclipse.jdt.ls.core.internal.ResourceUtils;

public final class ProjectTestUtils {
    private static final String TEST_SCOPE = "test";
    private static final String MAVEN_SCOPE_ATTRIBUTE = "maven.scope";
    private static final String GRADLE_SCOPE_ATTRIBUTE = "gradle_scope";

    public static String[] listTestSourcePaths(List<Object> arguments, IProgressMonitor monitor) throws JavaModelException {
        ArrayList<String> resultList = new ArrayList<String>();
        if (arguments == null || arguments.size() == 0) {
            return new String[0];
        }
        ArrayList uriArray = (ArrayList)arguments.get(0);
        for (String uri : uriArray) {
            Set<IJavaProject> projectSet = ProjectTestUtils.parseProjects(uri);
            for (IJavaProject project : projectSet) {
                for (IPath path : ProjectTestUtils.getTestPath(project)) {
                    IPath relativePath = path.makeRelativeTo(project.getPath());
                    resultList.add(project.getProject().getFolder(relativePath).getLocation().toOSString());
                }
            }
        }
        return resultList.toArray(new String[resultList.size()]);
    }

    public static Set<IJavaProject> parseProjects(String uriStr) {
        IPath parentPath = ResourceUtils.filePathFromURI((String)uriStr);
        if (parentPath == null) {
            return Collections.emptySet();
        }
        return Arrays.stream(ProjectUtils.getJavaProjects()).filter(p -> ProjectTestUtils.isProjectBelongToPath(p.getProject(), parentPath)).collect(Collectors.toSet());
    }

    public static List<IPath> getTestPath(IJavaProject project) throws JavaModelException {
        IClasspathEntry[] entries = project.getRawClasspath();
        return Arrays.stream(entries).filter(entry -> ProjectTestUtils.isTest(project, entry)).map(entry -> entry.getPath()).collect(Collectors.toList());
    }

    public static boolean isTest(IJavaProject project, IPath path) {
        IClasspathEntry entry;
        block3: {
            try {
                entry = project.getClasspathEntryFor(path);
                if (entry != null) break block3;
                return false;
            }
            catch (JavaModelException javaModelException) {
                return false;
            }
        }
        return ProjectTestUtils.isTest(project, entry);
    }

    public static boolean isTest(IJavaProject project, IClasspathEntry entry) {
        if ("jdt.ls-java-project".equals(project.getProject().getName())) {
            return false;
        }
        if (entry.getEntryKind() != 3) {
            return false;
        }
        if (ProjectUtils.isGeneralJavaProject((IProject)project.getProject())) {
            return true;
        }
        if (entry.isTest()) {
            return true;
        }
        IClasspathAttribute[] iClasspathAttributeArray = entry.getExtraAttributes();
        int n = iClasspathAttributeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathAttribute attribute = iClasspathAttributeArray[n2];
            if (MAVEN_SCOPE_ATTRIBUTE.equals(attribute.getName()) || GRADLE_SCOPE_ATTRIBUTE.equals(attribute.getName())) {
                return attribute.getValue() != null && attribute.getValue().toLowerCase().contains(TEST_SCOPE);
            }
            ++n2;
        }
        return false;
    }

    public static boolean isProjectBelongToPath(IProject project, IPath path) {
        if (project.getLocation() != null && path.isPrefixOf(project.getLocation())) {
            return true;
        }
        IPath linkedLocation = project.getFolder("_").getLocation();
        return linkedLocation != null && path.isPrefixOf(linkedLocation);
    }
}

