/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.handlers;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMemberValuePair;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jdt.internal.corext.codemanipulation.GetterSetterUtil;
import org.eclipse.jdt.ls.core.internal.JDTUtils;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.handlers.JsonRpcHelpers;
import org.eclipse.jdt.ls.core.internal.preferences.PreferenceManager;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.ReferenceParams;

public final class ReferencesHandler {
    private final PreferenceManager preferenceManager;

    public ReferencesHandler(PreferenceManager preferenceManager) {
        this.preferenceManager = preferenceManager;
    }

    private IJavaSearchScope createSearchScope() throws JavaModelException {
        IJavaProject[] projects = JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot()).getJavaProjects();
        int scope = 1;
        if (this.preferenceManager.isClientSupportsClassFileContent()) {
            scope |= 2;
        }
        return SearchEngine.createJavaSearchScope((IJavaElement[])projects, (int)scope);
    }

    public List<Location> findReferences(ReferenceParams param, IProgressMonitor monitor) {
        ArrayList<Location> locations = new ArrayList<Location>();
        try {
            ITypeRoot typeRoot = JDTUtils.resolveTypeRoot(param.getTextDocument().getUri());
            if (typeRoot == null) {
                return locations;
            }
            IJavaElement elementToSearch = JDTUtils.findElementAtSelection(typeRoot, param.getPosition().getLine(), param.getPosition().getCharacter(), this.preferenceManager, monitor);
            if (elementToSearch == null) {
                int offset = JsonRpcHelpers.toOffset(typeRoot.getBuffer(), param.getPosition().getLine(), param.getPosition().getCharacter());
                elementToSearch = typeRoot.getElementAt(offset);
            }
            if (elementToSearch == null) {
                return locations;
            }
            this.search(elementToSearch, locations, monitor);
            if (this.preferenceManager.getPreferences().isIncludeAccessors() && elementToSearch instanceof IField) {
                IMethod setter;
                IField field = (IField)elementToSearch;
                IMethod getter = GetterSetterUtil.getGetter((IField)field);
                if (getter != null) {
                    this.search((IJavaElement)getter, locations, monitor);
                }
                if ((setter = GetterSetterUtil.getSetter((IField)field)) != null) {
                    this.search((IJavaElement)setter, locations, monitor);
                }
                String builderName = this.getBuilderName(field);
                IType builder = field.getJavaProject().findType(builderName);
                if (builder != null) {
                    String fieldSignature = field.getTypeSignature();
                    IMethod[] iMethodArray = builder.getMethods();
                    int n = iMethodArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IMethod method = iMethodArray[n2];
                        String[] parameters = method.getParameterTypes();
                        if (parameters.length == 1 && field.getElementName().equals(method.getElementName()) && fieldSignature.equals(parameters[0])) {
                            this.search((IJavaElement)method, locations, monitor);
                        }
                        ++n2;
                    }
                }
            }
        }
        catch (CoreException e) {
            JavaLanguageServerPlugin.logException("Find references failure ", e);
        }
        return locations;
    }

    private String getBuilderName(IField field) {
        IType declaringType = field.getDeclaringType();
        IAnnotation annotation = declaringType.getAnnotation("Builder");
        if (annotation == null || !annotation.exists()) {
            annotation = declaringType.getAnnotation("lombok.Builder");
        }
        if (annotation != null && annotation.exists()) {
            try {
                IMemberValuePair[] iMemberValuePairArray = annotation.getMemberValuePairs();
                int n = iMemberValuePairArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IMemberValuePair pair = iMemberValuePairArray[n2];
                    if (pair.getValueKind() == 9) {
                        String memberName = pair.getMemberName();
                        Object value = pair.getValue();
                        if ("builderClassName".equals(memberName) && value instanceof String && !((String)value).isEmpty()) {
                            return String.valueOf(declaringType.getFullyQualifiedName()) + "." + (String)value;
                        }
                    }
                    ++n2;
                }
            }
            catch (JavaModelException e) {
                JavaLanguageServerPlugin.logException(e.getMessage(), e);
            }
        }
        return String.valueOf(declaringType.getFullyQualifiedName()) + "." + declaringType.getElementName() + "Builder";
    }

    private void search(IJavaElement elementToSearch, final List<Location> locations, IProgressMonitor monitor) throws CoreException, JavaModelException {
        final boolean includeClassFiles = this.preferenceManager.isClientSupportsClassFileContent();
        SearchEngine engine = new SearchEngine();
        SearchPattern pattern = SearchPattern.createPattern((IJavaElement)elementToSearch, (int)2);
        engine.search(pattern, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, this.createSearchScope(), new SearchRequestor(){

            public void acceptSearchMatch(SearchMatch match) throws CoreException {
                Object o = match.getElement();
                if (o instanceof IJavaElement) {
                    IClassFile cf;
                    IJavaElement element = (IJavaElement)o;
                    ICompilationUnit compilationUnit = (ICompilationUnit)element.getAncestor(5);
                    Location location = null;
                    if (compilationUnit != null) {
                        location = JDTUtils.toLocation(compilationUnit, match.getOffset(), match.getLength());
                    } else if (includeClassFiles && (cf = (IClassFile)element.getAncestor(6)) != null && cf.getSourceRange() != null) {
                        location = JDTUtils.toLocation(cf, match.getOffset(), match.getLength());
                    }
                    if (location != null) {
                        locations.add(location);
                    }
                }
            }
        }, monitor);
    }
}

