/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.handlers;

import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.manipulation.CoreASTProvider;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.jdt.internal.corext.codemanipulation.GenerateHashCodeEqualsOperation;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.handlers.JdtDomModels;
import org.eclipse.jdt.ls.core.internal.preferences.Preferences;
import org.eclipse.jdt.ls.core.internal.text.correction.SourceAssistProcessor;
import org.eclipse.lsp4j.CodeActionParams;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.eclipse.text.edits.TextEdit;

public class HashCodeEqualsHandler {
    private static final String METHODNAME_HASH_CODE = "hashCode";
    private static final String METHODNAME_EQUALS = "equals";

    public static CheckHashCodeEqualsResponse checkHashCodeEqualsStatus(CodeActionParams params) {
        return HashCodeEqualsHandler.checkHashCodeEqualsStatus(params, (IProgressMonitor)new NullProgressMonitor());
    }

    public static CheckHashCodeEqualsResponse checkHashCodeEqualsStatus(CodeActionParams params, IProgressMonitor monitor) {
        IType type = SourceAssistProcessor.getSelectionType(params, monitor);
        return HashCodeEqualsHandler.checkHashCodeEqualsStatus(type, monitor);
    }

    public static CheckHashCodeEqualsResponse checkHashCodeEqualsStatus(IType type, IProgressMonitor monitor) {
        CheckHashCodeEqualsResponse response = new CheckHashCodeEqualsResponse();
        if (type == null) {
            return response;
        }
        try {
            CompilationUnit astRoot = CoreASTProvider.getInstance().getAST((ITypeRoot)type.getCompilationUnit(), CoreASTProvider.WAIT_YES, monitor);
            if (astRoot == null) {
                return response;
            }
            ITypeBinding typeBinding = ASTNodes.getTypeBinding((CompilationUnit)astRoot, (IType)type);
            if (typeBinding != null) {
                response.type = type.getTypeQualifiedName();
                response.fields = JdtDomModels.getDeclaredFields(typeBinding, false);
                response.existingMethods = HashCodeEqualsHandler.findExistingMethods(typeBinding);
            }
        }
        catch (JavaModelException e) {
            JavaLanguageServerPlugin.logException("Check hashCode and equals status", e);
        }
        return response;
    }

    public static WorkspaceEdit generateHashCodeEquals(GenerateHashCodeEqualsParams params, IProgressMonitor monitor) {
        boolean generateComments;
        boolean useBlocks;
        boolean useInstanceof;
        Preferences preferences;
        boolean useJava7Objects;
        IType type = SourceAssistProcessor.getSelectionType(params.context, monitor);
        TextEdit edit = HashCodeEqualsHandler.generateHashCodeEqualsTextEdit(type, params.fields, params.regenerate, useJava7Objects = (preferences = JavaLanguageServerPlugin.getPreferencesManager().getPreferences()).isHashCodeEqualsTemplateUseJava7Objects(), useInstanceof = preferences.isHashCodeEqualsTemplateUseInstanceof(), useBlocks = preferences.isCodeGenerationTemplateUseBlocks(), generateComments = preferences.isCodeGenerationTemplateGenerateComments(), monitor);
        return edit == null ? null : SourceAssistProcessor.convertToWorkspaceEdit(type.getCompilationUnit(), edit);
    }

    public static TextEdit generateHashCodeEqualsTextEdit(GenerateHashCodeEqualsParams params, boolean useJava7Objects, boolean useInstanceof, boolean useBlocks, boolean generateComments) {
        return HashCodeEqualsHandler.generateHashCodeEqualsTextEdit(params, useJava7Objects, useInstanceof, useBlocks, generateComments, (IProgressMonitor)new NullProgressMonitor());
    }

    public static TextEdit generateHashCodeEqualsTextEdit(GenerateHashCodeEqualsParams params, boolean useJava7Objects, boolean useInstanceof, boolean useBlocks, boolean generateComments, IProgressMonitor monitor) {
        IType type = SourceAssistProcessor.getSelectionType(params.context, monitor);
        return HashCodeEqualsHandler.generateHashCodeEqualsTextEdit(type, params.fields, params.regenerate, useJava7Objects, useInstanceof, useBlocks, generateComments, monitor);
    }

    public static TextEdit generateHashCodeEqualsTextEdit(IType type, JdtDomModels.LspVariableBinding[] fields, boolean regenerate, boolean useJava7Objects, boolean useInstanceof, boolean useBlocks, boolean generateComments, IProgressMonitor monitor) {
        CompilationUnit astRoot;
        block5: {
            if (type == null) {
                return null;
            }
            astRoot = CoreASTProvider.getInstance().getAST((ITypeRoot)type.getCompilationUnit(), CoreASTProvider.WAIT_YES, monitor);
            if (astRoot != null) break block5;
            return null;
        }
        try {
            ITypeBinding typeBinding = ASTNodes.getTypeBinding((CompilationUnit)astRoot, (IType)type);
            if (typeBinding != null) {
                IVariableBinding[] variableBindings = JdtDomModels.convertToVariableBindings(typeBinding, fields);
                CodeGenerationSettings codeGenSettings = new CodeGenerationSettings();
                codeGenSettings.createComments = generateComments;
                codeGenSettings.overrideAnnotation = true;
                GenerateHashCodeEqualsOperation operation = new GenerateHashCodeEqualsOperation(typeBinding, variableBindings, astRoot, null, codeGenSettings, useInstanceof, useJava7Objects, regenerate, false, false);
                operation.setUseBlocksForThen(useBlocks);
                operation.run(null);
                return operation.getResultingEdit();
            }
        }
        catch (CoreException e) {
            JavaLanguageServerPlugin.logException("Generate hashCode and equals methods", e);
        }
        return null;
    }

    private static String[] findExistingMethods(ITypeBinding typeBinding) {
        IMethodBinding[] declaredMethods;
        ArrayList<String> existingMethods = new ArrayList<String>();
        IMethodBinding[] iMethodBindingArray = declaredMethods = typeBinding.getDeclaredMethods();
        int n = declaredMethods.length;
        int n2 = 0;
        while (n2 < n) {
            IMethodBinding method = iMethodBindingArray[n2];
            if (method.getName().equals(METHODNAME_EQUALS)) {
                ITypeBinding[] b = method.getParameterTypes();
                if (b.length == 1 && b[0].getQualifiedName().equals("java.lang.Object")) {
                    existingMethods.add(METHODNAME_EQUALS);
                }
            } else if (method.getName().equals(METHODNAME_HASH_CODE) && method.getParameterTypes().length == 0) {
                existingMethods.add(METHODNAME_HASH_CODE);
            }
            if (existingMethods.size() == 2) break;
            ++n2;
        }
        return existingMethods.toArray(new String[0]);
    }

    public static class CheckHashCodeEqualsResponse {
        public String type;
        public JdtDomModels.LspVariableBinding[] fields;
        public String[] existingMethods;
    }

    public static class GenerateHashCodeEqualsParams {
        public CodeActionParams context;
        public JdtDomModels.LspVariableBinding[] fields;
        public boolean regenerate;
    }
}

