/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.handlers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IImportContainer;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.SourceRange;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.compiler.IScanner;
import org.eclipse.jdt.core.compiler.InvalidInputException;
import org.eclipse.jdt.ls.core.internal.JDTUtils;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.lsp4j.FoldingRange;
import org.eclipse.lsp4j.FoldingRangeRequestParams;

public class FoldingRangeHandler {
    private static final Pattern REGION_START_PATTERN = Pattern.compile("^//\\s*#?region|^//\\s+<editor-fold.*>");
    private static final Pattern REGION_END_PATTERN = Pattern.compile("^//\\s*#?endregion|^//\\s+</editor-fold>");
    private static IScanner fScanner;

    private static IScanner getScanner() {
        if (fScanner == null) {
            fScanner = ToolFactory.createScanner((boolean)true, (boolean)false, (boolean)false, (boolean)true);
        }
        return fScanner;
    }

    public List<FoldingRange> foldingRange(FoldingRangeRequestParams params, IProgressMonitor monitor) {
        ArrayList<FoldingRange> $ = new ArrayList<FoldingRange>();
        ITypeRoot unit = JDTUtils.resolveTypeRoot(params.getTextDocument().getUri());
        if (unit == null) {
            return $;
        }
        this.computeFoldingRanges($, unit, monitor);
        return $;
    }

    private void computeFoldingRanges(List<FoldingRange> foldingRanges, ITypeRoot unit, IProgressMonitor monitor) {
        try {
            ISourceRange range = unit.getSourceRange();
            if (!SourceRange.isAvailable((ISourceRange)range)) {
                return;
            }
            String contents = unit.getSource();
            if (StringUtils.isBlank((CharSequence)contents)) {
                return;
            }
            int shift = range.getOffset();
            IScanner scanner = FoldingRangeHandler.getScanner();
            scanner.setSource(contents.toCharArray());
            scanner.resetTo(shift, shift + range.getLength());
            int start = shift;
            int token = 0;
            Stack<Integer> regionStarts = new Stack<Integer>();
            while (token != 158) {
                start = scanner.getCurrentTokenStartPosition();
                switch (token) {
                    case 1002: 
                    case 1003: {
                        int end = scanner.getCurrentTokenEndPosition();
                        FoldingRange commentFoldingRange = new FoldingRange(scanner.getLineNumber(start) - 1, scanner.getLineNumber(end) - 1);
                        commentFoldingRange.setKind("comment");
                        foldingRanges.add(commentFoldingRange);
                        break;
                    }
                    case 1001: {
                        String currentSource = String.valueOf(scanner.getCurrentTokenSource());
                        if (REGION_START_PATTERN.matcher(currentSource).lookingAt()) {
                            regionStarts.push(start);
                            break;
                        }
                        if (!REGION_END_PATTERN.matcher(currentSource).lookingAt() || regionStarts.size() <= 0) break;
                        FoldingRange regionFolding = new FoldingRange(scanner.getLineNumber(((Integer)regionStarts.pop()).intValue()) - 1, scanner.getLineNumber(start) - 1);
                        regionFolding.setKind("region");
                        foldingRanges.add(regionFolding);
                        break;
                    }
                }
                token = this.getNextToken(scanner);
            }
            this.computeTypeRootRanges(foldingRanges, unit, scanner);
        }
        catch (CoreException e) {
            JavaLanguageServerPlugin.logException("Problem with folding range for " + unit.getPath().toPortableString(), e);
            monitor.setCanceled(true);
        }
    }

    private int getNextToken(IScanner scanner) {
        int token = 0;
        while (token == 0) {
            try {
                token = scanner.getNextToken();
            }
            catch (InvalidInputException invalidInputException) {
                // empty catch block
            }
        }
        return token;
    }

    private void computeTypeRootRanges(List<FoldingRange> foldingRanges, ITypeRoot unit, IScanner scanner) throws CoreException {
        if (unit.hasChildren()) {
            IJavaElement[] iJavaElementArray = unit.getChildren();
            int n = iJavaElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IJavaElement child = iJavaElementArray[n2];
                if (child instanceof IImportContainer) {
                    ISourceRange importRange = ((IImportContainer)child).getSourceRange();
                    FoldingRange importFoldingRange = new FoldingRange(scanner.getLineNumber(importRange.getOffset()) - 1, scanner.getLineNumber(importRange.getOffset() + importRange.getLength()) - 1);
                    importFoldingRange.setKind("imports");
                    foldingRanges.add(importFoldingRange);
                } else if (child instanceof IType) {
                    this.computeTypeRanges(foldingRanges, (IType)child, scanner);
                }
                ++n2;
            }
        }
    }

    private void computeTypeRanges(List<FoldingRange> foldingRanges, IType unit, IScanner scanner) throws CoreException {
        IJavaElement[] children;
        ISourceRange typeRange = unit.getSourceRange();
        foldingRanges.add(new FoldingRange(scanner.getLineNumber(unit.getNameRange().getOffset()) - 1, scanner.getLineNumber(typeRange.getOffset() + typeRange.getLength()) - 1));
        IJavaElement[] iJavaElementArray = children = unit.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaElement c = iJavaElementArray[n2];
            if (c instanceof IMethod) {
                this.computeMethodRanges(foldingRanges, (IMethod)c, scanner);
            } else if (c instanceof IType) {
                this.computeTypeRanges(foldingRanges, (IType)c, scanner);
            }
            ++n2;
        }
    }

    private void computeMethodRanges(List<FoldingRange> foldingRanges, IMethod method, IScanner scanner) throws CoreException {
        ISourceRange sourceRange = method.getSourceRange();
        int shift = sourceRange.getOffset();
        scanner.resetTo(shift, shift + sourceRange.getLength());
        foldingRanges.add(new FoldingRange(scanner.getLineNumber(method.getNameRange().getOffset()) - 1, scanner.getLineNumber(shift + sourceRange.getLength()) - 1));
        int start = shift;
        int token = 0;
        Stack<Integer> leftParens = null;
        int prevCaseLine = -1;
        HashMap<Integer, Integer> candidates = new HashMap<Integer, Integer>();
        while (token != 158) {
            start = scanner.getCurrentTokenStartPosition();
            switch (token) {
                case 110: {
                    int originalStartLine;
                    if (leftParens == null) {
                        leftParens = new Stack<Integer>();
                        break;
                    }
                    int startLine = scanner.getLineNumber(start) - 1;
                    if (candidates.containsKey(startLine) && (originalStartLine = ((Integer)candidates.remove(startLine)).intValue()) < startLine - 1) {
                        candidates.put(startLine - 1, originalStartLine);
                    }
                    leftParens.push(startLine);
                    break;
                }
                case 95: {
                    int endPos = scanner.getCurrentTokenEndPosition();
                    if (leftParens == null || leftParens.size() <= 0) break;
                    int endLine = scanner.getLineNumber(endPos) - 1;
                    int startLine = (Integer)leftParens.pop();
                    if (startLine < endLine) {
                        candidates.put(endLine, startLine);
                    }
                    if (startLine >= prevCaseLine) break;
                    if (endLine - 1 > prevCaseLine) {
                        candidates.put(endLine - 1, prevCaseLine);
                    }
                    prevCaseLine = -1;
                    break;
                }
                case 211: 
                case 212: {
                    int currentLine = scanner.getLineNumber(start) - 1;
                    if (prevCaseLine != -1 && currentLine - 1 >= prevCaseLine) {
                        candidates.put(scanner.getLineNumber(start) - 2, prevCaseLine);
                    }
                    prevCaseLine = currentLine;
                    break;
                }
            }
            token = this.getNextToken(scanner);
        }
        for (Map.Entry entry : candidates.entrySet()) {
            foldingRanges.add(new FoldingRange(((Integer)entry.getValue()).intValue(), ((Integer)entry.getKey()).intValue()));
        }
    }
}

