/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.handlers;

import com.google.common.io.CharStreams;
import com.google.common.util.concurrent.SimpleTimeLimiter;
import com.google.common.util.concurrent.UncheckedTimeoutException;
import java.io.Reader;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.CompletionProposal;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.codeassist.InternalCompletionProposal;
import org.eclipse.jdt.internal.codeassist.impl.Engine;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.corext.template.java.SignatureUtil;
import org.eclipse.jdt.ls.core.internal.JDTUtils;
import org.eclipse.jdt.ls.core.internal.JSONUtility;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.contentassist.CompletionProposalReplacementProvider;
import org.eclipse.jdt.ls.core.internal.contentassist.CompletionProposalRequestor;
import org.eclipse.jdt.ls.core.internal.handlers.CompletionResponse;
import org.eclipse.jdt.ls.core.internal.handlers.CompletionResponses;
import org.eclipse.jdt.ls.core.internal.javadoc.JavadocContentAccess;
import org.eclipse.jdt.ls.core.internal.javadoc.JavadocContentAccess2;
import org.eclipse.jdt.ls.core.internal.preferences.PreferenceManager;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.MarkupContent;
import org.eclipse.osgi.util.NLS;

public class CompletionResolveHandler {
    public static final String EMPTY_STRING = "";
    public static final String DEFAULT = "Default: ";
    private static final String VALUE = "Value: ";
    private final PreferenceManager manager;
    public static final String DATA_FIELD_URI = "uri";
    public static final String DATA_FIELD_DECLARATION_SIGNATURE = "decl_signature";
    public static final String DATA_FIELD_SIGNATURE = "signature";
    public static final String DATA_FIELD_NAME = "name";
    public static final String DATA_FIELD_REQUEST_ID = "rid";
    public static final String DATA_FIELD_PROPOSAL_ID = "pid";
    public static final String DATA_FIELD_CONSTANT_VALUE = "constant_value";
    public static final String DATA_METHOD_DEFAULT_VALUE = "default_value";

    public CompletionResolveHandler(PreferenceManager manager) {
        this.manager = manager;
    }

    public CompletionItem resolve(CompletionItem param, IProgressMonitor monitor) {
        block25: {
            Map data = JSONUtility.toModel(param.getData(), Map.class);
            param.setData(null);
            if (!(CompletionProposalRequestor.SUPPORTED_KINDS.contains(param.getKind()) && data != null && data.containsKey(DATA_FIELD_URI) && data.containsKey(DATA_FIELD_REQUEST_ID) && data.containsKey(DATA_FIELD_PROPOSAL_ID))) {
                return param;
            }
            int proposalId = Integer.parseInt((String)data.get(DATA_FIELD_PROPOSAL_ID));
            long requestId = Long.parseLong((String)data.get(DATA_FIELD_REQUEST_ID));
            CompletionResponse completionResponse = CompletionResponses.get(requestId);
            if (completionResponse == null || completionResponse.getProposals().size() <= proposalId) {
                throw new IllegalStateException("Invalid completion proposal");
            }
            String uri = (String)data.get(DATA_FIELD_URI);
            ICompilationUnit unit = JDTUtils.resolveCompilationUnit(uri);
            if (unit == null) {
                throw new IllegalStateException(NLS.bind((String)"Unable to match Compilation Unit from {0} ", (Object)uri));
            }
            if (monitor.isCanceled()) {
                param.setData(null);
                return param;
            }
            if (this.manager.getClientPreferences().isResolveAdditionalTextEditsSupport()) {
                CompletionProposalReplacementProvider proposalProvider = new CompletionProposalReplacementProvider(unit, completionResponse.getContext(), completionResponse.getOffset(), this.manager.getPreferences(), this.manager.getClientPreferences());
                proposalProvider.updateAdditionalTextEdits(completionResponse.getProposals().get(proposalId), param, '\u0000');
            }
            if (data.containsKey(DATA_FIELD_DECLARATION_SIGNATURE)) {
                String typeName = SignatureUtil.stripSignatureToFQN((String)String.valueOf(data.get(DATA_FIELD_DECLARATION_SIGNATURE)));
                try {
                    String defaultValue;
                    IType member = null;
                    IType type = unit.getJavaProject().findType(typeName);
                    if (type != null && data.containsKey(DATA_FIELD_NAME)) {
                        IMethod method;
                        IMethod[] methods;
                        Binding binding;
                        CompletionProposal proposal = completionResponse.getProposals().get(proposalId);
                        String name = (String)data.get(DATA_FIELD_NAME);
                        String[] paramSigs = CharOperation.NO_STRINGS;
                        if (data.containsKey(DATA_FIELD_SIGNATURE) && proposal instanceof InternalCompletionProposal && (binding = ((InternalCompletionProposal)proposal).getBinding()) instanceof MethodBinding) {
                            MethodBinding methodBinding = (MethodBinding)binding;
                            MethodBinding original = methodBinding.original();
                            char[] signature = original != binding ? Engine.getSignature((MethodBinding)original) : Engine.getSignature((MethodBinding)methodBinding);
                            String[] parameters = Signature.getParameterTypes((String)String.valueOf(SignatureUtil.fix83600((char[])signature)));
                            int i = 0;
                            while (i < parameters.length) {
                                parameters[i] = SignatureUtil.getLowerBound((String)parameters[i]);
                                ++i;
                            }
                            paramSigs = parameters;
                        }
                        if ((methods = type.findMethods(method = type.getMethod(name, paramSigs))) != null && methods.length > 0) {
                            method = methods[0];
                        }
                        if (method.exists()) {
                            member = method;
                        } else {
                            IField field = type.getField(name);
                            if (field.exists()) {
                                member = field;
                            }
                        }
                    } else {
                        member = type;
                    }
                    if (member == null || !member.exists() || monitor.isCanceled()) break block25;
                    String javadoc = null;
                    try {
                        IType curMember = member;
                        javadoc = (String)SimpleTimeLimiter.create((ExecutorService)Executors.newCachedThreadPool()).callWithTimeout(() -> this.lambda$0((IMember)curMember), 500L, TimeUnit.MILLISECONDS);
                    }
                    catch (UncheckedTimeoutException | TimeoutException tooSlow) {
                        monitor.setCanceled(true);
                    }
                    catch (Exception e) {
                        JavaLanguageServerPlugin.logException("Unable to read documentation", e);
                        monitor.setCanceled(true);
                    }
                    String constantValue = (String)data.get(DATA_FIELD_CONSTANT_VALUE);
                    if (constantValue != null) {
                        javadoc = this.manager.getClientPreferences().isSupportsCompletionDocumentationMarkdown() ? String.valueOf(javadoc == null ? EMPTY_STRING : javadoc) + "\n\n" + VALUE + constantValue : String.valueOf(javadoc == null ? EMPTY_STRING : javadoc) + VALUE + constantValue;
                    }
                    if ((defaultValue = (String)data.get(DATA_METHOD_DEFAULT_VALUE)) != null) {
                        javadoc = this.manager.getClientPreferences().isSupportsCompletionDocumentationMarkdown() ? String.valueOf(javadoc == null ? EMPTY_STRING : javadoc) + "\n\n" + DEFAULT + defaultValue : String.valueOf(javadoc == null ? EMPTY_STRING : javadoc) + DEFAULT + defaultValue;
                    }
                    if (javadoc != null) {
                        if (this.manager.getClientPreferences().isSupportsCompletionDocumentationMarkdown()) {
                            MarkupContent markupContent = new MarkupContent();
                            markupContent.setKind("markdown");
                            markupContent.setValue(javadoc);
                            param.setDocumentation(markupContent);
                        } else {
                            param.setDocumentation(javadoc);
                        }
                    }
                }
                catch (JavaModelException e) {
                    JavaLanguageServerPlugin.logException("Unable to resolve compilation", e);
                    monitor.setCanceled(true);
                }
            }
        }
        if (monitor.isCanceled()) {
            param.setData(null);
        }
        return param;
    }

    private /* synthetic */ String lambda$0(IMember iMember) throws Exception {
        Reader reader = this.manager.getClientPreferences().isSupportsCompletionDocumentationMarkdown() ? JavadocContentAccess2.getMarkdownContentReader((IJavaElement)iMember) : JavadocContentAccess.getPlainTextContentReader(iMember);
        return reader == null ? null : CharStreams.toString((Readable)reader);
    }
}

