/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.handlers;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.ProgressMonitorWrapper;
import org.eclipse.jdt.core.CompletionRequestor;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.WorkingCopyOwner;
import org.eclipse.jdt.internal.core.DefaultWorkingCopyOwner;
import org.eclipse.jdt.ls.core.internal.JDTEnvironmentUtils;
import org.eclipse.jdt.ls.core.internal.JDTUtils;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.contentassist.CompletionProposalRequestor;
import org.eclipse.jdt.ls.core.internal.contentassist.JavadocCompletionProposal;
import org.eclipse.jdt.ls.core.internal.contentassist.SnippetCompletionProposal;
import org.eclipse.jdt.ls.core.internal.handlers.CompletionResponses;
import org.eclipse.jdt.ls.core.internal.handlers.JsonRpcHelpers;
import org.eclipse.jdt.ls.core.internal.preferences.PreferenceManager;
import org.eclipse.jdt.ls.core.internal.syntaxserver.ModelBasedCompletionEngine;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionList;
import org.eclipse.lsp4j.CompletionOptions;
import org.eclipse.lsp4j.CompletionParams;
import org.eclipse.lsp4j.jsonrpc.messages.Either;

public class CompletionHandler {
    public static final CompletionOptions DEFAULT_COMPLETION_OPTIONS = new CompletionOptions(Boolean.TRUE, Arrays.asList(".", "@", "#", "*"));
    private static final Set<String> UNSUPPORTED_RESOURCES = Sets.newHashSet((Object[])new String[]{"module-info.java", "package-info.java"});
    static final Comparator<CompletionItem> PROPOSAL_COMPARATOR = new Comparator<CompletionItem>(){
        private final String DEFAULT_SORT_TEXT = String.valueOf(99999999);

        @Override
        public int compare(CompletionItem o1, CompletionItem o2) {
            return this.getSortText(o1).compareTo(this.getSortText(o2));
        }

        private String getSortText(CompletionItem ci) {
            return StringUtils.defaultString((String)ci.getSortText(), (String)this.DEFAULT_SORT_TEXT);
        }
    };
    private PreferenceManager manager;

    public CompletionHandler(PreferenceManager manager) {
        this.manager = manager;
    }

    public Either<List<CompletionItem>, CompletionList> completion(CompletionParams position, IProgressMonitor monitor) {
        CompletionList $ = null;
        try {
            ICompilationUnit unit = JDTUtils.resolveCompilationUnit(position.getTextDocument().getUri());
            $ = this.computeContentAssist(unit, position.getPosition().getLine(), position.getPosition().getCharacter(), monitor);
        }
        catch (OperationCanceledException ignorable) {
            monitor.setCanceled(true);
        }
        catch (Exception e) {
            JavaLanguageServerPlugin.logException("Problem with codeComplete for " + position.getTextDocument().getUri(), e);
            monitor.setCanceled(true);
        }
        if ($ == null) {
            $ = new CompletionList();
        }
        if ($.getItems() == null) {
            $.setItems(Collections.emptyList());
        }
        if (monitor.isCanceled()) {
            $.setIsIncomplete(true);
            JavaLanguageServerPlugin.logInfo("Completion request cancelled");
        } else {
            JavaLanguageServerPlugin.logInfo("Completion request completed");
        }
        return Either.forRight((Object)$);
    }

    private CompletionList computeContentAssist(ICompilationUnit unit, int line, int column, IProgressMonitor monitor) throws JavaModelException {
        IBuffer buffer;
        CompletionResponses.clear();
        if (unit == null) {
            return null;
        }
        ArrayList<CompletionItem> proposals = new ArrayList<CompletionItem>();
        int offset = JsonRpcHelpers.toOffset(unit.getBuffer(), line, column);
        CompletionProposalRequestor collector = new CompletionProposalRequestor(unit, offset, this.manager);
        collector.setAllowsRequiredProposals(2, 9, true);
        collector.setAllowsRequiredProposals(2, 23, true);
        collector.setAllowsRequiredProposals(2, 21, true);
        collector.setAllowsRequiredProposals(6, 9, true);
        collector.setAllowsRequiredProposals(6, 23, true);
        collector.setAllowsRequiredProposals(6, 22, true);
        collector.setAllowsRequiredProposals(26, 9, true);
        collector.setAllowsRequiredProposals(27, 9, true);
        collector.setAllowsRequiredProposals(1, 9, true);
        collector.setAllowsRequiredProposals(9, 9, true);
        collector.setFavoriteReferences(this.getFavoriteStaticMembers());
        if (offset > -1 && !monitor.isCanceled() && (buffer = unit.getBuffer()) != null && buffer.getLength() >= offset) {
            ProgressMonitorWrapper subMonitor = new ProgressMonitorWrapper(monitor){
                private long timeLimit;
                private final long TIMEOUT;
                {
                    this.TIMEOUT = Long.getLong("completion.timeout", 5000L);
                }

                public void beginTask(String name, int totalWork) {
                    this.timeLimit = System.currentTimeMillis() + this.TIMEOUT;
                }

                public boolean isCanceled() {
                    return super.isCanceled() || this.timeLimit <= System.currentTimeMillis();
                }
            };
            try {
                if (this.isIndexEngineEnabled()) {
                    unit.codeComplete(offset, (CompletionRequestor)collector, (IProgressMonitor)subMonitor);
                } else {
                    ModelBasedCompletionEngine.codeComplete(unit, offset, collector, (WorkingCopyOwner)DefaultWorkingCopyOwner.PRIMARY, (IProgressMonitor)subMonitor);
                }
                proposals.addAll(collector.getCompletionItems());
                if (this.isSnippetStringSupported() && !UNSUPPORTED_RESOURCES.contains(unit.getResource().getName())) {
                    proposals.addAll(SnippetCompletionProposal.getSnippets(unit, collector.getContext(), (IProgressMonitor)subMonitor));
                }
                proposals.addAll(new JavadocCompletionProposal().getProposals(unit, offset, collector, (IProgressMonitor)subMonitor));
            }
            catch (OperationCanceledException e) {
                monitor.setCanceled(true);
            }
        }
        proposals.sort(PROPOSAL_COMPARATOR);
        CompletionList list = new CompletionList(proposals);
        list.setIsIncomplete(!collector.isComplete());
        return list;
    }

    private String[] getFavoriteStaticMembers() {
        PreferenceManager preferenceManager = JavaLanguageServerPlugin.getPreferencesManager();
        if (preferenceManager != null) {
            return preferenceManager.getPreferences().getJavaCompletionFavoriteMembers();
        }
        return new String[0];
    }

    private boolean isSnippetStringSupported() {
        return JavaLanguageServerPlugin.getPreferencesManager() != null && JavaLanguageServerPlugin.getPreferencesManager().getClientPreferences() != null && JavaLanguageServerPlugin.getPreferencesManager().getClientPreferences().isCompletionSnippetsSupported();
    }

    public boolean isIndexEngineEnabled() {
        return !JDTEnvironmentUtils.isSyntaxServer();
    }
}

