/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.contentassist;

import java.lang.reflect.Field;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.core.CompletionContext;
import org.eclipse.jdt.core.CompletionProposal;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.internal.codeassist.CompletionEngine;
import org.eclipse.jdt.internal.corext.template.java.SignatureUtil;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.lsp4j.CompletionItem;

public class CompletionProposalDescriptionProvider {
    private static final String RETURN_TYPE_SEPARATOR = " : ";
    private static final String PACKAGE_NAME_SEPARATOR = " - ";
    private static final String VAR_TYPE_SEPARATOR = " : ";
    private static final String OBJECT = "java.lang.Object";
    private CompletionContext fContext;

    public CompletionProposalDescriptionProvider(CompletionContext context) {
        this.fContext = context;
    }

    public StringBuilder createMethodProposalDescription(CompletionProposal proposal) {
        int kind = proposal.getKind();
        StringBuilder description = new StringBuilder();
        switch (kind) {
            case 6: 
            case 11: 
            case 12: 
            case 26: {
                description.append(proposal.getName());
                description.append('(');
                this.appendUnboundedParameterList(description, proposal);
                description.append(')');
                if (proposal.isConstructor()) break;
                char[] returnType = this.createTypeDisplayName(SignatureUtil.getUpperBound((char[])Signature.getReturnType((char[])SignatureUtil.fix83600((char[])proposal.getSignature()))));
                description.append(" : ");
                description.append(returnType);
            }
        }
        return description;
    }

    public StringBuilder createParameterList(CompletionProposal proposal) {
        int kind = proposal.getKind();
        switch (kind) {
            case 6: 
            case 26: {
                return this.appendUnboundedParameterList(new StringBuilder(), proposal);
            }
            case 9: 
            case 16: {
                return this.appendTypeParameterList(new StringBuilder(), proposal);
            }
            case 1: 
            case 27: {
                return this.appendUnboundedParameterList(new StringBuilder(), proposal);
            }
        }
        Assert.isLegal((boolean)false);
        return null;
    }

    private StringBuilder appendUnboundedParameterList(StringBuilder buffer, CompletionProposal methodProposal) {
        char[][] parameterNames;
        char[] signature = SignatureUtil.fix83600((char[])methodProposal.getSignature());
        try {
            parameterNames = methodProposal.findParameterNames(null);
        }
        catch (Exception e) {
            JavaLanguageServerPlugin.logException(e.getMessage(), e);
            parameterNames = CompletionEngine.createDefaultParameterNames((int)Signature.getParameterCount((char[])signature));
            methodProposal.setParameterNames(parameterNames);
        }
        char[][] parameterTypes = Signature.getParameterTypes((char[])signature);
        int i = 0;
        while (i < parameterTypes.length) {
            parameterTypes[i] = this.createTypeDisplayName(SignatureUtil.getLowerBound((char[])parameterTypes[i]));
            ++i;
        }
        if (Flags.isVarargs((int)methodProposal.getFlags())) {
            int index = parameterTypes.length - 1;
            parameterTypes[index] = this.convertToVararg(parameterTypes[index]);
        }
        return this.appendParameterSignature(buffer, parameterTypes, parameterNames);
    }

    private StringBuilder appendTypeParameterList(StringBuilder buffer, CompletionProposal typeProposal) {
        char[] signature = SignatureUtil.fix83600((char[])typeProposal.getSignature());
        char[][] typeParameters = Signature.getTypeArguments((char[])signature);
        int i = 0;
        while (i < typeParameters.length) {
            char[] param = typeParameters[i];
            typeParameters[i] = Signature.toCharArray((char[])param);
            ++i;
        }
        return this.appendParameterSignature(buffer, typeParameters, null);
    }

    private char[] convertToVararg(char[] typeName) {
        if (typeName == null) {
            return typeName;
        }
        int len = typeName.length;
        if (len < 2) {
            return typeName;
        }
        if (typeName[len - 1] != ']') {
            return typeName;
        }
        if (typeName[len - 2] != '[') {
            return typeName;
        }
        char[] vararg = new char[len + 1];
        System.arraycopy(typeName, 0, vararg, 0, len - 2);
        vararg[len - 2] = 46;
        vararg[len - 1] = 46;
        vararg[len] = 46;
        return vararg;
    }

    private char[] createTypeDisplayName(char[] typeSignature) throws IllegalArgumentException {
        char[] displayName = Signature.getSimpleName((char[])Signature.toCharArray((char[])typeSignature));
        boolean useShortGenerics = false;
        if (useShortGenerics) {
            int pos;
            StringBuilder buf = new StringBuilder();
            buf.append(displayName);
            do {
                if ((pos = buf.indexOf("? extends ")) >= 0) {
                    buf.replace(pos, pos + 10, "+");
                    continue;
                }
                pos = buf.indexOf("? super ");
                if (pos < 0) continue;
                buf.replace(pos, pos + 8, "-");
            } while (pos >= 0);
            return buf.toString().toCharArray();
        }
        return displayName;
    }

    private final StringBuilder appendParameterSignature(StringBuilder buffer, char[][] parameterTypes, char[][] parameterNames) {
        if (parameterTypes != null) {
            int i = 0;
            while (i < parameterTypes.length) {
                if (i > 0) {
                    buffer.append(',');
                    buffer.append(' ');
                }
                buffer.append(parameterTypes[i]);
                if (parameterNames != null && parameterNames[i] != null) {
                    buffer.append(' ');
                    buffer.append(parameterNames[i]);
                }
                ++i;
            }
        }
        return buffer;
    }

    private void createMethodProposalLabel(CompletionProposal methodProposal, CompletionItem item) {
        String qualifier;
        StringBuilder description = this.createMethodProposalDescription(methodProposal);
        item.setLabel(description.toString());
        item.setInsertText(String.valueOf(methodProposal.getName()));
        StringBuilder typeInfo = new StringBuilder();
        String declaringType = this.extractDeclaringTypeFQN(methodProposal);
        if (methodProposal.getRequiredProposals() != null && (qualifier = Signature.getQualifier((String)declaringType)).length() > 0) {
            typeInfo.append(qualifier);
            typeInfo.append('.');
        }
        declaringType = Signature.getSimpleName((String)declaringType);
        typeInfo.append(declaringType);
        StringBuilder detail = new StringBuilder();
        if (typeInfo.length() > 0) {
            detail.append((CharSequence)typeInfo);
            detail.append('.');
        }
        detail.append((CharSequence)description);
        item.setDetail(detail.toString());
        this.setSignature(item, String.valueOf(methodProposal.getSignature()));
        this.setDeclarationSignature(item, String.valueOf(methodProposal.getDeclarationSignature()));
        this.setName(item, String.valueOf(methodProposal.getName()));
    }

    private void createJavadocMethodProposalLabel(CompletionProposal methodProposal, CompletionItem item) {
        item.setLabel(String.valueOf(methodProposal.getCompletion()));
        String declaringType = this.extractDeclaringTypeFQN(methodProposal);
        declaringType = Signature.getSimpleName((String)declaringType);
        item.setDetail(declaringType);
    }

    private void createOverrideMethodProposalLabel(CompletionProposal methodProposal, CompletionItem item) {
        StringBuilder nameBuffer = new StringBuilder();
        String name = new String(methodProposal.getName());
        item.setInsertText(name);
        nameBuffer.append(name);
        nameBuffer.append('(');
        this.appendUnboundedParameterList(nameBuffer, methodProposal);
        nameBuffer.append(')');
        nameBuffer.append(" : ");
        char[] returnType = this.createTypeDisplayName(SignatureUtil.getUpperBound((char[])Signature.getReturnType((char[])SignatureUtil.fix83600((char[])methodProposal.getSignature()))));
        nameBuffer.append(returnType);
        item.setLabel(nameBuffer.toString());
        item.setFilterText(name);
        StringBuilder typeBuffer = new StringBuilder();
        String declaringType = this.extractDeclaringTypeFQN(methodProposal);
        declaringType = Signature.getSimpleName((String)declaringType);
        typeBuffer.append(String.format("Override method in '%s'", declaringType));
        item.setDetail(typeBuffer.toString());
        this.setSignature(item, String.valueOf(methodProposal.getSignature()));
        this.setDeclarationSignature(item, String.valueOf(methodProposal.getDeclarationSignature()));
        this.setName(item, String.valueOf(methodProposal.getName()));
    }

    private String extractDeclaringTypeFQN(CompletionProposal methodProposal) {
        char[] declaringTypeSignature = methodProposal.getDeclarationSignature();
        if (declaringTypeSignature == null) {
            return OBJECT;
        }
        return SignatureUtil.stripSignatureToFQN((String)String.valueOf(declaringTypeSignature));
    }

    private void createTypeProposalLabel(CompletionProposal typeProposal, CompletionItem item) {
        char[] signature = this.fContext != null && this.fContext.isInJavadoc() ? Signature.getTypeErasure((char[])typeProposal.getSignature()) : typeProposal.getSignature();
        char[] fullName = Signature.toCharArray((char[])signature);
        this.createTypeProposalLabel(fullName, item);
        this.setDeclarationSignature(item, String.valueOf(signature));
    }

    private void createJavadocTypeProposalLabel(CompletionProposal typeProposal, CompletionItem item) {
        char[] fullName = Signature.toCharArray((char[])typeProposal.getSignature());
        this.createJavadocTypeProposalLabel(fullName, item);
    }

    private void createJavadocSimpleProposalLabel(CompletionProposal proposal, CompletionItem item) {
        item.setLabel(this.createSimpleLabel(proposal).toString());
    }

    void createTypeProposalLabel(char[] fullName, CompletionItem item) {
        int qIndex = this.findSimpleNameStart(fullName);
        String name = new String(fullName, qIndex, fullName.length - qIndex);
        StringBuilder nameBuffer = new StringBuilder();
        nameBuffer.append(name);
        if (qIndex > 0) {
            nameBuffer.append(PACKAGE_NAME_SEPARATOR);
            nameBuffer.append(new String(fullName, 0, qIndex - 1));
        }
        item.setFilterText(name);
        item.setInsertText(name);
        item.setLabel(nameBuffer.toString());
        item.setDetail(new String(fullName));
    }

    private void createJavadocTypeProposalLabel(char[] fullName, CompletionItem item) {
        int qIndex = this.findSimpleNameStart(fullName);
        StringBuilder nameBuffer = new StringBuilder();
        String name = new String(fullName, qIndex, fullName.length - qIndex);
        nameBuffer.append("{@link ");
        nameBuffer.append(name);
        nameBuffer.append('}');
        item.setLabel(nameBuffer.toString());
        item.setFilterText(name);
        if (qIndex > 0) {
            item.setDetail(new String(fullName, 0, qIndex - 1));
        }
    }

    private int findSimpleNameStart(char[] array) {
        int lastDot = 0;
        int i = 0;
        int len = array.length;
        while (i < len) {
            char ch = array[i];
            if (ch == '<') {
                return lastDot;
            }
            if (ch == '.') {
                lastDot = i + 1;
            }
            ++i;
        }
        return lastDot;
    }

    private void createSimpleLabelWithType(CompletionProposal proposal, CompletionItem item) {
        StringBuilder nameBuffer = new StringBuilder();
        nameBuffer.append(proposal.getCompletion());
        item.setInsertText(nameBuffer.toString());
        char[] typeName = Signature.getSignatureSimpleName((char[])proposal.getSignature());
        if (typeName.length > 0) {
            nameBuffer.append(" : ");
            nameBuffer.append(typeName);
        }
        item.setLabel(nameBuffer.toString());
    }

    private boolean isThisPrefix(char[] string) {
        if (string == null || string.length < 5) {
            return false;
        }
        return string[0] == 't' && string[1] == 'h' && string[2] == 'i' && string[3] == 's' && string[4] == '.';
    }

    private void createLabelWithTypeAndDeclaration(CompletionProposal proposal, CompletionItem item) {
        char[] name = proposal.getCompletion();
        if (!this.isThisPrefix(name)) {
            name = proposal.getName();
        }
        StringBuilder buf = new StringBuilder();
        buf.append(name);
        item.setInsertText(buf.toString());
        char[] typeName = Signature.getSignatureSimpleName((char[])proposal.getSignature());
        if (typeName.length > 0) {
            buf.append(" : ");
            buf.append(typeName);
        }
        item.setLabel(buf.toString());
        char[] declaration = proposal.getDeclarationSignature();
        StringBuilder detailBuf = new StringBuilder();
        if (declaration != null) {
            this.setDeclarationSignature(item, String.valueOf(declaration));
            declaration = Signature.getSignatureSimpleName((char[])declaration);
            if (declaration.length > 0) {
                String declaringType;
                String qualifier;
                if (proposal.getRequiredProposals() != null && (qualifier = Signature.getQualifier((String)(declaringType = this.extractDeclaringTypeFQN(proposal)))).length() > 0) {
                    detailBuf.append(qualifier);
                    detailBuf.append('.');
                }
                detailBuf.append(declaration);
            }
        }
        if (detailBuf.length() > 0) {
            detailBuf.append('.');
        }
        detailBuf.append((CharSequence)buf);
        item.setDetail(detailBuf.toString());
        this.setName(item, String.valueOf(name));
    }

    private void createPackageProposalLabel(CompletionProposal proposal, CompletionItem item) {
        Assert.isTrue((proposal.getKind() == 8 || proposal.getKind() == 29 || proposal.getKind() == 28 ? 1 : 0) != 0);
        item.setLabel(String.valueOf(proposal.getDeclarationSignature()));
        StringBuilder detail = new StringBuilder();
        detail.append(proposal.getKind() == 8 ? "(package) " : "(module) ");
        detail.append(String.valueOf(proposal.getDeclarationSignature()));
        item.setDetail(detail.toString());
    }

    StringBuilder createSimpleLabel(CompletionProposal proposal) {
        StringBuilder buf = new StringBuilder();
        buf.append(String.valueOf(proposal.getCompletion()));
        return buf;
    }

    private void createAnonymousTypeLabel(CompletionProposal proposal, CompletionItem item) {
        char[] signatureQualifier;
        char[] declaringTypeSignature = proposal.getDeclarationSignature();
        declaringTypeSignature = Signature.getTypeErasure((char[])declaringTypeSignature);
        String name = new String(Signature.getSignatureSimpleName((char[])declaringTypeSignature));
        item.setInsertText(name);
        StringBuilder buf = new StringBuilder();
        buf.append(name);
        buf.append('(');
        this.appendUnboundedParameterList(buf, proposal);
        buf.append(')');
        buf.append("  ");
        buf.append("Anonymous Inner Type");
        item.setLabel(buf.toString());
        if (proposal.getRequiredProposals() != null && (signatureQualifier = Signature.getSignatureQualifier((char[])declaringTypeSignature)).length > 0) {
            item.setDetail(String.valueOf(String.valueOf(signatureQualifier)) + "." + name);
        }
        this.setDeclarationSignature(item, String.valueOf(declaringTypeSignature));
    }

    private void setSignature(CompletionItem item, String signature) {
        ((Map)item.getData()).put("signature", String.valueOf(signature));
    }

    private void setDeclarationSignature(CompletionItem item, String signature) {
        ((Map)item.getData()).put("decl_signature", String.valueOf(signature));
    }

    private void setName(CompletionItem item, String name) {
        ((Map)item.getData()).put("name", String.valueOf(name));
    }

    public void updateDescription(CompletionProposal proposal, CompletionItem item) {
        switch (proposal.getKind()) {
            case 6: 
            case 11: 
            case 12: 
            case 24: 
            case 26: {
                if (this.fContext != null && this.fContext.isInJavadoc()) {
                    this.createJavadocMethodProposalLabel(proposal, item);
                    break;
                }
                this.createMethodProposalLabel(proposal, item);
                break;
            }
            case 7: {
                this.createOverrideMethodProposalLabel(proposal, item);
                break;
            }
            case 1: 
            case 27: {
                this.createAnonymousTypeLabel(proposal, item);
                break;
            }
            case 9: {
                this.createTypeProposalLabel(proposal, item);
                break;
            }
            case 16: {
                this.createJavadocTypeProposalLabel(proposal, item);
                break;
            }
            case 14: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                this.createJavadocSimpleProposalLabel(proposal, item);
                break;
            }
            case 15: {
                this.createJavadocMethodProposalLabel(proposal, item);
                break;
            }
            case 8: 
            case 28: 
            case 29: {
                this.createPackageProposalLabel(proposal, item);
                break;
            }
            case 2: 
            case 13: 
            case 25: {
                this.createLabelWithTypeAndDeclaration(proposal, item);
                break;
            }
            case 5: 
            case 10: {
                this.createSimpleLabelWithType(proposal, item);
                break;
            }
            case 3: 
            case 4: {
                item.setLabel(this.createSimpleLabel(proposal).toString());
                break;
            }
            default: {
                JavaLanguageServerPlugin.logInfo(String.valueOf(new String(proposal.getName())) + " is of type " + this.getProposal(proposal));
                Assert.isTrue((boolean)false);
            }
        }
    }

    private String getProposal(CompletionProposal proposal) {
        try {
            Field[] fieldArray = CompletionProposal.class.getDeclaredFields();
            int n = fieldArray.length;
            int n2 = 0;
            while (n2 < n) {
                Field field = fieldArray[n2];
                if (Integer.TYPE.equals(field.getType()) && Integer.valueOf(proposal.getKind()).equals(field.get(null))) {
                    return field.getName();
                }
                ++n2;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "unknown";
    }
}

