/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.binaryproject.ui.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.maven.model.Dependency;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.m2e.binaryproject.internal.AbstractBinaryProjectsImportJob;
import org.eclipse.m2e.core.embedder.ArtifactKey;
import org.eclipse.m2e.core.project.ProjectImportConfiguration;
import org.eclipse.m2e.core.ui.internal.actions.SelectionUtil;
import org.eclipse.m2e.core.ui.internal.wizards.MavenDependenciesWizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;

public class BinaryProjectImportWizard
extends Wizard
implements IImportWizard {
    private MavenDependenciesWizardPage artifactsPage;
    private List<Dependency> initialDependencies;

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        ArrayList<Dependency> dependencies = new ArrayList<Dependency>();
        for (Object element : selection) {
            ArtifactKey artifactKey = (ArtifactKey)SelectionUtil.getType(element, ArtifactKey.class);
            if (artifactKey == null) continue;
            Dependency d = new Dependency();
            d.setGroupId(artifactKey.groupId());
            d.setArtifactId(artifactKey.artifactId());
            d.setVersion(artifactKey.version());
            d.setClassifier(artifactKey.classifier());
            dependencies.add(d);
        }
        this.artifactsPage = new MavenDependenciesWizardPage(new ProjectImportConfiguration(), "Artifacts", "Select artifacts to import"){

            protected void createAdvancedSettings(Composite composite, GridData gridData) {
            }
        };
        this.artifactsPage.setDependencies(dependencies.toArray(new Dependency[dependencies.size()]));
        this.artifactsPage.addListener(event -> this.getContainer().updateButtons());
        this.initialDependencies = Collections.unmodifiableList(dependencies);
    }

    public boolean performFinish() {
        final List artifacts = this.artifactsPage.getDependencies().stream().map(d -> new ArtifactKey(d.getGroupId(), d.getArtifactId(), d.getVersion(), d.getClassifier())).collect(Collectors.toList());
        if (!artifacts.isEmpty()) {
            new AbstractBinaryProjectsImportJob(){

                protected Collection<ArtifactKey> getArtifactKeys(IProgressMonitor monitor) {
                    return artifacts;
                }
            }.schedule();
        }
        return !artifacts.isEmpty();
    }

    public boolean canFinish() {
        return !this.artifactsPage.getDependencies().isEmpty();
    }

    public void addPages() {
        this.addPage((IWizardPage)this.artifactsPage);
    }

    public List<Dependency> getInitialDependencies() {
        return this.initialDependencies;
    }
}

