/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.editors;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.AbstractRepositoryConnectorUi;
import org.eclipse.mylyn.tasks.ui.AbstractTaskHyperlinkDetector;

public class TaskHyperlinkDetector
extends AbstractTaskHyperlinkDetector {
    @Override
    protected List<IHyperlink> detectHyperlinks(ITextViewer textViewer, String content, int index, int contentOffset) {
        ArrayList<IHyperlink> result = new ArrayList<IHyperlink>();
        for (TaskRepository repository : this.getTaskRepositories(textViewer)) {
            IHyperlink[] links = this.detectHyperlinks(repository, content, index, contentOffset);
            if (links == null || links.length <= 0) continue;
            result.addAll(Arrays.asList(links));
        }
        if (result.isEmpty()) {
            return null;
        }
        return result;
    }

    protected IHyperlink[] detectHyperlinks(final TaskRepository repository, final String content, final int index, final int contentOffset) {
        final AbstractRepositoryConnectorUi connectorUi = this.getConnectorUi(repository);
        if (connectorUi == null) {
            return null;
        }
        final IHyperlink[][] links = new IHyperlink[1][];
        SafeRunnable.run((ISafeRunnable)new ISafeRunnable(){

            public void handleException(Throwable exception) {
            }

            public void run() throws Exception {
                ITask task = (ITask)TaskHyperlinkDetector.this.getAdapter(ITask.class);
                links[0] = connectorUi.findHyperlinks(repository, task, content, index, contentOffset);
            }
        });
        return links[0];
    }

    protected AbstractRepositoryConnectorUi getConnectorUi(TaskRepository repository) {
        return TasksUiPlugin.getConnectorUi(repository.getConnectorKind());
    }
}

