/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.ui.editor;

import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.window.ToolTip;
import org.eclipse.mylyn.wikitext.parser.outline.OutlineItem;
import org.eclipse.mylyn.wikitext.ui.editor.AbstractWikiTextSourceEditorOutline;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.model.BaseWorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.part.IShowInSource;
import org.eclipse.ui.part.IShowInTarget;
import org.eclipse.ui.part.ShowInContext;

public class DefaultWikiTextSourceEditorOutline
extends AbstractWikiTextSourceEditorOutline
implements IShowInSource,
IShowInTarget {
    private boolean disableReveal;

    public void createControl(Composite parent) {
        super.createControl(parent);
        TreeViewer viewer = this.getTreeViewer();
        viewer.setUseHashlookup(true);
        viewer.setAutoExpandLevel(-1);
        viewer.setContentProvider((IContentProvider)new BaseWorkbenchContentProvider());
        viewer.setLabelProvider((IBaseLabelProvider)WorkbenchLabelProvider.getDecoratingWorkbenchLabelProvider());
        viewer.setInput(this.getEditor().getAdapter(OutlineItem.class));
        viewer.addOpenListener(event -> this.revealInEditor(event.getSelection()));
        viewer.addPostSelectionChangedListener(event -> this.revealInEditor(event.getSelection()));
        viewer.expandAll();
        this.updateSelectionToMatchEditor();
        new ToolTip(viewer.getControl(), 1, false){

            protected Composite createToolTipContentArea(Event event, Composite parent) {
                Composite comp = new Composite(parent, 0);
                comp.setBackground(parent.getDisplay().getSystemColor(29));
                GridLayout gl = new GridLayout(1, false);
                gl.marginBottom = 2;
                gl.marginTop = 2;
                gl.marginHeight = 0;
                gl.marginWidth = 0;
                gl.marginLeft = 2;
                gl.marginRight = 2;
                gl.verticalSpacing = 1;
                comp.setLayout((Layout)gl);
                Object tipItem = this.getToolTipItem(new Point(event.x, event.y));
                if (tipItem instanceof OutlineItem) {
                    OutlineItem outlineItem = (OutlineItem)tipItem;
                    Label label = new Label(comp, 64);
                    label.setBackground(comp.getBackground());
                    label.setText(outlineItem.getTooltip());
                }
                return comp;
            }

            protected boolean shouldCreateToolTip(Event event) {
                boolean shouldCreate;
                Object eventItem = this.getToolTipItem(new Point(event.x, event.y));
                boolean bl = shouldCreate = eventItem instanceof OutlineItem && super.shouldCreateToolTip(event);
                if (!shouldCreate) {
                    this.hide();
                }
                return shouldCreate;
            }

            protected Object getToolTipItem(Point point) {
                TreeItem item = ((Tree)DefaultWikiTextSourceEditorOutline.this.getTreeViewer().getControl()).getItem(point);
                if (item != null) {
                    return item.getData();
                }
                return null;
            }
        };
        MenuManager manager = new MenuManager("#PopUp");
        manager.setRemoveAllWhenShown(true);
        manager.addMenuListener(this::contextMenuAboutToShow);
        viewer.getTree().setMenu(manager.createContextMenu((Control)viewer.getTree()));
    }

    private void contextMenuAboutToShow(IMenuManager menuManager) {
        menuManager.add((IContributionItem)new Separator("group.undo"));
        menuManager.add((IContributionItem)new GroupMarker("group.save"));
        menuManager.add((IContributionItem)new Separator("group.copy"));
        menuManager.add((IContributionItem)new Separator("group.print"));
        menuManager.add((IContributionItem)new Separator("group.edit"));
        menuManager.add((IContributionItem)new Separator("group.find"));
        menuManager.add((IContributionItem)new Separator("group.add"));
        menuManager.add((IContributionItem)new Separator("group.showIn"));
        menuManager.add((IContributionItem)new Separator("group.reorganize"));
        menuManager.add((IContributionItem)new Separator("group.rest"));
        menuManager.add((IContributionItem)new Separator("additions"));
    }

    private void revealInEditor(ISelection selection) {
        IStructuredSelection structuredSelection;
        Object firstElement;
        if (this.disableReveal) {
            return;
        }
        if (selection instanceof IStructuredSelection && (firstElement = (structuredSelection = (IStructuredSelection)selection).getFirstElement()) instanceof OutlineItem) {
            IShowInTarget target;
            OutlineItem item = (OutlineItem)firstElement;
            if (this.getEditor() != null && (target = (IShowInTarget)this.getEditor().getAdapter(IShowInTarget.class)) != null) {
                target.show(new ShowInContext(null, (ISelection)new StructuredSelection((Object)item)));
            }
        }
    }

    private void refresh() {
        this.getTreeViewer().getTree().setRedraw(false);
        try {
            this.getTreeViewer().refresh();
            this.getTreeViewer().expandAll();
        }
        finally {
            this.getTreeViewer().getTree().setRedraw(true);
        }
    }

    public ShowInContext getShowInContext() {
        IShowInSource source;
        if (this.getEditor() != null && (source = (IShowInSource)this.getEditor().getAdapter(IShowInSource.class)) != null) {
            return source.getShowInContext();
        }
        return null;
    }

    public boolean show(ShowInContext context) {
        IShowInTarget target;
        if (this.getEditor() != null && (target = (IShowInTarget)this.getEditor().getAdapter(IShowInTarget.class)) != null) {
            return target.show(context);
        }
        return false;
    }

    @Override
    protected void editorPropertyChanged(Object source, int propId) {
        super.editorPropertyChanged(source, propId);
        if (this.getControl() != null && !this.getControl().isDisposed()) {
            if (propId == 0x10000001) {
                this.refresh();
                this.getControl().getDisplay().asyncExec(() -> {
                    if (this.getControl() != null && !this.getControl().isDisposed() && this.getEditor() != null) {
                        this.updateSelectionToMatchEditor();
                    }
                });
            } else if (propId == 0x10000002) {
                this.updateSelectionToMatchEditor();
            }
        }
    }

    public void setSelection(ISelection selection) {
        this.disableReveal = true;
        try {
            super.setSelection(selection);
        }
        finally {
            this.disableReveal = false;
        }
    }

    private void updateSelectionToMatchEditor() {
        IStructuredSelection sse;
        Object firstElement;
        ISelection iSelection;
        ShowInContext showInContext;
        if (this.getEditor() == null) {
            return;
        }
        IShowInSource source = (IShowInSource)this.getEditor().getAdapter(IShowInSource.class);
        if (source != null && (showInContext = source.getShowInContext()) != null && (iSelection = showInContext.getSelection()) instanceof IStructuredSelection && (firstElement = (sse = (IStructuredSelection)iSelection).getFirstElement()) instanceof OutlineItem) {
            this.setSelection((ISelection)new StructuredSelection(firstElement));
        }
    }
}

