/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.ds.internal.annotations;

import java.util.Collection;
import java.util.HashSet;
import org.eclipse.pde.ds.internal.annotations.ProjectState;

public class ProjectContext {
    private final ProjectState state;
    private final Collection<String> abandoned = new HashSet<String>();
    private final Collection<String> unprocessed;
    private final ProjectState oldState;

    public ProjectContext(ProjectState state) {
        this.state = state;
        this.unprocessed = new HashSet<String>(state.getCompilationUnits());
        this.oldState = state.clone();
    }

    public boolean isChanged() {
        return !this.oldState.equals(this.state);
    }

    public ProjectState getState() {
        return this.state;
    }

    public Collection<String> getAbandoned() {
        return this.abandoned;
    }

    public Collection<String> getUnprocessed() {
        return this.unprocessed;
    }
}

