/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.common.core.tableviewer;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import org.eclipse.datatools.sqltools.common.core.tableviewer.Messages;

public class DataDeserializer {
    public static Object deserialize(String val, int type) {
        if (val == null) {
            return null;
        }
        if (type == -6) {
            return Byte.valueOf(val);
        }
        if (type == 5) {
            return new Short(val);
        }
        if (type == 4) {
            return Integer.valueOf(val);
        }
        if (type == -5) {
            return Long.valueOf(val);
        }
        if (type == 7) {
            return Float.valueOf(val);
        }
        if (type == 6) {
            return Double.valueOf(val);
        }
        if (type == 8) {
            return Double.valueOf(val);
        }
        if (type == 3) {
            return new BigDecimal(val);
        }
        if (type == 2) {
            return new BigDecimal(val);
        }
        if (type == -7) {
            if ("1".equals(val)) {
                return true;
            }
            if ("0".equals(val)) {
                return false;
            }
            return Boolean.valueOf(val);
        }
        if (type == 1) {
            return val;
        }
        if (type == 12) {
            return val;
        }
        if (type == -1) {
            return val;
        }
        if (type == -2) {
            return DataDeserializer.deserializeBytes(val);
        }
        if (type == -3) {
            return DataDeserializer.deserializeBytes(val);
        }
        if (type == -4) {
            return DataDeserializer.deserializeBytes(val);
        }
        if (type == 91) {
            return Date.valueOf(val);
        }
        if (type == 92) {
            return Time.valueOf(val);
        }
        if (type == 93) {
            return Timestamp.valueOf(val);
        }
        if (type == 2005) {
            return val;
        }
        if (type == 2004) {
            return DataDeserializer.deserializeBytes(val);
        }
        if (type == 2003 || type == 2006 || type == 2002 || type == 2000 || type == 1111) {
            return null;
        }
        return null;
    }

    protected static byte[] deserializeBytes(String s) {
        if (s.startsWith("0x")) {
            s = s.replaceFirst("0x", "");
        }
        if (s.length() % 2 == 1) {
            throw new IllegalArgumentException(Messages.DataDeserializer_invalid_binary_data);
        }
        byte[] bytes = new byte[s.length() / 2];
        int i = 0;
        while (i < bytes.length) {
            bytes[i] = (byte)Integer.parseInt(s.substring(2 * i, 2 * i + 2), 16);
            ++i;
        }
        return bytes;
    }
}

