/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.target;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import org.eclipse.core.internal.runtime.XmlProcessorFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.target.ITargetLocation;
import org.eclipse.pde.core.target.ITargetLocationFactory;
import org.eclipse.pde.internal.core.target.Messages;
import org.eclipse.pde.internal.core.target.TargetReferenceBundleContainer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class TargetRefrenceLocationFactory
implements ITargetLocationFactory {
    @Override
    public ITargetLocation getTargetLocation(String type, String serializedXML) throws CoreException {
        if (!"Target".equals(type)) {
            throw new CoreException(Status.error((String)NLS.bind((String)Messages.TargetRefrenceLocationFactory_Unsupported_Type, (Object)type)));
        }
        try {
            Document document = XmlProcessorFactory.parseWithErrorOnDOCTYPE((InputStream)new ByteArrayInputStream(serializedXML.getBytes(StandardCharsets.UTF_8)));
            Element location = document.getDocumentElement();
            return new TargetReferenceBundleContainer(location.getAttribute("uri"));
        }
        catch (Exception e) {
            throw new CoreException(Status.error((String)NLS.bind((String)Messages.TargetRefrenceLocationFactory_Parsing_Failed, (Object)e.getMessage()), (Throwable)e));
        }
    }
}

