/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.meson.ui;

import java.nio.file.Paths;
import org.eclipse.cdt.core.build.IToolChain;
import org.eclipse.cdt.core.build.IToolChainManager;
import org.eclipse.cdt.internal.meson.ui.Messages;
import org.eclipse.cdt.meson.core.Activator;
import org.eclipse.cdt.meson.core.IMesonToolChainFile;
import org.eclipse.cdt.meson.core.IMesonToolChainManager;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class NewMesonToolChainFilePage
extends WizardPage {
    private Text pathText;
    private Combo tcCombo;
    private IToolChain[] toolchains;

    public NewMesonToolChainFilePage() {
        super("NewMesonToolChainFilePage", Messages.NewMesonToolChainFilePage_Title, null);
    }

    public void createControl(Composite parent) {
        Composite comp = new Composite(parent, 0);
        comp.setLayoutData((Object)new GridData(4, 4, true, true));
        comp.setLayout((Layout)new GridLayout(2, false));
        Label pathLabel = new Label(comp, 0);
        pathLabel.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        pathLabel.setText(Messages.NewMesonToolChainFilePage_Path);
        Composite pathComp = new Composite(comp, 0);
        pathComp.setLayoutData((Object)new GridData(4, 4, true, false));
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        pathComp.setLayout((Layout)layout);
        this.pathText = new Text(pathComp, 2048);
        this.pathText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.pathText.addModifyListener(e -> this.validate());
        Button pathButton = new Button(pathComp, 8);
        pathButton.setLayoutData((Object)new GridData(4, 4, false, false));
        pathButton.setText(Messages.NewMesonToolChainFilePage_Browse);
        pathButton.addListener(13, e -> {
            FileDialog dialog = new FileDialog(this.getShell(), 4096);
            dialog.setText(Messages.NewMesonToolChainFilePage_Select);
            String path = dialog.open();
            if (path != null) {
                this.pathText.setText(path);
            }
        });
        Label tcLabel = new Label(comp, 0);
        tcLabel.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        tcLabel.setText(Messages.NewMesonToolChainFilePage_Toolchain);
        this.tcCombo = new Combo(comp, 8);
        this.tcCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        try {
            IToolChainManager tcManager = (IToolChainManager)Activator.getService(IToolChainManager.class);
            IToolChain[] iToolChainArray = this.toolchains = tcManager.getAllToolChains().toArray(new IToolChain[0]);
            int n = this.toolchains.length;
            int n2 = 0;
            while (n2 < n) {
                IToolChain tc = iToolChainArray[n2];
                this.tcCombo.add(tc.getName());
                ++n2;
            }
            this.tcCombo.select(0);
        }
        catch (CoreException e2) {
            Activator.log((IStatus)e2.getStatus());
        }
        this.setControl((Control)comp);
        this.validate();
    }

    private void validate() {
        this.setPageComplete(false);
        String path = this.pathText.getText();
        if (path.isEmpty()) {
            this.setErrorMessage(Messages.NewMesonToolChainFilePage_NoPath);
            return;
        }
        this.setPageComplete(true);
        this.setErrorMessage(null);
    }

    public IMesonToolChainFile getNewFile() {
        IMesonToolChainManager manager = (IMesonToolChainManager)Activator.getService(IMesonToolChainManager.class);
        IMesonToolChainFile file = manager.newToolChainFile(Paths.get(this.pathText.getText(), new String[0]));
        IToolChain tc = this.toolchains[this.tcCombo.getSelectionIndex()];
        file.setProperty("cdt.toolChain.type", tc.getTypeId());
        file.setProperty("cdt.toolChain.id", tc.getId());
        return file;
    }
}

