/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d;

import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.draw2d.GraphicsSource;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.UpdateListener;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.GC;

public abstract class UpdateManager {
    private final List<UpdateListener> listeners = new CopyOnWriteArrayList<UpdateListener>();
    private boolean disposed;

    public abstract void addDirtyRegion(IFigure var1, int var2, int var3, int var4, int var5);

    public void addDirtyRegion(IFigure figure, Rectangle rect) {
        this.addDirtyRegion(figure, rect.x, rect.y, rect.width, rect.height);
    }

    public void runWithUpdate(Runnable run) {
    }

    public abstract void addInvalidFigure(IFigure var1);

    public void addUpdateListener(UpdateListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException();
        }
        this.listeners.add(listener);
    }

    public void dispose() {
        this.disposed = true;
    }

    protected void firePainting(Rectangle damage, Map<IFigure, Rectangle> dirtyRegions) {
        this.listeners.forEach(localListener -> localListener.notifyPainting(damage, dirtyRegions));
    }

    protected void fireValidating() {
        this.listeners.forEach(UpdateListener::notifyValidating);
    }

    protected boolean isDisposed() {
        return this.disposed;
    }

    public abstract void performUpdate();

    protected void paint(GC gc) {
        this.performUpdate(new Rectangle(gc.getClipping()));
    }

    public abstract void performUpdate(Rectangle var1);

    public void removeUpdateListener(UpdateListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException();
        }
        this.listeners.remove(listener);
    }

    public abstract void setGraphicsSource(GraphicsSource var1);

    public abstract void setRoot(IFigure var1);

    public void performValidation() {
        this.performUpdate();
    }
}

