/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.pde.ui.target.editor.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.stream.Stream;
import org.apache.maven.model.Dependency;
import org.apache.maven.shared.utils.StringUtils;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.Platform;
import org.eclipse.m2e.pde.target.MavenTargetDependency;
import org.eclipse.m2e.pde.target.MavenTargetLocation;
import org.eclipse.m2e.pde.ui.target.editor.ClipboardParser;
import org.eclipse.m2e.pde.ui.target.editor.internal.MavenTargetDependencyListFacade;
import org.eclipse.m2e.pde.ui.target.editor.internal.OperationHistoryFacade;
import org.eclipse.swt.widgets.Display;

public class TargetDependencyModel {
    private static final ILog LOGGER = Platform.getLog(TargetDependencyModel.class);
    private final MavenTargetLocation targetLocation;
    private final MavenTargetDependencyListFacade targetDependencies = new MavenTargetDependencyListFacade();
    private final MavenTargetDependencyListFacade currentSelection = new MavenTargetDependencyListFacade();
    private final OperationHistoryFacade history;
    private final IObservableValue<Boolean> hasErrors = new WritableValue();

    public TargetDependencyModel(MavenTargetLocation targetLocation, MavenTargetDependency selectedRoot) {
        int itemToSelect;
        this.history = new OperationHistoryFacade(this);
        this.targetLocation = targetLocation;
        if (targetLocation == null || targetLocation.getRoots().isEmpty()) {
            itemToSelect = 0;
            this.targetDependencies.set(TargetDependencyModel.getDefaultClipboardDependencies());
        } else {
            itemToSelect = selectedRoot == null ? 0 : targetLocation.getRoots().indexOf(selectedRoot);
            this.targetDependencies.set(TargetDependencyModel.deepClone(targetLocation.getRoots()));
        }
        this.currentSelection.set((MavenTargetDependency)this.targetDependencies.get(itemToSelect));
        this.check();
    }

    public void setCurrentSelection(List<MavenTargetDependency> newCurrentSelection) {
        this.currentSelection.set(newCurrentSelection);
    }

    public List<MavenTargetDependency> getCurrentSelection() {
        return List.copyOf(this.currentSelection);
    }

    public void setTargetDependencies(List<MavenTargetDependency> newTargetDependencies) {
        this.targetDependencies.set(newTargetDependencies);
    }

    public List<MavenTargetDependency> getTargetDependencies() {
        return List.copyOf(new ArrayList(this.targetDependencies));
    }

    public OperationHistoryFacade getHistory() {
        return this.history;
    }

    public void modify(MavenTargetDependency source, BiConsumer<MavenTargetDependency, String> setter, String oldValue, String newValue) {
        if (Objects.equals(oldValue, newValue)) {
            return;
        }
        this.history.propertyChange(value -> this.currentSelection.modify(source, setter, (String)value), oldValue, newValue);
    }

    public void add() {
        List<MavenTargetDependency> newCurrentSelection = TargetDependencyModel.getDefaultClipboardDependencies();
        ArrayList<MavenTargetDependency> newTargetDependencies = new ArrayList<MavenTargetDependency>();
        newTargetDependencies.addAll(TargetDependencyModel.deepClone(this.getTargetDependencies()));
        newTargetDependencies.addAll(newCurrentSelection);
        this.history.modelChange(newTargetDependencies, newCurrentSelection);
    }

    public void remove() {
        if (!this.canRemove()) {
            LOGGER.error("The remove operation is currently not possible! Ignore...");
            return;
        }
        List<MavenTargetDependency> oldCurrentSelection = this.getCurrentSelection();
        List<MavenTargetDependency> oldTargetDependencies = this.getTargetDependencies();
        List<MavenTargetDependency> newCurrentSelection = Collections.emptyList();
        List<MavenTargetDependency> newTargetDependencies = new ArrayList<MavenTargetDependency>(oldTargetDependencies);
        newTargetDependencies.removeAll(oldCurrentSelection);
        newTargetDependencies = TargetDependencyModel.deepClone(newTargetDependencies);
        if (oldCurrentSelection.size() == 1 && !newTargetDependencies.isEmpty()) {
            int index = oldTargetDependencies.indexOf(oldCurrentSelection.get(0));
            if (index >= newTargetDependencies.size()) {
                index = newTargetDependencies.size() - 1;
            }
            MavenTargetDependency itemToSelect = newTargetDependencies.get(index);
            newCurrentSelection = Collections.singletonList(itemToSelect);
        }
        this.history.modelChange(newTargetDependencies, newCurrentSelection);
    }

    public void update() {
        if (!this.canUpdate()) {
            LOGGER.error("The update operation is currently not possible! Ignore...");
            return;
        }
        List<MavenTargetDependency> oldCurrentSelection = this.getCurrentSelection();
        List<MavenTargetDependency> oldTargetDependencies = this.getTargetDependencies();
        ArrayList<MavenTargetDependency> newCurrentSelection = new ArrayList<MavenTargetDependency>();
        ArrayList<MavenTargetDependency> newTargetDependencies = new ArrayList<MavenTargetDependency>(oldTargetDependencies);
        try {
            int updated = 0;
            for (MavenTargetDependency dependency : oldCurrentSelection) {
                int index = oldTargetDependencies.indexOf(dependency);
                MavenTargetDependency newDependency = this.targetLocation.update(dependency, null);
                if (!dependency.matches((Dependency)newDependency)) {
                    ++updated;
                }
                newTargetDependencies.set(index, newDependency);
                newCurrentSelection.add(newDependency);
            }
            if (updated > 0) {
                this.history.modelChange(newTargetDependencies, newCurrentSelection);
            }
        }
        catch (CoreException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    public boolean canRemove() {
        return !this.currentSelection.isEmpty();
    }

    public boolean canUpdate() {
        if (this.targetLocation == null) {
            return false;
        }
        Stream allFields = this.currentSelection.stream().mapMulti((dependency, downStream) -> {
            downStream.accept(dependency.getGroupId());
            downStream.accept(dependency.getArtifactId());
            downStream.accept(dependency.getVersion());
        });
        return allFields.noneMatch(StringUtils::isBlank) && !this.currentSelection.isEmpty();
    }

    public boolean hasErrors() {
        return (Boolean)this.hasErrors.getValue();
    }

    public void setErrors(boolean hasErrors) {
        this.hasErrors.setValue((Object)hasErrors);
    }

    private static List<MavenTargetDependency> getDefaultClipboardDependencies() {
        List<MavenTargetDependency> dependencies = ClipboardParser.getClipboardDependencies(Display.getCurrent());
        if (dependencies.isEmpty()) {
            return List.of(new MavenTargetDependency("", "", "", "", ""));
        }
        return dependencies;
    }

    public void check() {
        Stream allFields = this.targetDependencies.stream().mapMulti((dependency, downStream) -> {
            downStream.accept(dependency.getGroupId());
            downStream.accept(dependency.getArtifactId());
            downStream.accept(dependency.getVersion());
            downStream.accept(dependency.getType());
        });
        this.hasErrors.setValue((Object)allFields.anyMatch(StringUtils::isBlank));
    }

    private static List<MavenTargetDependency> deepClone(List<MavenTargetDependency> dependencies) {
        ArrayList<MavenTargetDependency> copy = new ArrayList<MavenTargetDependency>();
        for (MavenTargetDependency dependency : dependencies) {
            copy.add(dependency.copy());
        }
        return new ArrayList<MavenTargetDependency>(copy);
    }
}

