/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.dom;

import java.util.Objects;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.dom.CompilationUnitResolver;
import org.eclipse.jdt.internal.core.dom.ICompilationUnitResolver;

class CompilationUnitResolverDiscovery {
    private static final String SELECTED_SYSPROP = "ICompilationUnitResolver";
    private static final String COMPILATION_UNIT_RESOLVER_EXTPOINT_ID = "compilationUnitResolver";
    private static boolean ERROR_LOGGED = false;
    private static String lastId;
    private static IConfigurationElement lastExtension;

    CompilationUnitResolverDiscovery() {
    }

    static ICompilationUnitResolver getInstance() {
        block4: {
            String id = System.getProperty(SELECTED_SYSPROP);
            IConfigurationElement configElement = CompilationUnitResolverDiscovery.getConfigurationElement(id);
            lastId = id;
            lastExtension = configElement;
            if (configElement != null) {
                try {
                    Object executableExtension = configElement.createExecutableExtension("class");
                    if (executableExtension instanceof ICompilationUnitResolver) {
                        ICompilationUnitResolver icur = (ICompilationUnitResolver)executableExtension;
                        return icur;
                    }
                }
                catch (CoreException e) {
                    if (CompilationUnitResolverDiscovery.setErrorLogged()) break block4;
                    ILog.get().error("Could not instantiate ICompilationUnitResolver: '" + id + "' with class: " + configElement.getAttribute("class"), (Throwable)e);
                }
            }
        }
        return CompilationUnitResolver.getInstance();
    }

    private static IConfigurationElement getConfigurationElement(String id) {
        if (id == null || id.isBlank()) {
            return null;
        }
        if (lastExtension != null && Objects.equals(id, lastId)) {
            return lastExtension;
        }
        IExtensionPoint extension = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.jdt.core", COMPILATION_UNIT_RESOLVER_EXTPOINT_ID);
        if (extension != null) {
            IExtension[] extensions;
            IExtension[] iExtensionArray = extensions = extension.getExtensions();
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement[] configElements;
                IExtension ext = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = configElements = ext.getConfigurationElements();
                int n3 = configElements.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement configElement = iConfigurationElementArray[n4];
                    String elementId = configElement.getAttribute("id");
                    if (id.equals(elementId) && "resolver".equals(configElement.getName())) {
                        return configElement;
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        return null;
    }

    private static synchronized boolean setErrorLogged() {
        boolean prev = ERROR_LOGGED;
        ERROR_LOGGED = true;
        return prev;
    }
}

