/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtchart.vectorgraphics2d.intermediate.filters;

import java.util.Collections;
import java.util.List;
import org.eclipse.swtchart.vectorgraphics2d.intermediate.CommandSequence;
import org.eclipse.swtchart.vectorgraphics2d.intermediate.commands.Command;
import org.eclipse.swtchart.vectorgraphics2d.intermediate.commands.Group;
import org.eclipse.swtchart.vectorgraphics2d.intermediate.filters.StreamingFilter;

public abstract class GroupingFilter
extends StreamingFilter {
    private Group group;

    public GroupingFilter(CommandSequence stream) {
        super(stream);
    }

    @Override
    public boolean hasNext() {
        return this.group != null || super.hasNext();
    }

    @Override
    public Command<?> next() {
        if (this.group == null) {
            return super.next();
        }
        Group g = this.group;
        this.group = null;
        return g;
    }

    @Override
    protected List<Command<?>> filter(Command<?> command) {
        boolean grouped = this.isGrouped(command);
        if (grouped) {
            if (this.group == null) {
                this.group = new Group();
            }
            this.group.add(command);
            return null;
        }
        return Collections.singletonList(command);
    }

    protected abstract boolean isGrouped(Command<?> var1);
}

