/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtchart.extensions.dialogs;

import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swtchart.Antialias;
import org.eclipse.swtchart.IEnumLabel;
import org.eclipse.swtchart.LineStyle;
import org.eclipse.swtchart.extensions.dialogs.AbstractPointSeriesSettingsDialog;
import org.eclipse.swtchart.extensions.linecharts.ILineSeriesSettings;

public class LineSeriesSettingsDialog
extends AbstractPointSeriesSettingsDialog<ILineSeriesSettings> {
    private AtomicReference<ComboViewer> lineStyleControl = new AtomicReference();
    private AtomicReference<Spinner> lineWidthControl = new AtomicReference();
    private AtomicReference<Text> lineColorControl = new AtomicReference();
    private AtomicReference<ComboViewer> antialiasControl = new AtomicReference();
    private AtomicReference<Button> enableAreaControl = new AtomicReference();
    private AtomicReference<Button> enableStackControl = new AtomicReference();
    private AtomicReference<Button> enableStepControl = new AtomicReference();

    public LineSeriesSettingsDialog(Shell parentShell, ILineSeriesSettings settings) {
        super(parentShell, settings);
    }

    @Override
    protected void createInputSection(Composite parent) {
        super.createInputSection(parent);
        this.createLineStyleSection(parent);
        this.createLineWidthSection(parent);
        this.createLineColorSection(parent);
        this.createAntialiasSection(parent);
        this.createEnableAreaSection(parent);
        this.createEnableStackSection(parent);
        this.createEnableStepSection(parent);
    }

    @Override
    protected void initialize() {
        super.initialize();
        ILineSeriesSettings settings = (ILineSeriesSettings)this.getSettings();
        if (settings != null) {
            this.lineStyleControl.get().setSelection((ISelection)new StructuredSelection((Object)settings.getLineStyle()));
            this.lineWidthControl.get().setSelection(settings.getLineWidth());
            this.lineColorControl.get().setBackground(settings.getLineColor());
            this.antialiasControl.get().setSelection((ISelection)new StructuredSelection((Object)settings.getAntialias()));
            this.enableAreaControl.get().setSelection(settings.isEnableArea());
            this.enableStackControl.get().setSelection(settings.isEnableStack());
            this.enableStepControl.get().setSelection(settings.isEnableStep());
        }
    }

    private void createLineStyleSection(Composite parent) {
        String title = "Line Style";
        this.createSectionLabel(parent, title);
        ComboViewer comboViewer = this.createComboViewer(parent, title, (IEnumLabel[])LineStyle.values(), LineStyle.NONE, this.getGridData(768, 2), object -> {
            ILineSeriesSettings settings = (ILineSeriesSettings)this.getSettings();
            if (settings != null && object instanceof LineStyle) {
                settings.setLineStyle((LineStyle)object);
            }
        });
        this.lineStyleControl.set(comboViewer);
    }

    private void createLineWidthSection(Composite parent) {
        String title = "Line Width";
        this.createSectionLabel(parent, title);
        Spinner spinner = this.createSpinner(parent, title, 1, 50, 1, this.getGridData(768, 2), selection -> {
            ILineSeriesSettings settings = (ILineSeriesSettings)this.getSettings();
            if (settings != null) {
                settings.setLineWidth((int)selection);
            }
        });
        this.lineWidthControl.set(spinner);
    }

    private void createLineColorSection(Composite parent) {
        String title = "Line Color";
        this.createSectionLabel(parent, title);
        Text text = this.createColorChoser(parent, title, this.getGridData(768, 1), color -> {
            ILineSeriesSettings settings = (ILineSeriesSettings)this.getSettings();
            if (settings != null) {
                settings.setLineColor((Color)color);
            }
        });
        this.lineColorControl.set(text);
    }

    private void createAntialiasSection(Composite parent) {
        String title = "Antialias";
        this.createSectionLabel(parent, title);
        ComboViewer comboViewer = this.createComboViewer(parent, title, (IEnumLabel[])Antialias.values(), Antialias.ON, this.getGridData(768, 2), object -> {
            ILineSeriesSettings settings = (ILineSeriesSettings)this.getSettings();
            if (settings != null && object instanceof Antialias) {
                settings.setAntialias(((Antialias)object).value());
            }
        });
        this.antialiasControl.set(comboViewer);
    }

    private void createEnableAreaSection(Composite parent) {
        this.createSectionLabel(parent, "");
        Button button = this.createCheckBox(parent, "Enable Area", "Enable or disable to display the area.", this.getGridData(768, 2), selection -> {
            ILineSeriesSettings settings = (ILineSeriesSettings)this.getSettings();
            if (settings != null) {
                settings.setEnableArea((boolean)selection);
            }
        });
        this.enableAreaControl.set(button);
    }

    private void createEnableStackSection(Composite parent) {
        this.createSectionLabel(parent, "");
        Button button = this.createCheckBox(parent, "Enable Stack", "Enable or disable the stack modus.", this.getGridData(768, 2), selection -> {
            ILineSeriesSettings settings = (ILineSeriesSettings)this.getSettings();
            if (settings != null) {
                settings.setEnableStack((boolean)selection);
            }
        });
        this.enableStackControl.set(button);
    }

    private void createEnableStepSection(Composite parent) {
        this.createSectionLabel(parent, "");
        Button button = this.createCheckBox(parent, "Enable Step", "Enable or disable the step modus.", this.getGridData(768, 2), selection -> {
            ILineSeriesSettings settings = (ILineSeriesSettings)this.getSettings();
            if (settings != null) {
                settings.setEnableStep((boolean)selection);
            }
        });
        this.enableStepControl.set(button);
    }
}

