/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tests.swtbot.support.api.matcher.geometry;

import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.sirius.tests.swtbot.support.api.matcher.geometry.PointAround;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;

public class RectangleAround
extends BaseMatcher<Rectangle> {
    private final int distance;
    private final Rectangle expected;

    protected RectangleAround(Rectangle expected, int distance) {
        this.expected = expected;
        this.distance = distance;
    }

    public boolean matches(Object item) {
        boolean result = false;
        if (item instanceof Rectangle) {
            Rectangle other = (Rectangle)item;
            result = other.height == this.expected.height;
            result = result && other.width == this.expected.width;
            result = result && PointAround.isAround(this.expected.getTopLeft(), other.getTopLeft(), this.distance);
        }
        return result;
    }

    public void describeTo(Description description) {
        description.appendText("A rectangle around ");
        description.appendValue((Object)this.expected);
        description.appendText("and whom distance from this rectangle is less or equal to " + this.distance);
    }

    public static Matcher<Rectangle> around(Rectangle expected, int distance) {
        return new RectangleAround(expected, distance);
    }
}

