/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.policy;

import com.google.common.base.Preconditions;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.requests.AlignmentRequest;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.CommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.emf.commands.core.command.CompositeTransactionalCommand;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.diagram.DNode;
import org.eclipse.sirius.diagram.sequence.SequenceDDiagram;
import org.eclipse.sirius.diagram.sequence.business.api.util.Range;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.EndOfLife;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.ISequenceElementAccessor;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.Lifeline;
import org.eclipse.sirius.diagram.sequence.ordering.CompoundEventEnd;
import org.eclipse.sirius.diagram.sequence.ordering.EventEnd;
import org.eclipse.sirius.diagram.sequence.ordering.SingleEventEnd;
import org.eclipse.sirius.diagram.sequence.ui.Messages;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.operation.EndOfLifeOperations;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.operation.SequenceEditPartsOperations;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.operation.ShiftDescendantMessagesOperation;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.part.EndOfLifeEditPart;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.part.ISequenceEventEditPart;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.part.LifelineEditPart;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.part.SequenceDiagramEditPart;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.layout.SequenceGraphicalHelper;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.util.EditPartsHelper;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.util.SequenceDiagramEPQuery;
import org.eclipse.sirius.diagram.ui.business.internal.operation.AbstractModelChangeOperation;
import org.eclipse.sirius.diagram.ui.business.internal.query.DNodeQuery;
import org.eclipse.sirius.diagram.ui.graphical.edit.policies.SpecificBorderItemSelectionEditPolicy;
import org.eclipse.sirius.diagram.ui.tools.internal.edit.command.CommandFactory;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.gmf.runtime.editparts.GraphicalHelper;

public class EndOfLifeSelectionPolicy
extends SpecificBorderItemSelectionEditPolicy {
    public void setHost(EditPart host) {
        Preconditions.checkArgument((boolean)(host instanceof EndOfLifeEditPart));
        super.setHost(host);
    }

    protected EndOfLifeEditPart getEOL() {
        return (EndOfLifeEditPart)this.getHost();
    }

    protected Command getAlignCommand(AlignmentRequest request) {
        return UnexecutableCommand.INSTANCE;
    }

    protected Command getMoveCommand(ChangeBoundsRequest request) {
        ChangeBoundsRequest cbr;
        UnexecutableCommand result = UnexecutableCommand.INSTANCE;
        this.constrainMoveVertically((Request)request);
        if (this.canResizeLifeline(this.getEOL(), request) && (cbr = EndOfLifeOperations.getLifelineResizeRequest((Request)request, this.getEOL(), (IGraphicalEditPart)this.getEOL())) != null) {
            result = this.getLifelineMovesCommand(this.getEOL(), cbr);
        }
        return result;
    }

    public void showSourceFeedback(Request request) {
        this.constrainMoveVertically(request);
        super.showSourceFeedback(request);
        if (request instanceof ChangeBoundsRequest && this.canResizeLifeline(this.getEOL(), (ChangeBoundsRequest)request)) {
            EndOfLifeOperations.showEndOfLifeFeedback(request, this.getEOL(), (IGraphicalEditPart)this.getEOL());
        }
    }

    public void eraseSourceFeedback(Request request) {
        this.constrainMoveVertically(request);
        super.eraseSourceFeedback(request);
        EndOfLifeOperations.eraseEndOfLifeFeedback((LifelineEditPart)this.getEOL().getParent(), request);
    }

    private void constrainMoveVertically(Request request) {
        if (request instanceof ChangeBoundsRequest) {
            ChangeBoundsRequest cbr = (ChangeBoundsRequest)request;
            cbr.setMoveDelta(new Point(0, cbr.getMoveDelta().y));
        }
    }

    private Command getLifelineMovesCommand(EndOfLifeEditPart self, ChangeBoundsRequest cbr) {
        boolean destroyed;
        CompositeTransactionalCommand ctc = new CompositeTransactionalCommand(self.getEditingDomain(), Messages.EndOfLifeSelectionPolicy_lifelineMoveCommand);
        Option endOfLife = ISequenceElementAccessor.getEndOfLife((View)self.getNotationView());
        LifelineEditPart lep = self.getLifelineEditPart();
        boolean bl = destroyed = endOfLife.some() && ((EndOfLife)endOfLife.get()).isExplicitelyDestroyed();
        if (lep != null) {
            if (destroyed) {
                this.addLifelineResizeCommand(self, cbr, ctc, lep);
            } else {
                SequenceDiagramEditPart diagram = EditPartsHelper.getSequenceDiagramPart((IGraphicalEditPart)self);
                for (LifelineEditPart lifeline : new SequenceDiagramEPQuery(diagram).getAllLifelines()) {
                    if (((Lifeline)lifeline.getISequenceEvent()).isExplicitlyDestroyed()) continue;
                    this.addLifelineResizeCommand(self, cbr, ctc, lifeline);
                }
            }
        }
        ICommandProxy iCommandProxy = new ICommandProxy((ICommand)ctc);
        iCommandProxy.setLabel(ctc.getLabel());
        return iCommandProxy;
    }

    private void addLifelineResizeCommand(EndOfLifeEditPart self, ChangeBoundsRequest cbr, CompositeTransactionalCommand ctc, LifelineEditPart lep) {
        cbr.setEditParts((EditPart)lep);
        ctc.compose((IUndoableOperation)new CommandProxy(lep.getCommand((Request)cbr)));
        Dimension sizeDelta = cbr.getSizeDelta().getCopy();
        GraphicalHelper.screen2logical((Dimension)sizeDelta, (IGraphicalEditPart)this.getEOL());
        TransactionalEditingDomain domain = this.getEOL().getEditingDomain();
        ctc.compose((IUndoableOperation)CommandFactory.createICommand((TransactionalEditingDomain)domain, (AbstractModelChangeOperation)new ShiftDescendantMessagesOperation(lep.getISequenceEvent(), sizeDelta.height, true, false, false)));
    }

    private boolean canResizeLifeline(EndOfLifeEditPart self, ChangeBoundsRequest request) {
        Option endOfLife = ISequenceElementAccessor.getEndOfLife((View)self.getNotationView());
        boolean destroyed = endOfLife.some() && ((EndOfLife)endOfLife.get()).isExplicitelyDestroyed();
        boolean result = !destroyed || request.isConstrainedMove();
        LifelineEditPart lep = self.getLifelineEditPart();
        if (result && lep != null && ("drop".equals(request.getType()) || "move".equals(request.getType()))) {
            Range range = lep.getISequenceEvent().getVerticalRange();
            int moveDeltaY = request.getMoveDelta().y;
            int rangeLimit = this.getRangeLimit(self, lep, range, moveDeltaY, destroyed);
            result = range.getUpperBound() + moveDeltaY >= rangeLimit;
        } else {
            result = false;
        }
        return result;
    }

    private int getRangeLimit(EndOfLifeEditPart self, LifelineEditPart lep, Range range, int moveDeltaY, boolean isDestroyed) {
        SequenceDiagramEditPart sdep = EditPartsHelper.getSequenceDiagramPart((IGraphicalEditPart)self);
        int rangeLimit = range.getLowerBound() + 5;
        if (!isDestroyed) {
            View lifelineView = (View)lep.getModel();
            Lifeline lifeline = (Lifeline)ISequenceElementAccessor.getLifeline((View)lifelineView).get();
            DNode dNode = (DNode)lifelineView.getElement();
            rangeLimit = Math.max(rangeLimit, new DNodeQuery((DNode)dNode).getDefaultDimension().height + lifeline.getVerticalRange().getLowerBound());
            EventEnd lastEnd = SequenceGraphicalHelper.getEndBefore((SequenceDDiagram)sdep.resolveSemanticElement(), range.getUpperBound());
            if (moveDeltaY < 0 && lastEnd != null) {
                SingleEventEnd see = lastEnd instanceof SingleEventEnd ? (SingleEventEnd)lastEnd : (SingleEventEnd)((CompoundEventEnd)lastEnd).getEventEnds().iterator().next();
                ISequenceEventEditPart ise = EditPartsHelper.findISequenceEvent(see, sdep);
                rangeLimit = Math.max(rangeLimit, SequenceEditPartsOperations.getVerticalRange(ise).getUpperBound() + 5);
            }
        } else {
            rangeLimit = Math.max(lep.getISequenceEvent().getOccupiedRange().getUpperBound() + 5, rangeLimit);
        }
        return rangeLimit;
    }
}

