/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.sample.interactions.services;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Stack;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.sirius.business.api.query.EObjectQuery;
import org.eclipse.sirius.diagram.sequence.ordering.EventEnd;
import org.eclipse.sirius.sample.interactions.AbstractEnd;
import org.eclipse.sirius.sample.interactions.CallMessage;
import org.eclipse.sirius.sample.interactions.CombinedFragment;
import org.eclipse.sirius.sample.interactions.CombinedFragmentEnd;
import org.eclipse.sirius.sample.interactions.DestroyParticipantMessage;
import org.eclipse.sirius.sample.interactions.Execution;
import org.eclipse.sirius.sample.interactions.ExecutionEnd;
import org.eclipse.sirius.sample.interactions.Interaction;
import org.eclipse.sirius.sample.interactions.InteractionUse;
import org.eclipse.sirius.sample.interactions.InteractionUseEnd;
import org.eclipse.sirius.sample.interactions.InteractionsPackage;
import org.eclipse.sirius.sample.interactions.Message;
import org.eclipse.sirius.sample.interactions.MessageEnd;
import org.eclipse.sirius.sample.interactions.MixEnd;
import org.eclipse.sirius.sample.interactions.Operand;
import org.eclipse.sirius.sample.interactions.OperandEnd;
import org.eclipse.sirius.sample.interactions.Participant;
import org.eclipse.sirius.sample.interactions.ReturnMessage;
import org.eclipse.sirius.sample.interactions.State;
import org.eclipse.sirius.sample.interactions.StateEnd;

public class InteractionOrderingServices {
    public Collection<EObject> computeSemanticElements(Execution exec) {
        return new LinkedHashSet<EObject>(Arrays.asList(exec, exec.getStart(), exec.getEnd(), this.currentParticipant((EObject)exec)));
    }

    public Collection<EObject> computeSemanticElements(State state) {
        return new LinkedHashSet<EObject>(Arrays.asList(state, state.getStart(), state.getEnd(), this.currentParticipant((EObject)state)));
    }

    public boolean eolPrecondition(Participant p) {
        Interaction i = (Interaction)new EObjectQuery((EObject)p).getFirstAncestorOfType(InteractionsPackage.Literals.INTERACTION).get();
        return i.getMessages().stream().filter(DestroyParticipantMessage.class::isInstance).anyMatch(msg -> msg.getReceivingEnd() != null && msg.getReceivingEnd().getContext() == p);
    }

    public boolean redimEolPrecondition(Participant p) {
        return !this.eolPrecondition(p);
    }

    public Collection<EObject> lostMessageEndSemanticCandidates(Interaction i) {
        ArrayList<EObject> result = new ArrayList<EObject>();
        for (Message msg : i.getMessages()) {
            if ((msg.getSendingEnd() != null || msg.getReceivingEnd() == null) && (msg.getSendingEnd() == null || msg.getReceivingEnd() != null)) continue;
            result.add((EObject)msg);
        }
        return result;
    }

    public EObject startingEnd(EObject self) {
        if (self instanceof Message) {
            return ((Message)self).getSendingEnd();
        }
        if (self instanceof Execution) {
            return ((Execution)self).getStart();
        }
        if (self instanceof State) {
            return ((State)self).getStart();
        }
        if (self instanceof InteractionUse) {
            return ((InteractionUse)self).getStart();
        }
        if (self instanceof CombinedFragment) {
            return ((CombinedFragment)self).getStart();
        }
        if (self instanceof Operand) {
            return ((Operand)self).getStart();
        }
        return null;
    }

    public EObject finishingEnd(EObject self) {
        if (self instanceof Message) {
            return ((Message)self).getReceivingEnd();
        }
        if (self instanceof Execution) {
            return ((Execution)self).getEnd();
        }
        if (self instanceof State) {
            return ((State)self).getEnd();
        }
        if (self instanceof InteractionUse) {
            return ((InteractionUse)self).getFinish();
        }
        if (self instanceof CombinedFragment) {
            return ((CombinedFragment)self).getFinish();
        }
        return null;
    }

    public EObject ownerEvent(EObject self) {
        if (self instanceof AbstractEnd) {
            return null;
        }
        if (self instanceof MixEnd) {
            return ((MixEnd)self).getExecution();
        }
        if (self instanceof MessageEnd) {
            return ((MessageEnd)self).getMessage();
        }
        if (self instanceof ExecutionEnd) {
            return ((ExecutionEnd)self).getExecution();
        }
        if (self instanceof StateEnd) {
            return ((StateEnd)self).getState();
        }
        return null;
    }

    public Participant currentParticipant(EObject self) {
        if (self instanceof Participant) {
            return (Participant)self;
        }
        if (self instanceof AbstractEnd) {
            return ((AbstractEnd)self).getContext();
        }
        if (self instanceof Execution) {
            return ((Execution)self).getOwner();
        }
        if (self instanceof State) {
            return ((State)self).getOwner();
        }
        return null;
    }

    public Collection<EObject> getDirectEventsOnCurrentParticipant(EObject self) {
        return this.getDirectEventsOn(this.currentParticipant(self), self);
    }

    public Collection<EObject> getDirectEventsOn(Participant context, EObject parent) {
        List<EventContext> structure = this.computeContainmentStructure(context);
        LinkedHashSet<EObject> events = new LinkedHashSet<EObject>();
        for (EventContext ec : structure) {
            if (!ec.getParent().equals(parent)) continue;
            events.add(ec.getElement());
        }
        LinkedHashSet<EObject> result = new LinkedHashSet<EObject>();
        for (EObject event : events) {
            if (event == parent) continue;
            result.add(event);
        }
        return result;
    }

    public AbstractEnd getFinishingEnd(Operand operand) {
        CombinedFragmentEnd result = null;
        EObject eContainer = operand.eContainer();
        if (eContainer instanceof CombinedFragment) {
            CombinedFragment cf = (CombinedFragment)eContainer;
            result = cf.getFinish();
            Operand prev = null;
            for (Operand op : cf.getOwnedOperands()) {
                if (operand.equals(prev)) {
                    result = op.getStart();
                    break;
                }
                prev = op;
            }
        }
        return result;
    }

    public EObject getSendingContext(Message msg) {
        MessageEnd sendingEnd = msg.getSendingEnd();
        if (sendingEnd != null) {
            Participant p = sendingEnd.getContext();
            if (p != null) {
                List<EventContext> structure = this.computeContainmentStructure(p);
                for (EventContext ec : structure) {
                    if (!ec.getElement().equals(msg) || !ec.isStart()) continue;
                    EObject parent = ec.getParent();
                    if (parent != null) {
                        return parent;
                    }
                    return p;
                }
            } else if (sendingEnd.getGate() != null) {
                return sendingEnd.getGate();
            }
        }
        return msg;
    }

    public EObject getReceivingContext(Message msg) {
        MessageEnd receivingEnd = msg.getReceivingEnd();
        if (receivingEnd != null) {
            Participant p = receivingEnd.getContext();
            if (p != null) {
                List<EventContext> structure = this.computeContainmentStructure(p);
                for (EventContext ec : structure) {
                    if (!ec.getElement().equals(msg) || ec.isStart()) continue;
                    EObject parent = ec.getParent();
                    if (parent != null) {
                        return parent;
                    }
                    return p;
                }
            } else if (receivingEnd.getGate() != null) {
                return receivingEnd.getGate();
            }
        }
        return msg;
    }

    public Collection<EObject> getMessageAssociatedElements(Message msg) {
        LinkedHashSet<EObject> messageAssociatedElements = new LinkedHashSet<EObject>();
        messageAssociatedElements.add((EObject)msg);
        messageAssociatedElements.add((EObject)msg.getSendingEnd());
        messageAssociatedElements.add((EObject)msg.getReceivingEnd());
        messageAssociatedElements.add(this.getSendingContext(msg));
        messageAssociatedElements.add(this.getReceivingContext(msg));
        return messageAssociatedElements;
    }

    public EObject deleteCombinedFragment(CombinedFragment cf) {
        EObject result = cf.eContainer();
        this.delete((Interaction)cf.eContainer(), (AbstractEnd)cf.getStart(), (AbstractEnd)cf.getFinish(), true, (EList<Participant>)cf.getCoveredParticipants());
        return result;
    }

    public EObject deleteOperand(Operand oper) {
        EObject result = oper.eContainer();
        if (result instanceof CombinedFragment) {
            CombinedFragment cf = (CombinedFragment)result;
            OperandEnd startingEnd = oper.getStart();
            Object finishingEnd = null;
            EList siblings = cf.getOwnedOperands();
            if (siblings.size() == 1) {
                return result;
            }
            int index = siblings.indexOf((Object)oper);
            assert (index != -1) : "inconsistent model";
            finishingEnd = index == siblings.size() - 1 ? cf.getFinish() : ((Operand)siblings.get(index + 1)).getStart();
            this.delete((Interaction)cf.eContainer(), (AbstractEnd)startingEnd, (AbstractEnd)finishingEnd, false, (EList<Participant>)cf.getCoveredParticipants());
        }
        return result;
    }

    public void delete(Interaction inter, AbstractEnd startingEnd, AbstractEnd finishingEnd, boolean deleteFinishingEnd, EList<Participant> coverage) {
        HashSet<Object> toDelete = new HashSet<Object>();
        boolean inside = false;
        for (AbstractEnd abstractEnd : inter.getEnds()) {
            EObject ownerEvent = this.getOwnerEvent(abstractEnd);
            if (abstractEnd == startingEnd) {
                toDelete.add(abstractEnd);
                toDelete.add(ownerEvent);
                inside = true;
                continue;
            }
            if (abstractEnd == finishingEnd) {
                if (!deleteFinishingEnd) break;
                toDelete.add(abstractEnd);
                toDelete.add(ownerEvent);
                break;
            }
            if (!inside || !this.covers(abstractEnd, (Collection<Participant>)coverage)) continue;
            toDelete.add(abstractEnd);
            toDelete.add(ownerEvent);
        }
        for (EObject eObject : toDelete) {
            EcoreUtil.delete((EObject)eObject);
        }
    }

    public EObject getOwnerEvent(AbstractEnd end) {
        if (end instanceof ExecutionEnd) {
            return ((ExecutionEnd)end).getExecution();
        }
        if (end instanceof StateEnd) {
            return ((StateEnd)end).getState();
        }
        if (end instanceof MessageEnd) {
            return ((MessageEnd)end).getMessage();
        }
        if (end instanceof CombinedFragmentEnd) {
            return ((CombinedFragmentEnd)end).getOwner();
        }
        if (end instanceof InteractionUseEnd) {
            return ((InteractionUseEnd)end).getOwner();
        }
        if (end instanceof OperandEnd) {
            return ((OperandEnd)end).getOwner();
        }
        assert (false) : "unhandled kind of AbstractEnd";
        return null;
    }

    public boolean covers(AbstractEnd end, Collection<Participant> participants) {
        if (end instanceof ExecutionEnd) {
            return participants.contains(((ExecutionEnd)end).getContext());
        }
        if (end instanceof MessageEnd) {
            return participants.contains(((MessageEnd)end).getContext());
        }
        if (end instanceof CombinedFragmentEnd) {
            HashSet covered = new HashSet(((CombinedFragmentEnd)end).getOwner().getCoveredParticipants());
            covered.retainAll(participants);
            return !covered.isEmpty();
        }
        if (end instanceof InteractionUseEnd) {
            HashSet covered = new HashSet(((InteractionUseEnd)end).getOwner().getCoveredParticipants());
            covered.retainAll(participants);
            return !covered.isEmpty();
        }
        if (end instanceof OperandEnd) {
            HashSet covered = new HashSet(((CombinedFragment)((OperandEnd)end).getOwner().eContainer()).getCoveredParticipants());
            covered.retainAll(participants);
            return !covered.isEmpty();
        }
        assert (false) : "unhandled kind of AbstractEnd";
        return false;
    }

    public List<EventContext> computeContainmentStructure(Participant owner) {
        if (owner == null || !(owner.eContainer() instanceof Interaction)) {
            return Collections.emptyList();
        }
        Interaction interaction = (Interaction)owner.eContainer();
        Stack<Object> ancestors = new Stack<Object>();
        ancestors.push(owner);
        ArrayList<EventContext> result = new ArrayList<EventContext>();
        for (AbstractEnd end : interaction.getEnds()) {
            MessageEnd msgEnd;
            Message msg;
            ExecutionEnd execEnd;
            if (end.getContext() != owner) continue;
            if (this.isStartingExecutionEnd(end)) {
                execEnd = (ExecutionEnd)end;
                result.add(new EventContext((EObject)ancestors.peek(), (EObject)execEnd.getExecution(), true, ancestors.size() + 1));
                ancestors.push(execEnd.getExecution());
            }
            if (this.isStartingStateEnd(end)) {
                execEnd = (StateEnd)end;
                result.add(new EventContext((EObject)ancestors.peek(), (EObject)execEnd.getState(), true, ancestors.size() + 1));
                ancestors.push(execEnd.getState());
            }
            if (end instanceof MessageEnd && (msg = (msgEnd = (MessageEnd)end).getMessage()) != null) {
                result.add(new EventContext((EObject)ancestors.peek(), (EObject)msgEnd.getMessage(), msgEnd.equals(msg.getSendingEnd()), ancestors.size()));
            }
            if (this.isFinishingExecutionEnd(end)) {
                execEnd = (ExecutionEnd)end;
                ancestors.pop();
                result.add(new EventContext((EObject)ancestors.peek(), (EObject)execEnd.getExecution(), false, ancestors.size() + 1));
            }
            if (!this.isFinishingStateEnd(end)) continue;
            execEnd = (StateEnd)end;
            ancestors.pop();
            result.add(new EventContext((EObject)ancestors.peek(), (EObject)execEnd.getState(), false, ancestors.size() + 1));
        }
        return result;
    }

    public boolean isStartingExecutionEnd(AbstractEnd end) {
        if (end instanceof ExecutionEnd) {
            ExecutionEnd ee = (ExecutionEnd)end;
            return ee.getExecution() != null && ee.getExecution().getStart() == end;
        }
        return false;
    }

    public boolean isFinishingExecutionEnd(AbstractEnd end) {
        if (end instanceof ExecutionEnd) {
            ExecutionEnd ee = (ExecutionEnd)end;
            return ee.getExecution() != null && ee.getExecution().getEnd() == end;
        }
        return false;
    }

    public boolean isStartingStateEnd(AbstractEnd end) {
        if (end instanceof StateEnd) {
            StateEnd ee = (StateEnd)end;
            return ee.getState() != null && ee.getState().getStart() == end;
        }
        return false;
    }

    public boolean isFinishingStateEnd(AbstractEnd end) {
        if (end instanceof StateEnd) {
            StateEnd ee = (StateEnd)end;
            return ee.getState() != null && ee.getState().getEnd() == end;
        }
        return false;
    }

    public int computeCombinedFragmentDepth(EObject eobject) {
        int combinedFragmentDepth = 0;
        if (eobject instanceof CombinedFragment) {
            CombinedFragment currentCombinedFragment = (CombinedFragment)eobject;
            EList coveredParticipants = currentCombinedFragment.getCoveredParticipants();
            CombinedFragmentEnd start = currentCombinedFragment.getStart();
            EObject eContainer = start.eContainer();
            EList eContents = eContainer.eContents();
            int startIndex = eContents.lastIndexOf((Object)start);
            List contents = eContents.subList(0, startIndex);
            for (EObject obj : contents) {
                if (!(obj instanceof CombinedFragmentEnd)) continue;
                CombinedFragmentEnd combinedFragmentEnd = (CombinedFragmentEnd)obj;
                CombinedFragment combinedFragment = combinedFragmentEnd.getOwner();
                if (!this.covers((AbstractEnd)combinedFragmentEnd, (Collection<Participant>)coveredParticipants)) continue;
                if (combinedFragment.getStart().equals(combinedFragmentEnd)) {
                    ++combinedFragmentDepth;
                    continue;
                }
                if (!combinedFragment.getFinish().equals(combinedFragmentEnd)) continue;
                --combinedFragmentDepth;
            }
        }
        return this.getModuloDepth(combinedFragmentDepth, 5);
    }

    private int getModuloDepth(int absoluteDepth, int nbOfColors) {
        int mod = absoluteDepth % nbOfColors;
        int qot = absoluteDepth / nbOfColors;
        if (qot % 2 != 0) {
            mod = nbOfColors - mod;
        }
        return mod;
    }

    public int computeExecutionDepth(EObject eobject) {
        int executionDepth = 0;
        if (eobject instanceof Execution) {
            Execution currentExecution = (Execution)eobject;
            Participant currentLifeline = currentExecution.getOwner();
            ExecutionEnd start = currentExecution.getStart();
            EObject eContainer = start.eContainer();
            EList eContents = eContainer.eContents();
            int startIndex = eContents.lastIndexOf((Object)start);
            List contents = eContents.subList(0, startIndex);
            for (EObject obj : contents) {
                if (!(obj instanceof ExecutionEnd)) continue;
                ExecutionEnd executionEnd = (ExecutionEnd)obj;
                Execution execution = executionEnd.getExecution();
                if (currentLifeline == null || execution == null || !currentLifeline.equals(execution.getOwner())) continue;
                if (execution.getStart().equals(executionEnd)) {
                    ++executionDepth;
                    continue;
                }
                if (!execution.getEnd().equals(executionEnd)) continue;
                --executionDepth;
            }
        }
        return this.getModuloDepth(executionDepth, 10);
    }

    public boolean canCreate(Participant participant, EObject endBefore) {
        boolean result = false;
        if (participant != null && participant.eContainer() instanceof Interaction) {
            result = true;
            AbstractEnd semanticEndBefore = this.getSemanticEnd(endBefore);
            if (semanticEndBefore != null) {
                for (AbstractEnd end : ((Interaction)participant.eContainer()).getEnds()) {
                    boolean bl = result = participant != end.getContext();
                    if (!result || end == semanticEndBefore) break;
                }
            }
        }
        return result;
    }

    public boolean canDestroy(Participant participant, EObject endBefore) {
        boolean result = false;
        if (participant != null && participant.eContainer() instanceof Interaction) {
            result = true;
            AbstractEnd semanticEndBefore = this.getSemanticEnd(endBefore);
            ArrayList ends = new ArrayList(((Interaction)participant.eContainer()).getEnds());
            Collections.reverse(ends);
            for (AbstractEnd end : ends) {
                if (end != semanticEndBefore) {
                    boolean bl = result = participant != end.getContext();
                }
                if (!result || end == semanticEndBefore) break;
            }
        }
        return result;
    }

    private AbstractEnd getSemanticEnd(EObject endBefore) {
        if (endBefore instanceof EventEnd && ((EventEnd)endBefore).getSemanticEnd() instanceof AbstractEnd) {
            return (AbstractEnd)((EventEnd)endBefore).getSemanticEnd();
        }
        return null;
    }

    public boolean isValidSourceForConstraintCreation(EObject source) {
        boolean isValid = true;
        if (source instanceof CallMessage) {
            CallMessage msg = (CallMessage)source;
            isValid = msg.getReceivingEnd() instanceof MixEnd && msg.getSendingEnd().getContext() != msg.getReceivingEnd().getContext();
        } else if (source instanceof ReturnMessage) {
            ReturnMessage msg = (ReturnMessage)source;
            isValid = msg.getSendingEnd() instanceof MixEnd && msg.getSendingEnd().getContext() != msg.getReceivingEnd().getContext();
        }
        return isValid;
    }

    public boolean isValidTargetForConstraintCreation(EObject target) {
        boolean isValid = true;
        if (target instanceof CallMessage) {
            CallMessage msg = (CallMessage)target;
            isValid = msg.getReceivingEnd() instanceof MixEnd && msg.getSendingEnd().getContext() != msg.getReceivingEnd().getContext();
        } else if (target instanceof ReturnMessage) {
            ReturnMessage msg = (ReturnMessage)target;
            isValid = msg.getSendingEnd() instanceof MixEnd && msg.getSendingEnd().getContext() != msg.getReceivingEnd().getContext();
        }
        return isValid;
    }

    private static final class EventContext {
        private final EObject parent;
        private final boolean start;
        private final EObject element;
        private final int level;

        public EventContext(EObject parent, EObject element, boolean start, int level) {
            this.parent = parent;
            this.element = element;
            this.level = level;
            this.start = start;
        }

        public boolean isStart() {
            return this.start;
        }

        public EObject getParent() {
            return this.parent;
        }

        public EObject getElement() {
            return this.element;
        }

        public int getLevel() {
            return this.level;
        }

        public String toString() {
            return String.format("%02d\t%s\t%s", this.getLevel(), this.element, this.parent);
        }
    }
}

