/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.feature.table.internal;

import com.google.common.base.Strings;
import jakarta.inject.Inject;
import java.lang.invoke.LambdaMetafactory;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.stream.StreamSupport;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.core.services.nls.Translation;
import org.eclipse.e4.ui.model.application.MApplicationElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.set.basis.IModelSession;
import org.eclipse.set.basis.MissingSupplier;
import org.eclipse.set.basis.cache.Cache;
import org.eclipse.set.basis.constants.TableType;
import org.eclipse.set.basis.constants.ToolboxViewState;
import org.eclipse.set.basis.extensions.MApplicationElementExtensions;
import org.eclipse.set.basis.graph.AbstractDirectedEdgePath;
import org.eclipse.set.basis.graph.Digraphs;
import org.eclipse.set.basis.part.PartDescription;
import org.eclipse.set.basis.threads.Threads;
import org.eclipse.set.core.services.Services;
import org.eclipse.set.core.services.cache.CacheService;
import org.eclipse.set.core.services.dialog.DialogService;
import org.eclipse.set.core.services.part.ToolboxPartService;
import org.eclipse.set.feature.table.PlanPro2TableTransformationService;
import org.eclipse.set.feature.table.internal.EdgeToPointsCacheProxy;
import org.eclipse.set.feature.table.internal.TableServiceContextFunction;
import org.eclipse.set.feature.table.messages.Messages;
import org.eclipse.set.model.planpro.Ansteuerung_Element.Stell_Bereich;
import org.eclipse.set.model.tablemodel.ColumnDescriptor;
import org.eclipse.set.model.tablemodel.RowGroup;
import org.eclipse.set.model.tablemodel.Table;
import org.eclipse.set.model.tablemodel.TableCell;
import org.eclipse.set.model.tablemodel.TableRow;
import org.eclipse.set.model.tablemodel.TablemodelFactory;
import org.eclipse.set.model.tablemodel.extensions.TableCellExtensions;
import org.eclipse.set.model.tablemodel.extensions.TableExtensions;
import org.eclipse.set.model.tablemodel.extensions.TableRowExtensions;
import org.eclipse.set.ppmodel.extensions.ContainerExtensions;
import org.eclipse.set.ppmodel.extensions.StellBereichExtensions;
import org.eclipse.set.ppmodel.extensions.container.MultiContainer_AttributeGroup;
import org.eclipse.set.ppmodel.extensions.utils.TableNameInfo;
import org.eclipse.set.services.table.TableDiffService;
import org.eclipse.set.services.table.TableService;
import org.eclipse.set.utils.BasePart;
import org.eclipse.set.utils.ToolboxConfiguration;
import org.eclipse.set.utils.table.TableError;
import org.eclipse.set.utils.table.TableInfo;
import org.eclipse.swt.widgets.Display;
import org.eclipse.xtext.xbase.lib.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TableServiceImpl
implements TableService {
    static final Logger logger = LoggerFactory.getLogger(TableService.class);
    @Inject
    private TableDiffService diffService;
    @Inject
    private IEventBroker broker;
    @Inject
    CacheService cacheService;
    @Inject
    @Translation
    Messages messages;
    @Inject
    ToolboxPartService partService;
    @Inject
    DialogService dialogService;
    private final Map<TableInfo, PlanPro2TableTransformationService> modelServiceMap = new ConcurrentHashMap<TableInfo, PlanPro2TableTransformationService>();
    private static final Queue<Pair<BasePart, Runnable>> transformTableThreads = new LinkedList<Pair<BasePart, Runnable>>();
    private static final String EMPTY = "empty";
    private static final String IGNORED_PLANNING_AREA_CACHE_KEY = "ignoredPlanningArea";

    private CacheService getCache() {
        return ToolboxConfiguration.isDebugMode() ? Services.getNoCacheService() : this.cacheService;
    }

    void addModelService(PlanPro2TableTransformationService service, Map<String, Object> properties) throws IllegalAccessException {
        TableInfo tableInfo = TableServiceContextFunction.getTableInfo(properties);
        this.modelServiceMap.put(tableInfo, service);
    }

    void addModelServiceByInfo(TableInfo tableInfo, PlanPro2TableTransformationService service) {
        this.modelServiceMap.put(tableInfo, service);
    }

    private Table createDiffTable(String elementId, IModelSession modelSession, String controlAreaId) {
        Table startTable = this.transformToTable(elementId, TableType.INITIAL, modelSession, controlAreaId == null ? Collections.emptySet() : Set.of(controlAreaId));
        Table zielTable = this.transformToTable(elementId, TableType.FINAL, modelSession, controlAreaId == null ? Collections.emptySet() : Set.of(controlAreaId));
        if (zielTable == null || startTable == null) {
            return null;
        }
        return this.diffService.createDiffTable(startTable, zielTable);
    }

    public String extractShortcut(PartDescription element) {
        return element.getToolboxViewName().substring(0, 4);
    }

    public String extractShortcut(String elementId) {
        String[] parts = elementId.split("\\.");
        return parts[parts.length - 1];
    }

    private String getContainerCacheId(IModelSession modelSession, TableType tableType) {
        if (tableType == TableType.DIFF) {
            return this.getContainerCacheId(modelSession, TableType.INITIAL) + "#" + this.getContainerCacheId(modelSession, TableType.FINAL);
        }
        return tableType.toString() + "$" + ContainerExtensions.getCacheId((MultiContainer_AttributeGroup)modelSession.getContainer(tableType.getContainerForTable()));
    }

    private PlanPro2TableTransformationService getModelService(String elementId) {
        Map.Entry result = this.modelServiceMap.entrySet().stream().filter(modelService -> ((TableInfo)modelService.getKey()).shortcut().equals(elementId.toLowerCase())).findFirst().orElse(null);
        if (result == null) {
            throw new IllegalArgumentException("no model service for " + elementId + " found!");
        }
        return (PlanPro2TableTransformationService)((Object)result.getValue());
    }

    public TableNameInfo getTableNameInfo(String shortcut) {
        return this.getModelService(shortcut).getTableNameInfo();
    }

    public Collection<TableInfo> getAvailableTables() {
        return new ArrayList<TableInfo>(this.modelServiceMap.keySet());
    }

    public Set<Integer> getFixedColumns(String elementID) {
        return this.getModelService(this.extractShortcut(elementID)).getFixedColumnsPos();
    }

    public Map<String, Collection<TableError>> getTableErrors(IModelSession modelSession, Set<String> controlAreaIds, TableInfo.Pt1TableCategory tableCategory) {
        HashMap<String, Collection<TableError>> map = new HashMap<String, Collection<TableError>>();
        Cache cache = this.getCache().getCache("toolbox.cache.table-errors");
        this.getAvailableTables().forEach(tableInfo -> {
            List<Pair<String, String>> cacheKeys;
            List<List> tableErrors;
            if (!(!tableInfo.category().equals((Object)tableCategory) || (tableErrors = (cacheKeys = this.getCacheKeys(tableInfo.shortcut(), modelSession, controlAreaIds)).stream().map(cacheKey -> (List)cache.getIfPresent((String)cacheKey.getValue())).filter(Objects::nonNull).toList()).isEmpty() && TableService.isTransformComplete((String)tableInfo.shortcut(), null))) {
                map.put(tableInfo.shortcut(), tableErrors.stream().flatMap(Collection::stream).toList());
            }
        });
        return map;
    }

    private boolean combineTableErrors(String cacheKey) {
        Collection initialErrors = (Collection)this.getCache().getCache("toolbox.cache.table-errors-initial").getIfPresent(cacheKey);
        Collection finalErrors = (Collection)this.getCache().getCache("toolbox.cache.table-errors-final").getIfPresent(cacheKey);
        if (initialErrors == null || finalErrors == null) {
            return false;
        }
        ArrayList combined = new ArrayList();
        combined.addAll(initialErrors);
        combined.addAll(finalErrors);
        this.getCache().getCache("toolbox.cache.table-errors").set(cacheKey, combined);
        this.broker.post("modelsession/change/tableerror", null);
        return true;
    }

    private void saveTableError(String shortCut, TableType tableType, Collection<TableError> errors, String cacheKey) {
        String shortName = this.getTableNameInfo(shortCut).getShortName();
        errors.forEach(error -> {
            error.setSource(shortName);
            error.setTableType(tableType);
        });
        switch (tableType) {
            case INITIAL: {
                this.getCache().getCache("toolbox.cache.table-errors-initial").set(cacheKey, errors);
                break;
            }
            case FINAL: {
                this.getCache().getCache("toolbox.cache.table-errors-final").set(cacheKey, errors);
                break;
            }
            default: {
                return;
            }
        }
        this.combineTableErrors(cacheKey);
    }

    private Object loadTransform(String elementId, TableType tableType, IModelSession modelSession, String controlAreaId) {
        String shortCut = this.extractShortcut(elementId);
        PlanPro2TableTransformationService modelService = this.getModelService(shortCut);
        Table transformedTable = null;
        if (tableType == TableType.DIFF) {
            transformedTable = this.createDiffTable(elementId, modelSession, controlAreaId);
            modelService.format(transformedTable);
        } else {
            MultiContainer_AttributeGroup container = modelSession.getContainer(tableType.getContainerForTable());
            Stell_Bereich area = StellBereichExtensions.getStellBereich((MultiContainer_AttributeGroup)container, (String)controlAreaId);
            if (controlAreaId == null || TableServiceImpl.isContainerContainArea(container, controlAreaId)) {
                transformedTable = modelService.transform(container, area);
            } else {
                transformedTable = TablemodelFactory.eINSTANCE.createTable();
                transformedTable.setTablecontent(TablemodelFactory.eINSTANCE.createTableContent());
                modelService.buildHeading(transformedTable);
            }
        }
        if (Thread.currentThread().isInterrupted() || transformedTable == null) {
            return MissingSupplier.MISSING_VALUE;
        }
        ECollections.sort((EList)transformedTable.getTablecontent().getRowgroups(), (Comparator)modelService.getRowGroupComparator());
        return transformedTable;
    }

    private static boolean isContainerContainArea(MultiContainer_AttributeGroup container, String areaId) {
        return StreamSupport.stream(container.getStellBereich().spliterator(), false).anyMatch(sb -> sb.getIdentitaet().getWert().equals(areaId));
    }

    public void removeModelService(Map<String, Object> properties) throws IllegalAccessException {
        TableInfo tableInfo = TableServiceContextFunction.getTableInfo(properties);
        this.modelServiceMap.remove(tableInfo);
    }

    public String transformToCsv(String elementId, TableType tableType, IModelSession modelSession, Set<String> controlAreas) {
        Table table = this.transformToTable(elementId, tableType, modelSession, controlAreas);
        return this.transformToCsv(table);
    }

    private String transformToCsv(Table table) {
        List rows = TableExtensions.getTableRows((Table)table);
        List<ColumnDescriptor> colNames = table.getColumndescriptors().stream().filter(descriptor -> !Strings.isNullOrEmpty((String)descriptor.getLabel())).toList();
        String delimeter = ";";
        Object result = "";
        for (ColumnDescriptor colName : colNames) {
            result = (String)result + colName.getLabel() + ";";
        }
        result = (String)result + "\n";
        for (TableRow row : rows) {
            for (ColumnDescriptor colName : colNames) {
                try {
                    result = (String)result + TableCellExtensions.getPlainStringValue((TableCell)TableRowExtensions.getCell((TableRow)row, (ColumnDescriptor)colName)) + ";";
                }
                catch (Exception e) {
                    result = (String)result + e.toString();
                }
            }
            result = (String)result + "\n";
        }
        return result;
    }

    private List<Pair<String, String>> getCacheKeys(String shortCut, IModelSession modelSession, Set<String> controlAreaIds) {
        if (controlAreaIds.isEmpty()) {
            String cachedKey = modelSession.isPlanningAreaIgnored() ? this.cacheService.cacheKeyBuilder(new String[]{shortCut, IGNORED_PLANNING_AREA_CACHE_KEY, EMPTY}) : this.cacheService.cacheKeyBuilder(new String[]{shortCut, EMPTY});
            return List.of(Pair.of(null, (Object)cachedKey));
        }
        return controlAreaIds.stream().map(areaId -> {
            String areaCacheKey = this.cacheService.cacheKeyBuilder(new String[]{shortCut, IGNORED_PLANNING_AREA_CACHE_KEY, areaId});
            return Pair.of((Object)areaId, (Object)areaCacheKey);
        }).toList();
    }

    public Table transformToTable(String elementId, TableType tableType, IModelSession modelSession, Set<String> controlAreaIds) {
        String shortCut = this.extractShortcut(elementId);
        String containerId = this.getContainerCacheId(modelSession, tableType);
        Cache cache = this.getCache().getCache("toolbox.cache.shortcut-to-table", containerId);
        Table resultTable = null;
        List<Pair<String, String>> cacheKeys = this.getCacheKeys(shortCut, modelSession, controlAreaIds);
        for (Pair<String, String> cacheKey : cacheKeys) {
            String areaId = (String)cacheKey.getKey();
            String areaCacheKey = (String)cacheKey.getValue();
            Table table = (Table)cache.getIfPresent(areaCacheKey);
            if (table == null) {
                table = (Table)this.loadTransform(shortCut, tableType, modelSession, areaId);
                this.saveTableToCache(table, containerId, shortCut, tableType, areaCacheKey);
            }
            if (resultTable == null) {
                resultTable = (Table)EcoreUtil.copy((EObject)table);
                continue;
            }
            for (RowGroup rowGroup : table.getTablecontent().getRowgroups()) {
                TableExtensions.addRowGroup((Table)resultTable, (RowGroup)rowGroup);
            }
        }
        if (resultTable != null && resultTable.getTablecontent() != null) {
            ECollections.sort((EList)resultTable.getTablecontent().getRowgroups(), (Comparator)this.getModelService(shortCut).getRowGroupComparator());
        }
        return resultTable;
    }

    private void saveTableToCache(Table table, String containerId, String shortCut, TableType tableType, String areaCacheKey) {
        String threadName = String.format("%s/saveCache/%s", shortCut, areaCacheKey);
        PlanPro2TableTransformationService modelService = this.getModelService(shortCut);
        Collection errors = modelService.getTableErrors();
        Thread storageCacheThread = new Thread(() -> this.lambda$9(containerId, table, areaCacheKey, shortCut, tableType, errors, threadName), threadName);
        storageCacheThread.start();
    }

    public void updateTable(BasePart tablePart, List<TableInfo.Pt1TableCategory> tableCategories, Runnable updateTableHandler, Runnable clearInstance) {
        IRunnableWithProgress updateTableProgress;
        List<String> tablePrefixes = List.of("org.eclipse.set.feature.table.estw", "org.eclipse.set.feature.table.etcs", "org.eclipse.set.feature.table.supplement-estw").stream().filter(prefix -> {
            if (tableCategories.isEmpty()) return true;
            if (tableCategories.stream().map(TableInfo.Pt1TableCategory::getId).anyMatch(prefix::contains)) return true;
            return false;
        }).toList();
        List<MPart> openTableParts = this.partService.getOpenParts().stream().filter(part -> tablePrefixes.stream().anyMatch(prefix -> part.getElementId().startsWith((String)prefix)) && !part.getElementId().endsWith("overview.TableOverviewPart")).map(MPart.class::cast).toList();
        transformTableThreads.add((Pair<BasePart, Runnable>)new Pair((Object)tablePart, (Object)updateTableHandler));
        List<MPart> parts = transformTableThreads.stream().map(pair -> ((BasePart)pair.getKey()).getToolboxPart()).toList();
        Object object = updateTableProgress = !MApplicationElementExtensions.isOpenPart((MApplicationElement)tablePart.getToolboxPart()) || parts.containsAll(openTableParts) ? this.createProgressMonitor() : null;
        if (updateTableProgress != null) {
            ProgressMonitorDialog monitor = new ProgressMonitorDialog(tablePart.getToolboxShell());
            try {
                logger.info("Start ProgressMonitorDialog...");
                monitor.run(true, true, updateTableProgress);
            }
            catch (InvocationTargetException e) {
                logger.error(e.toString(), (Throwable)e);
                throw new RuntimeException(e);
            }
            catch (InterruptedException e) {
                clearInstance.run();
                transformTableThreads.forEach(pair -> MApplicationElementExtensions.setViewState((MApplicationElement)((BasePart)pair.getKey()).getToolboxPart(), (ToolboxViewState)ToolboxViewState.CANCELED));
                Thread.currentThread().interrupt();
            }
        }
    }

    private IRunnableWithProgress createProgressMonitor() {
        return monitor -> {
            Pair<BasePart, Runnable> transformThread;
            monitor.beginTask(this.messages.Abstracttableview_transformation_progress, transformTableThreads.size() > 1 ? transformTableThreads.size() : -1);
            Threads.stopCurrentOnCancel((IProgressMonitor)monitor);
            while ((transformThread = transformTableThreads.poll()) != null) {
                String shortcut = this.extractShortcut(((BasePart)transformThread.getKey()).getToolboxPart().getElementId());
                TableNameInfo tableNameInfo = this.getTableNameInfo(shortcut);
                monitor.subTask(tableNameInfo.getFullDisplayName());
                Display.getDefault().syncExec((Runnable)transformThread.getValue());
                monitor.worked(1);
            }
            if (monitor.isCanceled()) {
                throw new InterruptedException();
            }
            monitor.done();
            logger.info("ProgressMonitorDialog done.");
        };
    }

    public void activate() {
        this.wireCacheSupplier();
    }

    private void wireCacheSupplier() {
        AbstractDirectedEdgePath.setEdgeToPointsCacheSupplier(() -> new EdgeToPointsCacheProxy(this.getCache()));
        Digraphs.setEdgeToSubPathCacheSupplier(() -> this.getCache().getCache("toolbox.cache.directed-edge-to-subpath"));
    }

    public Map<TableInfo, Table> transformTables(IProgressMonitor monitor, IModelSession modelSession, Set<TableInfo> tablesToTransfrom, TableType tableType, Set<String> controlAreaIds) {
        HashMap<TableInfo, Table> result = new HashMap<TableInfo, Table>();
        monitor.beginTask(this.messages.TableOverviewPart_CalculateMissingTask, tablesToTransfrom.size());
        for (TableInfo tableInfo : tablesToTransfrom) {
            String shortcut = tableInfo.shortcut();
            TableNameInfo nameInfo = this.getTableNameInfo(shortcut);
            monitor.subTask(nameInfo.getFullDisplayName());
            Table table = this.transformToTable(shortcut, tableType, modelSession, controlAreaIds);
            while (!TableService.isTransformComplete((String)nameInfo.getShortName().toLowerCase(), null)) {
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException e) {
                    Thread.interrupted();
                }
            }
            result.put(tableInfo, table);
            monitor.worked(1);
        }
        monitor.done();
        return result;
    }

    /*
     * Unable to fully structure code
     */
    private /* synthetic */ void lambda$9(String var1_1, Table var2_2, String var3_3, String var4_4, TableType var5_5, Collection var6_6, String var7_7) {
        storageFunc = (Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$10(java.lang.String org.eclipse.set.model.tablemodel.Table java.lang.String java.lang.String org.eclipse.set.basis.constants.TableType java.util.Collection ), ()V)((TableServiceImpl)this, (String)var1_1, (Table)var2_2, (String)var3_3, (String)var4_4, (TableType)var5_5, (Collection)var6_6);
        if (!TableService.isTransformComplete((String)var4_4, (Predicate<String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$11(java.lang.String java.lang.String ), (Ljava/lang/String;)Z)((String)var7_7))) ** GOTO lbl11
        storageFunc.run();
        return;
lbl-1000:
        // 1 sources

        {
            try {
                Thread.sleep(2000L);
                continue;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return;
            }
lbl11:
            // 2 sources

            ** while (!TableService.isTransformComplete((String)var4_4, (Predicate<String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$12(java.lang.String java.lang.String ), (Ljava/lang/String;)Z)((String)var7_7)))
        }
lbl12:
        // 1 sources

        storageFunc.run();
    }

    private /* synthetic */ void lambda$10(String string, Table table, String string2, String string3, TableType tableType, Collection collection) {
        Cache cache = this.getCache().getCache("toolbox.cache.shortcut-to-table", string);
        if (table != null) {
            cache.set(string2, (Object)table);
        }
        this.saveTableError(string3, tableType, collection, string2);
    }

    private static /* synthetic */ boolean lambda$11(String string, String s) {
        return !s.equalsIgnoreCase(string);
    }

    private static /* synthetic */ boolean lambda$12(String string, String s) {
        return !s.equalsIgnoreCase(string);
    }
}

