/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.feature.siteplan.browserfunctions;

import java.nio.file.Path;
import java.util.Optional;
import org.eclipse.set.browser.swt.Browser;
import org.eclipse.set.browser.swt.BrowserFunction;
import org.eclipse.set.core.services.dialog.DialogService;
import org.eclipse.set.feature.siteplan.SiteplanBrowser;
import org.eclipse.set.utils.ToolboxConfiguration;
import org.eclipse.swt.widgets.Shell;

public class SelectFolderDialogBrowserFunction
extends BrowserFunction {
    protected static final String DIALOG_CALLBACK_FUNCTION = "window.planproSelectFolderDialogCallback";
    protected DialogService dialogService;
    protected Shell shell;
    protected SiteplanBrowser webBrowser;

    public SelectFolderDialogBrowserFunction(SiteplanBrowser webBrowser, String name, Shell shell, DialogService dialogService) {
        super((Browser)webBrowser.getBrowser(), name);
        this.shell = shell;
        this.webBrowser = webBrowser;
        this.dialogService = dialogService;
    }

    public Object function(Object[] arguments) {
        Optional optionalOutputDir = this.dialogService.selectDirectory(this.shell, ToolboxConfiguration.getDefaultPath().toString());
        String key = (String)arguments[0];
        optionalOutputDir.ifPresentOrElse(outputDir -> {
            this.webBrowser.executeJavascript(String.format("%s('%s', '%s');", DIALOG_CALLBACK_FUNCTION, key, outputDir.replace("\\", "\\\\")));
            this.webBrowser.setSelectedFolder(Path.of(outputDir, new String[0]));
        }, () -> this.webBrowser.executeJavascript(String.format("%s('%s', null);", DIALOG_CALLBACK_FUNCTION, key)));
        return null;
    }
}

