/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.feature.siteplan;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import java.util.function.Consumer;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.di.UISynchronize;
import org.eclipse.emfcloud.jackson.module.EMFModule;
import org.eclipse.set.basis.IModelSession;
import org.eclipse.set.basis.cache.Cache;
import org.eclipse.set.browser.DownloadListener;
import org.eclipse.set.browser.RequestHandler;
import org.eclipse.set.core.services.cache.CacheService;
import org.eclipse.set.core.services.dialog.DialogService;
import org.eclipse.set.feature.siteplan.SiteplanConfiguration;
import org.eclipse.set.feature.siteplan.json.SiteplanEObjectSerializer;
import org.eclipse.set.feature.siteplan.transform.SiteplanTransformator;
import org.eclipse.set.model.siteplan.Siteplan;
import org.eclipse.set.utils.FileWebBrowser;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

public class SiteplanBrowser
extends FileWebBrowser
implements DownloadListener {
    private static final Path PATH_OSIFONT = Paths.get("data/fonts/osifont/osifont-lgpl3fe.ttf", new String[0]);
    private final SiteplanTransformator transformator;
    private final CacheService cacheService;
    private final IModelSession modelSession;
    private final DialogService dialogService;
    private final UISynchronize ui;
    private final Shell shell;
    private Path selectedOutputDir;
    private final IEventBroker broker;
    private Consumer<String> beforedownloadFunction;

    public SiteplanBrowser(Composite parent, IEclipseContext context, Shell shell, IEventBroker broker) throws IOException {
        super(parent);
        this.transformator = (SiteplanTransformator)context.get(SiteplanTransformator.class);
        this.modelSession = (IModelSession)context.get(IModelSession.class);
        this.dialogService = (DialogService)context.get(DialogService.class);
        this.ui = (UISynchronize)context.get(UISynchronize.class);
        this.cacheService = (CacheService)context.get(CacheService.class);
        this.broker = broker;
        this.shell = shell;
        this.serveRootDirectory(Paths.get("./web/siteplan", new String[0]));
        this.serveFile("?", "text/html", Paths.get("./web/siteplan", "index.html"));
        this.serveUri("font", this::serveFont);
        this.serveUri("siteplan.json", this::serveSiteplan);
        this.serveUri("configuration.json", this::serveConfiguration);
        this.getBrowser().setDownloadListener((DownloadListener)this);
    }

    private void serveFont(RequestHandler.Response response) throws IOException {
        response.setMimeType("application/x-font-ttf");
        response.setResponseData(Files.newInputStream(PATH_OSIFONT, new OpenOption[0]));
    }

    private void serveConfiguration(RequestHandler.Response response) throws JsonProcessingException {
        response.setMimeType("application/json;charset=UTF-8");
        String json = new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)new SiteplanConfiguration("siteplan"));
        response.setResponseData(json);
    }

    private void serveSiteplan(RequestHandler.Response response) throws JsonProcessingException {
        Cache cache = this.cacheService.getCache("toolbox.cache.siteplan");
        Siteplan siteplan = (Siteplan)cache.get("transfomartion", () -> {
            this.broker.send("siteplan/open/firsttime", (Object)Boolean.TRUE);
            return this.transformator.transform(this.modelSession);
        });
        ObjectMapper mapper = new ObjectMapper();
        EMFModule module = new EMFModule();
        module.configure(EMFModule.Feature.OPTION_SERIALIZE_TYPE, false);
        module.configure(EMFModule.Feature.OPTION_SERIALIZE_DEFAULT_VALUE, true);
        mapper.registerModule((Module)module);
        mapper.registerModule((Module)SiteplanEObjectSerializer.getModule(module));
        String json = mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)siteplan);
        response.setMimeType("application/json;charset=UTF-8");
        response.setResponseData(json);
    }

    public Optional<Path> beforeDownload(String suggestedName, String url) {
        if (this.beforedownloadFunction != null) {
            this.beforedownloadFunction.accept(url);
        }
        if (this.selectedOutputDir == null) {
            return Optional.empty();
        }
        return Optional.of(Path.of(this.selectedOutputDir.toAbsolutePath().toString(), suggestedName));
    }

    public void downloadFinished(boolean success, Path path) {
        this.ui.asyncExec(() -> this.dialogService.openDirectoryAfterExport(this.shell, this.selectedOutputDir));
    }

    public void setSelectedFolder(Path outputDir) {
        this.selectedOutputDir = outputDir;
    }

    public void setBeforeDownloadFunc(Consumer<String> func) {
        this.beforedownloadFunction = func;
    }
}

