/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.feature.export.pdf;

import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.poi.UnsupportedFileFormatException;
import org.eclipse.set.basis.FreeFieldInfo;
import org.eclipse.set.basis.OverwriteHandling;
import org.eclipse.set.basis.Pair;
import org.eclipse.set.basis.ToolboxPaths;
import org.eclipse.set.basis.constants.ExportType;
import org.eclipse.set.basis.constants.TableType;
import org.eclipse.set.basis.exceptions.FileExportException;
import org.eclipse.set.feature.export.pdf.FopPdfExportBuilder;
import org.eclipse.set.feature.export.pdf.TableToTableDocument;
import org.eclipse.set.model.tablemodel.Table;
import org.eclipse.set.model.titlebox.Titlebox;
import org.eclipse.set.services.export.TableExport;
import org.eclipse.set.services.fop.FopService;
import org.eclipse.set.utils.ToolboxConfiguration;
import org.eclipse.set.utils.export.xsl.TransformTable;
import org.eclipse.set.utils.export.xsl.siteplan.SiteplanXSL;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

@Component(immediate=true, service={TableExport.class})
public class SiteplanPdfExportBuilder
extends FopPdfExportBuilder {
    private static final String SITEPLAN_EXPORT_NAME = "SI";

    @Override
    @Reference(cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.STATIC, unbind="-")
    public void setFopService(FopService fopService) {
        this.fopService = fopService;
    }

    private static String createImageDocumentText(List<BufferedImage> imagesData, Titlebox titleBox, FreeFieldInfo freeFieldInfo, double ppm) throws ParserConfigurationException, TransformerException {
        TableToTableDocument tableToXmlFo = TableToTableDocument.createTransformation();
        Document document = tableToXmlFo.transformToDocument(imagesData, titleBox, freeFieldInfo, ppm);
        Transformer documentToString = SiteplanPdfExportBuilder.newTransformerFactory().newTransformer();
        DOMSource source = new DOMSource(document);
        StringWriter writer = new StringWriter();
        StreamResult result = new StreamResult(writer);
        documentToString.transform(source, result);
        return writer.toString();
    }

    @Override
    public void exportTitleboxImage(Titlebox titlebox, Path imagePath, OverwriteHandling overwriteHandling) throws Exception {
    }

    @Override
    public void exportTitleboxPdf(Titlebox titlebox, Path pdfPath, OverwriteHandling overwriteHandling) throws Exception {
    }

    @Override
    public void export(Map<TableType, Table> tables, ExportType exportType, Titlebox titlebox, FreeFieldInfo freeFieldInfo, String shortcut, String outputDir, ToolboxPaths toolboxPaths, TableType tableType, OverwriteHandling overwriteHandling) throws FileExportException {
    }

    @Override
    public void exportSiteplanPdf(List<BufferedImage> imagesData, Titlebox titleBox, FreeFieldInfo freeFieldInfo, double ppm, String outputDir, ToolboxPaths toolboxPaths, TableType tableType, OverwriteHandling overwriteHandling) {
        try {
            String imageDocumentText = SiteplanPdfExportBuilder.createImageDocumentText(imagesData, titleBox, freeFieldInfo, ppm);
            if (ToolboxConfiguration.isDevelopmentMode()) {
                SiteplanPdfExportBuilder.exportTableDocument(Paths.get(outputDir, SiteplanPdfExportBuilder.getFilename(SITEPLAN_EXPORT_NAME, "xml")), imageDocumentText);
            }
            ByteArrayInputStream tableDocumentStream = new ByteArrayInputStream(imageDocumentText.getBytes(StandardCharsets.UTF_8));
            StreamSource imageDocumentSource = new StreamSource(tableDocumentStream);
            Pair<String, StreamSource> xslStreamSource = this.getSiteplanXSLTemplate(imagesData, ppm, tableType, outputDir);
            Path outputPath = toolboxPaths.getTableExportPath("SI_" + (String)xslStreamSource.getFirst(), Paths.get(outputDir, new String[0]), ExportType.PLANNING_RECORDS, ToolboxPaths.ExportPathExtension.TABLE_PDF_EXPORT_EXTENSION);
            this.fopService.fop(FopService.OutputFormat.PDF, (Source)xslStreamSource.getSecond(), (Source)imageDocumentSource, outputPath, FopService.PdfAMode.PDF_A_3a, overwriteHandling, null);
        }
        catch (Exception e) {
            throw new FileExportException(Path.of(outputDir, SITEPLAN_EXPORT_NAME), (Throwable)e);
        }
    }

    private Pair<String, StreamSource> getSiteplanXSLTemplate(List<BufferedImage> imagesData, double ppm, TableType tableType, String outputDir) throws ParserConfigurationException, SAXException, IOException, NullPointerException, TransformerException, UnsupportedFileFormatException {
        SiteplanXSL siteplanXSL = new SiteplanXSL(imagesData, ppm, this.translationTableType(tableType));
        Document xslDoc = siteplanXSL.getXSLDocument();
        String pageDIN = siteplanXSL.getPageStyle().getPageDIN().toString();
        if (ToolboxConfiguration.isDevelopmentMode()) {
            Transformer documentToString = SiteplanPdfExportBuilder.newTransformerFactory().newTransformer();
            DOMSource source = new DOMSource(xslDoc);
            StringWriter writer = new StringWriter();
            StreamResult result = new StreamResult(writer);
            documentToString.transform(source, result);
            SiteplanPdfExportBuilder.exportTableDocument(Path.of(outputDir, SiteplanPdfExportBuilder.getFilename("SI_" + pageDIN, "xsl")), writer.toString());
        }
        return new Pair((Object)pageDIN, (Object)TransformTable.toStreamSource((Document)xslDoc));
    }
}

