/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.feature.table.pt1.sskp;

import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import org.eclipse.nebula.widgets.nattable.sort.SortDirectionEnum;
import org.eclipse.set.core.services.enumtranslation.EnumTranslationService;
import org.eclipse.set.core.services.graph.TopologicalGraphService;
import org.eclipse.set.feature.table.PlanPro2TableTransformationService;
import org.eclipse.set.feature.table.pt1.AbstractPlanPro2TableModelTransformator;
import org.eclipse.set.feature.table.pt1.AbstractPlanPro2TableTransformationService;
import org.eclipse.set.feature.table.pt1.messages.Messages;
import org.eclipse.set.feature.table.pt1.sskp.SskpTransformator;
import org.eclipse.set.model.tablemodel.CellContent;
import org.eclipse.set.model.tablemodel.ColumnDescriptor;
import org.eclipse.set.model.tablemodel.CompareCellContent;
import org.eclipse.set.model.tablemodel.MultiColorCellContent;
import org.eclipse.set.model.tablemodel.MultiColorContent;
import org.eclipse.set.model.tablemodel.RowGroup;
import org.eclipse.set.model.tablemodel.RowMergeMode;
import org.eclipse.set.model.tablemodel.StringCellContent;
import org.eclipse.set.model.tablemodel.TableCell;
import org.eclipse.set.ppmodel.extensions.utils.IterableExtensions;
import org.eclipse.set.ppmodel.extensions.utils.TableNameInfo;
import org.eclipse.set.utils.table.ColumnDescriptorModelBuilder;
import org.eclipse.set.utils.table.sorting.ComparatorBuilder;
import org.eclipse.set.utils.table.sorting.TableRowGroupComparator;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={PlanPro2TableTransformationService.class}, immediate=true, property={"table.category=estw", "table.shortcut=sskp"})
public final class SskpTransformationService
extends AbstractPlanPro2TableTransformationService {
    @Reference
    private Messages messages;
    @Reference
    private EnumTranslationService enumTranslationService;
    @Reference
    private TopologicalGraphService topGraphService;

    public AbstractPlanPro2TableModelTransformator createTransformator() {
        return new SskpTransformator(this.cols, this.enumTranslationService, this.topGraphService);
    }

    public TableNameInfo getTableNameInfo() {
        return new TableNameInfo(this.messages.ToolboxTableNameSskpLong, this.messages.ToolboxTableNameSskpPlanningNumber, this.messages.ToolboxTableNameSskpShort);
    }

    @Override
    protected String getTableHeading() {
        return this.messages.SskpTableView_Heading;
    }

    /*
     * WARNING - void declaration
     */
    private static String getCellContent(TableCell cell) {
        CellContent cellContent = cell.getContent();
        if (cellContent instanceof StringCellContent) {
            void cellContent2;
            StringCellContent stringCellContent = (StringCellContent)cellContent;
            StringCellContent cfr_ignored_0 = (StringCellContent)cellContent;
            return (String)IterableExtensions.getFirstOrNull((Iterable)cellContent2.getValue());
        }
        CellContent cellContent3 = cell.getContent();
        if (cellContent3 instanceof CompareCellContent) {
            void cellContent4;
            CompareCellContent compareCellContent = (CompareCellContent)cellContent3;
            CompareCellContent cfr_ignored_1 = (CompareCellContent)cellContent3;
            if (cellContent4.getNewValue().isEmpty() || cellContent4.getOldValue().isEmpty()) {
                return Optional.ofNullable((String)IterableExtensions.getFirstOrNull((Iterable)cellContent4.getNewValue())).orElse((String)IterableExtensions.getFirstOrNull((Iterable)cellContent4.getOldValue()));
            }
            return (String)cellContent4.getNewValue().get(0) + cellContent4.getSeparator() + (String)cellContent4.getOldValue().get(0);
        }
        CellContent cellContent5 = cell.getContent();
        if (cellContent5 instanceof MultiColorCellContent) {
            void cellContent6;
            MultiColorCellContent multiColorCellContent = (MultiColorCellContent)cellContent5;
            MultiColorCellContent cfr_ignored_2 = (MultiColorCellContent)cellContent5;
            MultiColorContent firstOrNull = (MultiColorContent)IterableExtensions.getFirstOrNull((Iterable)cellContent6.getValue());
            return firstOrNull != null ? firstOrNull.getMultiColorValue() : null;
        }
        return null;
    }

    public Comparator<RowGroup> getRowGroupComparator() {
        List<String> gmOrder = List.of("2000", "1000/2000", "1000", "500");
        return TableRowGroupComparator.builder().sort("A", ComparatorBuilder.CellComparatorType.LEXICOGRAPHICAL, SortDirectionEnum.ASC).sort("B", Comparator.comparing(SskpTransformationService::getCellContent, Comparator.nullsLast(Comparator.comparing(gmOrder::indexOf, Integer::compareUnsigned)))).build();
    }

    @Override
    public ColumnDescriptor fillHeaderDescriptions(ColumnDescriptorModelBuilder builder) {
        ColumnDescriptor cd = super.fillHeaderDescriptions(builder);
        cd.setMergeCommonValues(RowMergeMode.ENABLED);
        List.of("C", "D", "E", "F").forEach(it -> this.cols.forEach(col -> {
            if (it.equals(col.getColumnPosition())) {
                col.setMergeCommonValues(RowMergeMode.DISABLED);
            }
        }));
        return cd;
    }
}

