/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.feature.validation;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EValidator;
import org.eclipse.emf.ecore.util.Diagnostician;

public class FilterDiagnostician
extends Diagnostician {
    private final List<Predicate<? super Diagnostic>> filters = new ArrayList<Predicate<? super Diagnostic>>();

    public void addFilter(Predicate<? super Diagnostic> filter) {
        this.filters.add(filter);
    }

    protected boolean doValidate(EValidator eValidator, EClass eClass, EObject eObject, DiagnosticChain diagnostics, Map<Object, Object> context) {
        DiagnosticCollector filter = new DiagnosticCollector();
        boolean result = eValidator.validate(eClass, eObject, (DiagnosticChain)filter, context);
        filter.getDiagnostics().stream().filter(diagnostic -> this.filters.stream().allMatch(c -> c.test(diagnostic))).forEach(arg_0 -> ((DiagnosticChain)diagnostics).add(arg_0));
        return result;
    }

    private class DiagnosticCollector
    implements DiagnosticChain {
        private final List<Diagnostic> diagnostics = new ArrayList<Diagnostic>();

        private DiagnosticCollector() {
        }

        public void add(Diagnostic diagnostic) {
            this.diagnostics.add(diagnostic);
        }

        public void addAll(Diagnostic diagnostic) {
            for (Diagnostic child : diagnostic.getChildren()) {
                this.add(child);
            }
        }

        public void merge(Diagnostic diagnostic) {
            if (diagnostic.getChildren().isEmpty()) {
                this.add(diagnostic);
            } else {
                this.addAll(diagnostic);
            }
        }

        public List<Diagnostic> getDiagnostics() {
            return this.diagnostics;
        }
    }
}

