/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.utils.xml;

import java.io.IOException;
import java.nio.file.Path;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.set.basis.extensions.PathExtensions;
import org.eclipse.set.basis.files.ToolboxFile;
import org.eclipse.set.model.validationreport.ObjectScope;
import org.eclipse.set.model.validationreport.ObjectState;
import org.eclipse.set.utils.xml.LineNumberXMLReader;
import org.eclipse.set.utils.xml.NodeAttributeNameProvider;
import org.eclipse.set.utils.xml.NodeObjectScopeProvider;
import org.eclipse.set.utils.xml.NodeObjectStateProvider;
import org.eclipse.set.utils.xml.NodeObjectTypeProvider;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class ObjectMetadataXMLReader {
    private static final String METADATA_READER_KEY = "metadataReader";
    private final Path documentPath;
    private final NodeObjectTypeProvider validationObjectTypeProvider;
    private final NodeObjectScopeProvider validationObjectScopeProvider;
    private final NodeObjectStateProvider validationObjectStateProvider;
    private final NodeAttributeNameProvider validationAttributeNameProvider;

    public static Document read(ToolboxFile toolboxFile, Path docPath) throws IOException, SAXException, ParserConfigurationException {
        if (docPath == null) {
            return null;
        }
        String docName = PathExtensions.getBaseFileName((Path)docPath);
        Document document = toolboxFile.getXMLDocument(docName);
        if (document == null) {
            ObjectMetadataXMLReader reader = new ObjectMetadataXMLReader(docPath);
            document = reader.read();
            toolboxFile.setXMLDocument(PathExtensions.getBaseFileName((Path)docPath), document);
        }
        return document;
    }

    private Document read() throws IOException, SAXException, ParserConfigurationException {
        Document document = LineNumberXMLReader.read(this.documentPath);
        document.setUserData(METADATA_READER_KEY, this, null);
        return document;
    }

    private ObjectMetadataXMLReader(Path path) {
        this.documentPath = path;
        this.validationObjectScopeProvider = new NodeObjectScopeProvider();
        this.validationObjectStateProvider = new NodeObjectStateProvider();
        this.validationObjectTypeProvider = new NodeObjectTypeProvider();
        this.validationAttributeNameProvider = new NodeAttributeNameProvider();
    }

    public static ObjectScope getObjectScope(Node node) {
        ObjectMetadataXMLReader metadata = ObjectMetadataXMLReader.getMetadataReader(node);
        return metadata.validationObjectScopeProvider.getObjectScope(node);
    }

    public static String getObjectScopeLiteral(Node node) {
        return ObjectMetadataXMLReader.getObjectScope(node).getLiteral();
    }

    public static String getObjectType(Node node) {
        ObjectMetadataXMLReader metadata = ObjectMetadataXMLReader.getMetadataReader(node);
        return metadata.validationObjectTypeProvider.getObjectType(node);
    }

    public static ObjectState getObjectState(Node node) {
        ObjectMetadataXMLReader metadata = ObjectMetadataXMLReader.getMetadataReader(node);
        return metadata.validationObjectStateProvider.getObjectState(node);
    }

    public static String getAttributeName(Node node) {
        ObjectMetadataXMLReader metadata = ObjectMetadataXMLReader.getMetadataReader(node);
        return metadata.validationAttributeNameProvider.getAttributeName(node);
    }

    private static ObjectMetadataXMLReader getMetadataReader(Node node) {
        return (ObjectMetadataXMLReader)node.getOwnerDocument().getUserData(METADATA_READER_KEY);
    }
}

