/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.utils.math;

import com.google.common.math.BigIntegerMath;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;

public class Clothoid {
    private final int clothoidIter;
    private final double radius;
    private final double totalLength;

    static double clothoidTerm(int index, double T) {
        if (!Double.isFinite(T)) {
            return 0.0;
        }
        BigDecimal factor = BigDecimal.valueOf(index % 4 <= 1 ? 1 : -1);
        BigDecimal divisor = new BigDecimal(BigIntegerMath.factorial((int)index).multiply(BigInteger.valueOf((long)(2 * index) + 1L)));
        BigDecimal power = BigDecimal.valueOf(T).pow(index);
        return factor.multiply(power).divide(divisor, RoundingMode.HALF_UP).doubleValue();
    }

    public Clothoid(double radius, double totalLength, int iterations) {
        this.clothoidIter = iterations;
        this.radius = radius;
        this.totalLength = totalLength;
    }

    public List<double[]> getPoints(int segmentCount) {
        double segmentLength = this.totalLength / (double)(segmentCount - 1);
        ArrayList<double[]> positions = new ArrayList<double[]>();
        int i = 0;
        while (i < segmentCount) {
            positions.add(this.getPoint(segmentLength * (double)i));
            ++i;
        }
        return positions;
    }

    public double[] getPoint(double length) {
        return this.clothoidSegment(length, this.radius * length);
    }

    private double[] clothoidSegment(double L, double Asq) {
        double T = L * L / (2.0 * Asq);
        return new double[]{this.clothoidX(L, T), this.clothoidY(L, T)};
    }

    private double clothoidX(double L, double T) {
        double result = 0.0;
        int i = 0;
        while (i < this.clothoidIter) {
            result += Clothoid.clothoidTerm(2 * i, T);
            ++i;
        }
        return L * result;
    }

    private double clothoidY(double L, double T) {
        double result = 0.0;
        int i = 0;
        while (i < this.clothoidIter) {
            result += Clothoid.clothoidTerm(2 * i + 1, T);
            ++i;
        }
        return L * result;
    }
}

