/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.ppmodel.extensions;

import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.set.basis.constants.ContainerType;
import org.eclipse.set.model.planpro.Basisobjekte.Basis_Objekt;
import org.eclipse.set.model.planpro.Basisobjekte.Punkt_Objekt;
import org.eclipse.set.model.planpro.PlanPro.Ausgabe_Fachdaten;
import org.eclipse.set.model.planpro.PlanPro.Container_AttributeGroup;
import org.eclipse.set.model.planpro.PlanPro.LST_Zustand;
import org.eclipse.set.model.planpro.PlanPro.PlanPro_Schnittstelle;
import org.eclipse.set.model.planpro.PlanPro.Planung_Einzel;
import org.eclipse.set.model.planpro.Verweise.ID_Ausgabe_Fachdaten_ohne_Proxy_TypeClass;
import org.eclipse.set.ppmodel.extensions.BasisObjektExtensions;
import org.eclipse.set.ppmodel.extensions.PlanProSchnittstelleExtensions;
import org.eclipse.set.ppmodel.extensions.container.MultiContainer_AttributeGroup;
import org.eclipse.set.ppmodel.extensions.utils.LstObjectAttribute;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;

public class ContainerExtensions {
    public static int getSize(Container_AttributeGroup container) {
        return container.eContents().size();
    }

    public static Iterable<Punkt_Objekt> getPunktObjekte(MultiContainer_AttributeGroup container) {
        LinkedList<Punkt_Objekt> punktObjekte = new LinkedList<Punkt_Objekt>();
        Iterables.addAll(punktObjekte, (Iterable)container.getBahnsteigZugang());
        Iterables.addAll(punktObjekte, (Iterable)container.getBUEAnlage());
        Iterables.addAll(punktObjekte, (Iterable)container.getFMAElement());
        Iterables.addAll(punktObjekte, (Iterable)container.getFMAKomponente());
        Iterables.addAll(punktObjekte, (Iterable)container.getGleisAbschluss());
        Iterables.addAll(punktObjekte, (Iterable)container.getHoehenpunkt());
        Iterables.addAll(punktObjekte, (Iterable)container.getPZBElement());
        Iterables.addAll(punktObjekte, (Iterable)container.getSignal());
        Iterables.addAll(punktObjekte, (Iterable)container.getSignalBefestigung());
        Iterables.addAll(punktObjekte, (Iterable)container.getSonstigerPunkt());
        Iterables.addAll(punktObjekte, (Iterable)container.getTechnischerPunkt());
        Iterables.addAll(punktObjekte, (Iterable)container.getUeberhoehung());
        Iterables.addAll(punktObjekte, (Iterable)container.getWKrGspKomponente());
        Iterables.addAll(punktObjekte, (Iterable)container.getZugeinwirkung());
        return punktObjekte;
    }

    public static Iterable<Basis_Objekt> getNBElemente(MultiContainer_AttributeGroup container) {
        Iterable _signal = container.getSignal();
        Iterable _wKrGspKomponente = container.getWKrGspKomponente();
        Iterable _plus = Iterables.concat((Iterable)_signal, (Iterable)_wKrGspKomponente);
        Iterable _schluesselsperre = container.getSchluesselsperre();
        return Iterables.concat((Iterable)_plus, (Iterable)_schluesselsperre);
    }

    public static Iterable<Basis_Objekt> getSchalter(MultiContainer_AttributeGroup container) {
        Iterable _fMAAnlage = container.getFMAAnlage();
        Iterable _fMAKomponente = container.getFMAKomponente();
        Iterable _plus = Iterables.concat((Iterable)_fMAAnlage, (Iterable)_fMAKomponente);
        Iterable _zugeinwirkung = container.getZugeinwirkung();
        return Iterables.concat((Iterable)_plus, (Iterable)_zugeinwirkung);
    }

    public static Iterable<Basis_Objekt> getGZFreimeldungAngrenzendeElemente(MultiContainer_AttributeGroup container) {
        Iterable _wKrGspElement = container.getWKrGspElement();
        Iterable _gleisAbschnitt = container.getGleisAbschnitt();
        return Iterables.concat((Iterable)_wKrGspElement, (Iterable)_gleisAbschnitt);
    }

    public static String getCacheId(MultiContainer_AttributeGroup container) {
        return container.getCacheString();
    }

    public static Planung_Einzel getPlanungEinzel(Container_AttributeGroup container) {
        boolean _tripleNotEquals;
        Functions.Function1 _function = it -> {
            ID_Ausgabe_Fachdaten_ohne_Proxy_TypeClass _iDAusgabeFachdaten = it.getIDAusgabeFachdaten();
            String _wert = null;
            if (_iDAusgabeFachdaten != null) {
                _wert = _iDAusgabeFachdaten.getWert();
            }
            String _wert_1 = ContainerExtensions.getAusgabeFachdaten(container).getIdentitaet().getWert();
            return Objects.equals(_wert, _wert_1);
        };
        Set planning = IteratorExtensions.toSet((Iterator)IteratorExtensions.filter((Iterator)Iterators.filter((Iterator)ContainerExtensions.getPlanProSchnittstelle(container).getLSTPlanung().getObjektmanagement().eAllContents(), Planung_Einzel.class), (Functions.Function1)_function));
        int _size = planning.size();
        boolean bl = _tripleNotEquals = _size != 1;
        if (_tripleNotEquals) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("No Planung_Einzel for Container of Zustand ");
            String _zustandGuid = ContainerExtensions.getZustandGuid(container);
            _builder.append(_zustandGuid);
            _builder.append(" found.");
            throw new IllegalArgumentException(_builder.toString());
        }
        return ((Planung_Einzel[])Conversions.unwrapArray((Object)planning, Planung_Einzel.class))[0];
    }

    public static String getZustandGuid(Container_AttributeGroup container) {
        return ContainerExtensions.getGuid(container.eContainer());
    }

    public static Ausgabe_Fachdaten getAusgabeFachdaten(Container_AttributeGroup container) {
        EObject _eContainer = container.eContainer().eContainer();
        return (Ausgabe_Fachdaten)_eContainer;
    }

    public static PlanPro_Schnittstelle getPlanProSchnittstelle(Container_AttributeGroup container) {
        return ContainerExtensions.getPlanProSchnittstelleDispatch((EObject)container);
    }

    public static String logString(MultiContainer_AttributeGroup container) {
        EStructuralFeature schnittstelleType = ContainerExtensions.getPlanProSchnittstelle(container).eContainingFeature();
        if (schnittstelleType != null) {
            StringConcatenation _builder = new StringConcatenation();
            String _name = schnittstelleType.getName();
            _builder.append(_name);
            _builder.append("/");
            ContainerType _containerType = ContainerExtensions.containerType(container);
            _builder.append((Object)_containerType);
            return _builder.toString();
        }
        StringConcatenation _builder_1 = new StringConcatenation();
        ContainerType _containerType_1 = ContainerExtensions.containerType(container);
        _builder_1.append((Object)_containerType_1);
        return _builder_1.toString();
    }

    public static ContainerType containerType(MultiContainer_AttributeGroup container) {
        boolean _tripleEquals_2;
        boolean _tripleEquals_1;
        boolean _tripleEquals;
        PlanPro_Schnittstelle schnittstelle = ContainerExtensions.getPlanProSchnittstelle(container);
        MultiContainer_AttributeGroup _container = PlanProSchnittstelleExtensions.getContainer(schnittstelle, ContainerType.SINGLE);
        boolean bl = _tripleEquals = _container == container;
        if (_tripleEquals) {
            return ContainerType.SINGLE;
        }
        MultiContainer_AttributeGroup _container_1 = PlanProSchnittstelleExtensions.getContainer(schnittstelle, ContainerType.INITIAL);
        boolean bl2 = _tripleEquals_1 = _container_1 == container;
        if (_tripleEquals_1) {
            return ContainerType.INITIAL;
        }
        MultiContainer_AttributeGroup _container_2 = PlanProSchnittstelleExtensions.getContainer(schnittstelle, ContainerType.FINAL);
        boolean bl3 = _tripleEquals_2 = _container_2 == container;
        if (_tripleEquals_2) {
            return ContainerType.FINAL;
        }
        return null;
    }

    public static PlanPro_Schnittstelle getPlanProSchnittstelle(MultiContainer_AttributeGroup container) {
        return ContainerExtensions.getPlanProSchnittstelleDispatch((EObject)container.getFirstLSTZustand());
    }

    public static List<LstObjectAttribute> getObjectAttributes(MultiContainer_AttributeGroup container) {
        Functions.Function1 _function = it -> BasisObjektExtensions.getObjectAttributes(it);
        return IterableExtensions.toList((Iterable)Iterables.concat((Iterable)IterableExtensions.map((Iterable)container.getBasisObjekt(), (Functions.Function1)_function)));
    }

    private static PlanPro_Schnittstelle _getPlanProSchnittstelleDispatch(EObject object) {
        return ContainerExtensions.getPlanProSchnittstelleDispatch(object.eContainer());
    }

    private static PlanPro_Schnittstelle _getPlanProSchnittstelleDispatch(PlanPro_Schnittstelle schnittstelle) {
        return schnittstelle;
    }

    protected static String _getGuid(EObject object) {
        String _name = object.eClass().getName();
        throw new IllegalArgumentException(_name);
    }

    protected static String _getGuid(LST_Zustand zustand) {
        return zustand.getIdentitaet().getWert();
    }

    private static PlanPro_Schnittstelle getPlanProSchnittstelleDispatch(EObject schnittstelle) {
        if (schnittstelle instanceof PlanPro_Schnittstelle) {
            return ContainerExtensions._getPlanProSchnittstelleDispatch((PlanPro_Schnittstelle)schnittstelle);
        }
        if (schnittstelle != null) {
            return ContainerExtensions._getPlanProSchnittstelleDispatch(schnittstelle);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(schnittstelle).toString());
    }

    public static String getGuid(EObject zustand) {
        if (zustand instanceof LST_Zustand) {
            return ContainerExtensions._getGuid((LST_Zustand)zustand);
        }
        if (zustand != null) {
            return ContainerExtensions._getGuid(zustand);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(zustand).toString());
    }
}

