/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.feature.plazmodel;

import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.e4.core.services.nls.Translation;
import org.eclipse.e4.ui.di.UISynchronize;
import org.eclipse.e4.ui.model.application.MApplicationElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecp.ui.view.ECPRendererException;
import org.eclipse.set.basis.ProblemMessage;
import org.eclipse.set.basis.cache.Cache;
import org.eclipse.set.basis.constants.ToolboxViewState;
import org.eclipse.set.basis.extensions.MApplicationElementExtensions;
import org.eclipse.set.core.services.cache.CacheService;
import org.eclipse.set.core.services.configurationservice.UserConfigurationService;
import org.eclipse.set.core.services.dialog.DialogService;
import org.eclipse.set.core.services.enumtranslation.EnumTranslationService;
import org.eclipse.set.feature.plazmodel.Messages;
import org.eclipse.set.feature.plazmodel.check.PlazCheck;
import org.eclipse.set.feature.plazmodel.service.PlazModelService;
import org.eclipse.set.feature.plazmodel.table.PlazModelTableView;
import org.eclipse.set.model.planpro.PlanPro.Container_AttributeGroup;
import org.eclipse.set.model.plazmodel.PlazReport;
import org.eclipse.set.model.validationreport.ValidationProblem;
import org.eclipse.set.model.validationreport.ValidationSeverity;
import org.eclipse.set.utils.BasePart;
import org.eclipse.set.utils.SaveAndRefreshAction;
import org.eclipse.set.utils.SelectableAction;
import org.eclipse.set.utils.emfforms.AbstractEmfFormsPart;
import org.eclipse.set.utils.events.ContainerDataChanged;
import org.eclipse.set.utils.events.ProjectDataChanged;
import org.eclipse.set.utils.table.menu.TableMenuService;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class PlazModelPart
extends AbstractEmfFormsPart {
    private Exception createException;
    @Inject
    @Translation
    Messages messages;
    @Inject
    UISynchronize sync;
    @Inject
    PlazModelService plazModelService;
    @Inject
    EnumTranslationService enumTranslationService;
    @Inject
    TableMenuService tableMenuService;
    @Inject
    CacheService cacheService;
    @Inject
    UserConfigurationService userConfigService;
    private PlazModelTableView tableView;
    private PlazReport plazReport;

    @PostConstruct
    private void postConstruct() {
        this.getBroker().subscribe("plazmodel/check", new EventHandler(){

            /*
             * WARNING - void declaration
             */
            public void handleEvent(Event event) {
                Object property = event.getProperty("org.eclipse.e4.data");
                Object object = property;
                if (object instanceof Class) {
                    void clazz;
                    Class clazz2 = (Class)object;
                    Class cfr_ignored_0 = (Class)object;
                    if (PlazCheck.class.isAssignableFrom((Class<?>)clazz)) {
                        PlazReport newReport = PlazModelPart.this.plazModelService.runPlazModel(PlazModelPart.this.getModelSession(), clazz);
                        if (PlazModelPart.this.plazReport == null || PlazModelPart.this.plazReport.getEntries().isEmpty()) {
                            PlazModelPart.this.tableView.updateView(newReport);
                            return;
                        }
                        List<String> objectArts = newReport.getEntries().stream().map(ValidationProblem::getObjectArt).distinct().toList();
                        List<ValidationProblem> oldReports = PlazModelPart.this.plazReport.getEntries().stream().filter(entry -> objectArts.contains(entry.getObjectArt())).toList();
                        PlazModelPart.this.plazReport.getEntries().removeAll(oldReports);
                        PlazModelPart.this.plazReport.getEntries().addAll((Collection)newReport.getEntries());
                        PlazModelService.sortAndIndexedProblems((List<ValidationProblem>)PlazModelPart.this.plazReport.getEntries());
                        PlazModelPart.this.tableView.updateView(PlazModelPart.this.plazReport);
                    }
                }
            }
        });
    }

    protected void createFormsView(Composite parent) throws ECPRendererException {
        this.tableView = new PlazModelTableView((BasePart)this, this.messages, this.tableMenuService, this.enumTranslationService);
        Shell shell = this.getToolboxShell();
        MPart part = this.getToolboxPart();
        DialogService dialogService = this.getDialogService();
        dialogService.showProgressUISync(shell, this.messages.PlaZService_MonitorDisplay_GeneratePlazModel, () -> this.create(parent));
        if (this.createException != null) {
            dialogService.error(shell, this.createException);
            MApplicationElementExtensions.setViewState((MApplicationElement)part, (ToolboxViewState)ToolboxViewState.ERROR);
        }
        if (this.getModelSession().isDirty()) {
            this.setOutdated(true);
        }
        this.getBanderole().setEnableExport(true);
        this.getBanderole().setExportAction(new SelectableAction(){

            public void selected(SelectionEvent e) {
                PlazModelPart.this.tableView.exportCsv();
            }

            public String getText() {
                return PlazModelPart.this.messages.PlazModellPart_ExportTitleMsg;
            }
        });
        this.tableView.createExpandCollapseAllButton((Composite)this.getBanderole().getControl(), this.messages.PlazModellPart_ExpandAllGroup, this.messages.PlazModellPart_CollapseAllGroup);
    }

    private void create(Composite parent) {
        try {
            this.updatePlazModel();
            this.tableView.create(parent, this.plazReport);
            this.createException = null;
        }
        catch (Exception e) {
            this.createException = e;
        }
    }

    private void updatePlazModel() {
        this.plazReport = this.plazModelService.runPlazModel(this.getModelSession());
        this.tableView.updateView(this.plazReport);
        this.setOutdated(false);
        Cache cache = this.cacheService.getCache("toolbox.cache.problem-message");
        List problems = (List)cache.get("plazReport", ArrayList::new);
        problems.clear();
        this.plazReport.getEntries().stream().filter(entry -> entry.getSeverity() != ValidationSeverity.SUCCESS).forEach(entry -> {
            boolean bl = problems.add(new ProblemMessage(entry.getMessage(), entry.getType(), entry.getLineNumber(), 2, entry.getObjectScope().getLiteral()));
        });
        this.getBroker().post("modelsession/change/problems", null);
    }

    protected SelectableAction getOutdatedAction() {
        return new SaveAndRefreshAction((BasePart)this);
    }

    protected void handleContainerDataChanged(ContainerDataChanged e) {
        this.setOutdated(true);
    }

    protected void handleProjectDataChanged(ProjectDataChanged e) {
        this.setOutdated(true);
    }

    protected void updateViewContainerDataChanged(List<Container_AttributeGroup> container) {
        this.updatePlazModel();
    }

    protected void updateViewProjectDataChanged(List<Notification> notifications) {
        this.updatePlazModel();
    }
}

