/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.server.generic;

import java.io.IOException;
import java.io.Serializable;
import java.security.PermissionCollection;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.ecf.core.ContainerTypeDescription;
import org.eclipse.ecf.core.IContainer;
import org.eclipse.ecf.core.IContainerManager;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.identity.IDCreateException;
import org.eclipse.ecf.core.identity.IDFactory;
import org.eclipse.ecf.core.security.IConnectHandlerPolicy;
import org.eclipse.ecf.core.sharedobject.ISharedObjectContainerConfig;
import org.eclipse.ecf.internal.server.generic.Activator;
import org.eclipse.ecf.provider.generic.SOContainerConfig;
import org.eclipse.ecf.provider.generic.SSLServerSOContainer;
import org.eclipse.ecf.provider.generic.SSLServerSOContainerGroup;
import org.eclipse.ecf.server.generic.SSLGenericServerContainer;

public abstract class SSLAbstractGenericServer {
    protected SSLServerSOContainerGroup serverGroup;

    public SSLAbstractGenericServer(String host, int port) {
        this.serverGroup = new SSLServerSOContainerGroup(host, port);
    }

    public SSLGenericServerContainer getFirstServerContainer() {
        return this.getServerContainer(0);
    }

    public List getServerContainers() {
        ArrayList result = new ArrayList();
        Iterator i = this.serverGroup.elements();
        while (i.hasNext()) {
            result.add(i.next());
        }
        return result;
    }

    public SSLGenericServerContainer getServerContainer(int index) {
        return (SSLGenericServerContainer)((Object)this.getServerContainers().get(index));
    }

    protected void putOnTheAir() throws IOException {
        if (!this.serverGroup.isOnTheAir()) {
            this.serverGroup.putOnTheAir();
        }
    }

    protected void takeOffTheAir() {
        if (this.serverGroup.isOnTheAir()) {
            this.serverGroup.takeOffTheAir();
        }
    }

    public synchronized void start(String path, int keepAlive) throws Exception {
        this.createAndInitializeServer(path, keepAlive);
        this.putOnTheAir();
    }

    public synchronized void stop() {
        if (this.serverGroup != null) {
            this.serverGroup.takeOffTheAir();
        }
        List servers = this.getServerContainers();
        for (SSLGenericServerContainer s : servers) {
            s.ejectAllGroupMembers((Serializable)((Object)"Shutting down immediately"));
            s.dispose();
        }
    }

    protected void createAndInitializeServer(String path) throws IDCreateException {
        this.createAndInitializeServer(path, SSLServerSOContainer.DEFAULT_KEEPALIVE);
    }

    protected void createAndInitializeServer(String path, int keepAlive) throws IDCreateException {
        IConnectHandlerPolicy policy;
        if (path == null || path.equals("")) {
            throw new NullPointerException("Cannot create ID with null or empty path");
        }
        SSLGenericServerContainer s = new SSLGenericServerContainer(this, (ISharedObjectContainerConfig)this.createServerConfig(path), this.serverGroup, path, keepAlive);
        IContainerManager containerManager = Activator.getDefault().getContainerManager();
        if (containerManager != null) {
            ContainerTypeDescription ctd = containerManager.getContainerFactory().getDescriptionByName("ecf.generic.server");
            containerManager.addContainer((IContainer)s, ctd);
        }
        if ((policy = this.createConnectHandlerPolicy(s, path)) != null) {
            s.setConnectPolicy(policy);
        }
    }

    protected PermissionCollection checkConnect(Object address, ID fromID, ID targetID, String targetGroup, Object connectData) throws Exception {
        return null;
    }

    protected abstract void handleDisconnect(ID var1);

    protected abstract void handleEject(ID var1);

    protected IConnectHandlerPolicy createConnectHandlerPolicy(SSLGenericServerContainer s, String path) {
        return new IConnectHandlerPolicy(){

            public PermissionCollection checkConnect(Object address, ID fromID, ID targetID, String targetGroup, Object connectData) throws Exception {
                return SSLAbstractGenericServer.this.checkConnect(address, fromID, targetID, targetGroup, connectData);
            }

            public void refresh() {
            }
        };
    }

    protected ID createServerIDFromPath(String path) throws IDCreateException {
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        String id = "ecfssl://" + this.getHost() + ":" + this.getPort() + path;
        return IDFactory.getDefault().createStringID(id);
    }

    protected SOContainerConfig createServerConfig(String path) throws IDCreateException {
        return new SOContainerConfig(this.createServerIDFromPath(path));
    }

    protected String getHost() {
        return this.serverGroup.getName();
    }

    protected int getPort() {
        return this.serverGroup.getPort();
    }
}

